/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.refactoring;

import com.python.pydev.analysis.refactoring.wizards.RefactorProcessFactory;
import com.python.pydev.analysis.refactoring.wizards.rename.PyRenameEntryPoint;
import java.io.IOException;
import java.util.List;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.python.pydev.ast.codecompletion.revisited.visitors.Definition;
import org.python.pydev.ast.item_pointer.ItemPointer;
import org.python.pydev.ast.refactoring.AbstractPyRefactoring;
import org.python.pydev.ast.refactoring.IPyRefactoring;
import org.python.pydev.ast.refactoring.IPyRefactoringRequest;
import org.python.pydev.ast.refactoring.ModuleRenameRefactoringRequest;
import org.python.pydev.ast.refactoring.MultiModuleMoveRefactoringRequest;
import org.python.pydev.ast.refactoring.PyRefactoringRequest;
import org.python.pydev.ast.refactoring.RefactoringRequest;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_ui.EditorUtils;
import org.python.pydev.ui.refactoring.PyRenameRefactoringWizard;

public class PyRenameRefactoring {
    public static String rename(IPyRefactoringRequest request) {
        try {
            RefactoringRequest req;
            List actualRequests = request.getRequests();
            if (actualRequests.size() == 1 && !(req = (RefactoringRequest)actualRequests.get(0)).isModuleRenameRefactoringRequest()) {
                ItemPointer[] pointers;
                IPyRefactoring pyRefactoring = AbstractPyRefactoring.getPyRefactoring();
                ItemPointer[] itemPointerArray = pointers = pyRefactoring.findDefinition(req);
                int n = pointers.length;
                int n2 = 0;
                while (n2 < n) {
                    ItemPointer pointer = itemPointerArray[n2];
                    Definition definition = pointer.definition;
                    if (RefactorProcessFactory.isModuleRename((Definition)definition)) {
                        try {
                            request = new PyRefactoringRequest(new RefactoringRequest[]{new ModuleRenameRefactoringRequest(definition.module.getFile(), req.nature, null)});
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    ++n2;
                }
            }
            PyRenameEntryPoint entryPoint = new PyRenameEntryPoint(request);
            RenameRefactoring renameRefactoring = new RenameRefactoring((RenameProcessor)entryPoint);
            request.fillActivationTokenAndQualifier();
            Object title = "Rename";
            if (request instanceof MultiModuleMoveRefactoringRequest) {
                MultiModuleMoveRefactoringRequest multiModuleMoveRefactoringRequest = (MultiModuleMoveRefactoringRequest)request;
                title = "Move To package (project: " + multiModuleMoveRefactoringRequest.getTarget().getProject().getName() + ")";
            }
            PyRenameRefactoringWizard wizard = new PyRenameRefactoringWizard((Refactoring)renameRefactoring, (String)title, "inputPageDescription", request);
            try {
                RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
                op.run(EditorUtils.getShell(), "Rename Refactor Action");
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return null;
    }
}

