/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.wizards.files;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.ui.wizards.files.AbstractPythonWizardPage;

public abstract class AbstractPythonWizard
extends Wizard
implements INewWizard {
    protected IWorkbench workbench;
    protected IStructuredSelection selection;
    protected String title;
    protected String description = "";
    protected AbstractPythonWizardPage filePage;

    public static void startWizard(AbstractPythonWizard wizard, String title) {
        IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        IStructuredSelection sel = (IStructuredSelection)part.getSite().getSelectionProvider().getSelection();
        AbstractPythonWizard.startWizard(wizard, title, sel);
    }

    public static void startWizard(AbstractPythonWizard wizard, String title, IStructuredSelection sel) {
        IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        wizard.init(part.getSite().getWorkbenchWindow().getWorkbench(), sel);
        wizard.setWindowTitle(title);
        Shell shell = part.getSite().getShell();
        if (shell == null) {
            shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.setPageSize(350, 500);
        dialog.setHelpAvailable(false);
        dialog.create();
        dialog.open();
    }

    public AbstractPythonWizard(String title) {
        this.title = title;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.initializeDefaultPageImageDescriptor();
    }

    protected void initializeDefaultPageImageDescriptor() {
        ImageDescriptor desc = PydevPlugin.imageDescriptorFromPlugin((String)PydevPlugin.getPluginID(), (String)"icons/python_logo.png");
        this.setDefaultPageImageDescriptor(desc);
    }

    public void addPages() {
        this.filePage = this.createPathPage();
        this.filePage.setTitle(this.title);
        this.filePage.setDescription(this.description);
        this.addPage((IWizardPage)this.filePage);
    }

    protected abstract AbstractPythonWizardPage createPathPage();

    public boolean performFinish() {
        IFile file;
        block6: {
            try {
                file = this.doCreateNew((IProgressMonitor)new NullProgressMonitor());
                if (file != null) break block6;
                return true;
            }
            catch (Exception e) {
                Log.log((Throwable)e);
                return false;
            }
        }
        BasicNewResourceWizard.selectAndReveal((IResource)file, (IWorkbenchWindow)this.workbench.getActiveWorkbenchWindow());
        IWorkbenchWindow dw = this.workbench.getActiveWorkbenchWindow();
        try {
            IWorkbenchPage page;
            if (dw != null && (page = dw.getActivePage()) != null) {
                IEditorPart openEditor = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                this.afterEditorCreated(openEditor);
            }
        }
        catch (PartInitException e) {
            Log.log((Throwable)e);
            return false;
        }
        return true;
    }

    protected void afterEditorCreated(IEditorPart openEditor) {
    }

    protected abstract IFile doCreateNew(IProgressMonitor var1) throws CoreException;
}

