/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.wizards.files;

import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.LinkedListWarningOnSlowOperations;
import org.python.pydev.ui.editors.TreeWithAddRemove;
import org.python.pydev.ui.wizards.files.PythonExistingSourceGroup;

public class PythonExistingSourceListGroup
extends PythonExistingSourceGroup {
    private TreeWithAddRemove treeLinkTargets;
    private List<IPath> linkTargets = new LinkedListWarningOnSlowOperations();

    public PythonExistingSourceListGroup(Composite parent, SelectionListener sourceChangeListener) {
        this.createContents(parent, sourceChangeListener);
    }

    protected void createContents(Composite parent, final SelectionListener sourceChangeListener) {
        Label l2 = new Label(parent, 0);
        l2.setText("Project External Source Folders\n\nChoose external folders containing source that should be used for this project.\nThese folders will be automatically added to the PYTHONPATH\n(unless the 'Don't configure PYTHONPATH' option was selected).");
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = false;
        l2.setLayoutData((Object)gd);
        this.treeLinkTargets = new TreeWithAddRemove(parent, 0, null){
            private String sourceFolders;
            {
                super($anonymous0, $anonymous1, $anonymous2);
                this.sourceFolders = "";
            }

            @Override
            protected String getButtonLabel(int i) {
                switch (i) {
                    case 0: {
                        return "Add external source folder";
                    }
                }
                throw new AssertionError((Object)("Unexpected: " + i));
            }

            @Override
            protected void customizeAddSomethingButton(Button addButton, int nButton) {
                super.customizeAddSomethingButton(addButton, nButton);
                if (sourceChangeListener != null) {
                    addButton.addSelectionListener(sourceChangeListener);
                }
            }

            @Override
            protected void customizeRemSourceFolderButton(Button buttonRem) {
                super.customizeRemSourceFolderButton(buttonRem);
                if (sourceChangeListener != null) {
                    buttonRem.addSelectionListener(sourceChangeListener);
                }
            }

            @Override
            protected void handleAddButtonSelected(int nButton) {
                if (nButton == 0) {
                    this.addItemWithDialog(new DirectoryDialog(this.getShell()));
                    IPath selected = this.getSelectedFolder();
                    if (selected != null) {
                        PythonExistingSourceListGroup.this.selectLinkTarget(selected);
                    }
                } else {
                    throw new AssertionError((Object)"Unexpected");
                }
            }

            @Override
            protected void handleRemove() {
                super.handleRemove();
                if (this.folderWasSelected()) {
                    PythonExistingSourceListGroup.this.conflictCheck();
                }
            }

            private IPath getSelectedFolder() {
                if (!this.folderWasSelected()) {
                    return null;
                }
                String linkTarget = this.sourceFolders.substring(this.sourceFolders.lastIndexOf(124) + 1);
                return Path.fromOSString((String)linkTarget);
            }

            private boolean folderWasSelected() {
                String newSourceFolders = StringUtils.leftAndRightTrim((String)PythonExistingSourceListGroup.this.treeLinkTargets.getTreeItemsAsStr(), (char)'|');
                if (this.sourceFolders.equals(newSourceFolders)) {
                    return false;
                }
                this.sourceFolders = newSourceFolders;
                return true;
            }

            @Override
            protected String getImageConstant() {
                return "icons/packagefolder_obj.gif";
            }

            @Override
            protected int getNumberOfAddButtons() {
                return 1;
            }
        };
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.treeLinkTargets.setLayoutData(data);
    }

    @Override
    protected void selectLinkTarget(IPath linkPath) {
        if (this.validateLinkPath(linkPath)) {
            this.linkTargets.add(linkPath);
        }
    }

    @Override
    protected boolean validateLinkPath(IPath linkPath) {
        if (!super.validateLinkPath(linkPath)) {
            return false;
        }
        for (IPath otherPath : this.linkTargets) {
            if (!FileUtils.isPrefixOf((IPath)linkPath, (IPath)otherPath) && !FileUtils.isPrefixOf((IPath)otherPath, (IPath)linkPath)) continue;
            this.warningMessage = "Location '" + linkPath.lastSegment() + "' overlaps with the selected resource '" + otherPath.lastSegment() + "'. This can cause unexpected side-effects.";
            break;
        }
        return true;
    }

    @Override
    protected void conflictCheck() {
        this.linkTargets.clear();
        this.clearAllProblems();
        String sourceFolders = StringUtils.leftAndRightTrim((String)this.treeLinkTargets.getTreeItemsAsStr(), (char)'|');
        if (sourceFolders.equals("")) {
            return;
        }
        for (String pathString : StringUtils.splitAndRemoveEmptyTrimmed((String)sourceFolders, (char)'|')) {
            this.selectLinkTarget(Path.fromOSString((String)pathString));
        }
    }

    public List<IPath> getLinkTargets() {
        return this.linkTargets;
    }

    @Override
    public IPath getLinkTarget() {
        if (this.linkTargets.size() == 0) {
            return null;
        }
        return this.linkTargets.get(this.linkTargets.size() - 1);
    }
}

