/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.console;

import java.io.IOException;
import java.lang.ref.WeakReference;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.console.PromptOverlay;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.shared_ui.utils.UIUtils;

public class SetBufferedOutputAction
extends Action
implements IPropertyChangeListener {
    private WeakReference<PromptOverlay> promptOverlay;
    private IPreferenceStore preferences;

    public SetBufferedOutputAction(WeakReference<PromptOverlay> promptOverlay) {
        this.promptOverlay = promptOverlay;
        this.setText("Output Mode: Async main console");
        this.preferences = PydevDebugPlugin.getDefault().getPreferenceStore();
        this.preferences.addPropertyChangeListener((IPropertyChangeListener)this);
        this.update();
    }

    private void update() {
        PromptOverlay overlay = (PromptOverlay)this.promptOverlay.get();
        if (overlay == null) {
            return;
        }
        int val = this.preferences.getInt("CONSOLE_PROMPT_OUTPUT_MODE");
        if (val == 1) {
            this.setText("Output Mode: Async main console");
            overlay.setBufferedOutput(false);
        } else {
            this.setText("Output Mode: Sync same console");
            overlay.setBufferedOutput(true);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("CONSOLE_PROMPT_OUTPUT_MODE".equals(event.getProperty())) {
            this.update();
        }
    }

    public void run() {
        PromptOverlay overlay = (PromptOverlay)this.promptOverlay.get();
        if (overlay == null || this.preferences == null) {
            return;
        }
        int curr = this.preferences.getInt("CONSOLE_PROMPT_OUTPUT_MODE");
        int retVal = new MessageDialog(UIUtils.getActiveShell(), "Mode for command output", null, "Please choose the mode for the command output", 3, new String[]{"Output Asynchronous in main console view", "Output synchronous in console prompt view"}, curr == 1 ? 0 : 1).open();
        if (retVal == 0) {
            this.preferences.setValue("CONSOLE_PROMPT_OUTPUT_MODE", 1);
            this.savePrefs();
        } else if (retVal == 1) {
            this.preferences.setValue("CONSOLE_PROMPT_OUTPUT_MODE", 2);
            this.savePrefs();
        }
    }

    private void savePrefs() {
        if (this.preferences instanceof IPersistentPreferenceStore) {
            try {
                ((IPersistentPreferenceStore)this.preferences).save();
            }
            catch (IOException e) {
                Log.log((Throwable)e);
            }
        }
    }

    public void dispose() {
        if (this.preferences != null) {
            this.preferences.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        this.preferences = null;
        this.setEnabled(false);
    }
}

