/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.LineBreakpoint;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.ast.codecompletion.revisited.modules.AbstractModule;
import org.python.pydev.ast.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.ast.interpreter_managers.InterpreterManagersAPI;
import org.python.pydev.core.BaseModuleRequest;
import org.python.pydev.core.FileUtilsFileBuffer;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModuleRequestState;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.model.PyDebugModelPresentation;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.structure.Tuple;

public class PyBreakpoint
extends LineBreakpoint {
    public static final String PY_BREAK_EXTERNAL_PATH_ID = "org.python.pydev.debug.PYDEV_EXTERNAL_PATH_ID";
    public static final String PY_BREAK_TYPE = "org.python.pydev.debug.PY_BREAK_TYPE";
    public static final String PY_BREAK_TYPE_PYTHON = "python-line";
    public static final String PY_BREAK_TYPE_DJANGO = "django-line";
    public static final String PY_BREAK_MARKER = "org.python.pydev.debug.pyStopBreakpointMarker";
    public static final String DJANGO_BREAK_MARKER = "org.python.pydev.debug.djangoStopBreakpointMarker";
    public static final String PY_CONDITIONAL_BREAK_MARKER = "org.python.pydev.debug.pyConditionalStopBreakpointMarker";
    protected static final String CONDITION = "org.python.pydev.debug.condition";
    protected static final String CONDITION_ENABLED = "org.python.pydev.debug.conditionEnabled";
    public static int nextId = 0;
    public static final Object lock = new Object();
    public final int breakpointId;
    private String functionName;
    private long lastModifiedTimeCached;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PyBreakpoint() {
        Object object = lock;
        synchronized (object) {
            this.breakpointId = nextId++;
        }
    }

    public String getModelIdentifier() {
        return PyDebugModelPresentation.PY_DEBUG_MODEL_ID;
    }

    public String getFile() {
        IMarker marker = this.getMarker();
        IResource r = marker.getResource();
        if (r instanceof IFile) {
            IPath location = r.getLocation();
            if (location == null) {
                return null;
            }
            return location.toOSString();
        }
        try {
            return (String)marker.getAttribute(PY_BREAK_EXTERNAL_PATH_ID);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    private IDocument getDocument() {
        IMarker marker = this.getMarker();
        IResource r = marker.getResource();
        if (r instanceof IFile) {
            return FileUtilsFileBuffer.getDocFromResource((IResource)r);
        }
        try {
            return FileUtilsFileBuffer.getDocFromFile((File)new File((String)marker.getAttribute(PY_BREAK_EXTERNAL_PATH_ID)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private IPythonNature getPythonNature() {
        IMarker marker = this.getMarker();
        PythonNature nature = PythonNature.getPythonNature((IResource)marker.getResource());
        if (nature == null) {
            try {
                Tuple infoForFile;
                String externalPath = (String)marker.getAttribute(PY_BREAK_EXTERNAL_PATH_ID);
                if (externalPath != null && (infoForFile = InterpreterManagersAPI.getInfoForFile((File)new File(externalPath))) != null) {
                    nature = (IPythonNature)infoForFile.o1;
                }
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
        return nature;
    }

    public String getType() {
        IMarker marker = this.getMarker();
        Object attribute = null;
        if (marker != null) {
            try {
                attribute = marker.getAttribute(PY_BREAK_TYPE);
            }
            catch (CoreException e) {
                Log.log((Throwable)e);
            }
        }
        if (attribute != null && (attribute.equals(PY_BREAK_TYPE_DJANGO) || attribute.equals(PY_BREAK_TYPE_PYTHON))) {
            return (String)attribute;
        }
        return PY_BREAK_TYPE_PYTHON;
    }

    public Object getLine() {
        try {
            return this.getMarker().getAttribute("lineNumber");
        }
        catch (CoreException e) {
            return "";
        }
    }

    public boolean supportsCondition() {
        return true;
    }

    public String getCondition() throws DebugException {
        return this.ensureMarker().getAttribute(CONDITION, null);
    }

    public boolean isConditionEnabled() throws DebugException {
        return this.ensureMarker().getAttribute(CONDITION_ENABLED, false);
    }

    public void setConditionEnabled(boolean conditionEnabled) throws CoreException {
        this.setAttributes(new String[]{CONDITION_ENABLED}, new Object[]{conditionEnabled});
    }

    public void setCondition(String condition) throws CoreException {
        if (condition != null && condition.trim().length() == 0) {
            condition = null;
        }
        this.setAttributes(new String[]{CONDITION}, new Object[]{condition});
    }

    protected IMarker ensureMarker() throws DebugException {
        IMarker m = this.getMarker();
        if (m == null || !m.exists()) {
            throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5012, "Breakpoint_no_associated_marker", null));
        }
        return m;
    }

    public String getFunctionName() {
        ICodeCompletionASTManager astManager;
        IPythonNature nature;
        File file;
        String fileStr;
        block15: {
            block14: {
                fileStr = this.getFile();
                File file2 = file = fileStr != null ? new File(fileStr) : null;
                if (file == null || !file.exists()) {
                    return "None";
                }
                if (FileUtils.lastModified((File)file) == this.lastModifiedTimeCached) {
                    return this.functionName;
                }
                nature = this.getPythonNature();
                if (nature != null) break block14;
                this.lastModifiedTimeCached = 0L;
                return "None";
            }
            astManager = nature.getAstManager();
            if (astManager != null) break block15;
            this.lastModifiedTimeCached = 0L;
            return "None";
        }
        try {
            if (nature.startRequests()) {
                SourceModule sourceModule = null;
                try {
                    IModule module;
                    String modName = nature.resolveModule(fileStr);
                    if (modName != null && (module = astManager.getModule(modName, nature, true, (IModuleRequestState)new BaseModuleRequest(true))) instanceof SourceModule) {
                        sourceModule = (SourceModule)module;
                    }
                }
                finally {
                    nature.endRequests();
                }
                this.lastModifiedTimeCached = FileUtils.lastModified((File)file);
                if (sourceModule == null) {
                    IDocument doc = this.getDocument();
                    sourceModule = AbstractModule.createModuleFromDoc((String)"", (File)file, (IDocument)doc, (IPythonNature)nature, (boolean)true);
                }
                int lineToUse = this.getLineNumber() - 1;
                if (sourceModule == null || sourceModule.getAst() == null || lineToUse < 0) {
                    this.functionName = "None";
                    return this.functionName;
                }
                SimpleNode ast = sourceModule.getAst();
                this.functionName = NodeUtils.getContextName((int)lineToUse, (SimpleNode)ast);
                if (this.functionName == null) {
                    this.functionName = "";
                }
                return this.functionName;
            }
            this.functionName = "None";
        }
        catch (Exception e) {
            Log.log((String)("Error determining breakpoint context. Breakpoint at: " + String.valueOf(file) + " will match any context."), (Throwable)e);
            this.functionName = "None";
        }
        return this.functionName;
    }
}

