/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.IContributorResourceAdapter;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.tasklist.ITaskListResourceAdapter;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.AdapterDebug;
import org.python.pydev.debug.model.PyBreakpoint;
import org.python.pydev.debug.model.PyStackFrame;
import org.python.pydev.debug.model.SmartStepIntoVariant;
import org.python.pydev.debug.model.remote.RunToLineCommand;
import org.python.pydev.debug.model.remote.SetNextCommand;
import org.python.pydev.debug.model.remote.SmartStepIntoCommand;
import org.python.pydev.debug.model.remote.StepCommand;
import org.python.pydev.debug.model.remote.ThreadRunCommand;
import org.python.pydev.debug.model.remote.ThreadSuspendCommand;
import org.python.pydev.editor.PyEdit;

public class PyThread
extends PlatformObject
implements IThread {
    private AbstractDebugTarget target;
    private String name;
    private String id;
    private final boolean isPydevThread;
    public final boolean isCustomFrame;
    private boolean isSuspended = false;
    private boolean isStepping = false;
    private IStackFrame[] stack;

    public PyThread(AbstractDebugTarget target, String name, String id) {
        this.target = target;
        this.name = name;
        this.id = id;
        this.isPydevThread = id.equals("-1");
        this.isCustomFrame = id.startsWith("__frame__:");
    }

    public void setSuspended(boolean state, IStackFrame[] stack) {
        this.isSuspended = state;
        if (stack != null) {
            this.stack = stack;
        }
    }

    public String getName() throws DebugException {
        return this.name + " - " + this.getId();
    }

    public String getId() {
        return this.id;
    }

    public boolean isPydevThread() {
        return this.isPydevThread;
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public String getModelIdentifier() {
        return this.target.getModelIdentifier();
    }

    public IDebugTarget getDebugTarget() {
        return this.target;
    }

    public ILaunch getLaunch() {
        return this.target.getLaunch();
    }

    public boolean canTerminate() {
        return !this.isPydevThread && !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.target.isTerminated();
    }

    public void terminate() throws DebugException {
        this.target.terminate();
    }

    public boolean canResume() {
        return !this.isPydevThread && this.isSuspended && !this.isTerminated() && !this.isCustomFrame;
    }

    public boolean canSuspend() {
        return !this.isPydevThread && !this.isSuspended && !this.isTerminated() && !this.isCustomFrame;
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    public void resume() throws DebugException {
        if (!this.isPydevThread) {
            this.isStepping = false;
            this.target.postCommand(new ThreadRunCommand(this.target, this.id));
        }
    }

    public void suspend() throws DebugException {
        if (!this.isPydevThread) {
            this.target.postCommand(new ThreadSuspendCommand(this.target, this.id));
        }
    }

    public boolean canStepInto() {
        return this.canResume();
    }

    public boolean canStepOver() {
        return this.canResume();
    }

    public boolean canStepReturn() {
        return this.canResume();
    }

    public boolean isStepping() {
        return this.isStepping;
    }

    public void stepInto() throws DebugException {
        if (!this.isPydevThread) {
            this.isStepping = true;
            this.target.postCommand(new StepCommand(this.target, 107, this.id));
        }
    }

    public void stepIntoTarget(PyEdit pyEdit, int line, String selectedWord, SmartStepIntoVariant stepIntoTarget) {
        if (!this.isPydevThread) {
            this.isStepping = true;
            this.target.postCommand(new SmartStepIntoCommand(this.target, 128, this.id, line, selectedWord, stepIntoTarget));
        }
    }

    public void stepOver() throws DebugException {
        if (!this.isPydevThread) {
            this.isStepping = true;
            this.target.postCommand(new StepCommand(this.target, 108, this.id));
        }
    }

    public void stepReturn() throws DebugException {
        if (!this.isPydevThread) {
            this.isStepping = true;
            this.target.postCommand(new StepCommand(this.target, 109, this.id));
        }
    }

    public void runToLine(int line, String funcName) {
        this.isStepping = true;
        this.target.postCommand(new RunToLineCommand(this.target, 118, this.id, line, funcName));
    }

    public void setNextStatement(int line, String funcName) {
        this.isStepping = true;
        this.target.postCommand(new SetNextCommand(this.target, 127, this.id, line, funcName));
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        if (this.isSuspended && this.stack != null) {
            return this.stack;
        }
        return new IStackFrame[0];
    }

    public boolean hasStackFrames() throws DebugException {
        return this.stack != null && this.stack.length > 0;
    }

    public IStackFrame getTopStackFrame() {
        return this.stack == null || this.stack.length == 0 ? null : this.stack[0];
    }

    public PyStackFrame findStackFrameByID(String id) {
        if (this.stack != null) {
            int i = 0;
            while (i < this.stack.length) {
                if (id.equals(((PyStackFrame)this.stack[i]).getId())) {
                    return (PyStackFrame)this.stack[i];
                }
                ++i;
            }
        }
        return null;
    }

    public IBreakpoint[] getBreakpoints() {
        PyBreakpoint[] breaks = new PyBreakpoint[]{};
        return breaks;
    }

    public <T> T getAdapter(Class<T> adapter) {
        AdapterDebug.print((Object)this, adapter);
        if (adapter.equals(ILaunch.class) || adapter.equals(IResource.class)) {
            return this.target.getAdapter(adapter);
        }
        if (adapter.equals(ITaskListResourceAdapter.class)) {
            return null;
        }
        if (adapter.equals(IDebugTarget.class)) {
            return (T)this.target;
        }
        if (adapter.equals(IRunToLineTarget.class)) {
            return (T)this.target.getRunToLineTarget();
        }
        if (adapter.equals(IPropertySource.class) || adapter.equals(ITaskListResourceAdapter.class) || adapter.equals(IToggleBreakpointsTarget.class) || adapter.equals(IContributorResourceAdapter.class) || adapter.equals(IWorkbenchAdapter.class) || adapter.equals(IActionFilter.class)) {
            return (T)super.getAdapter(adapter);
        }
        AdapterDebug.printDontKnow((Object)this, adapter);
        return (T)super.getAdapter(adapter);
    }

    public String toString() {
        return "PyThread: " + this.id;
    }
}

