/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.ContainerOfVariables;
import org.python.pydev.debug.model.IVariableLocator;
import org.python.pydev.debug.model.IVariablesContainerParent;
import org.python.pydev.debug.model.PyVariable;
import org.python.pydev.debug.model.PyVariableGroup;
import org.python.pydev.debug.model.XMLUtils;
import org.python.pydev.debug.model.remote.AbstractDebuggerCommand;
import org.python.pydev.debug.model.remote.GetVariableCommand;

public class PyVariableCollection
extends PyVariable
implements IVariablesContainerParent {
    private final ContainerOfVariables variableContainer = new ContainerOfVariables(this, false);
    public static final String SCOPE_SPECIAL_VARS = "special variables";
    public static final String SCOPE_PROTECTED_VARS = "protected variables";
    public static final String SCOPE_CLASS_VARS = "class variables";
    public static final String SCOPE_FUNCTION_VARS = "function variables";
    private static final String[] SCOPES_SORTED_REVERSED = new String[]{"function variables", "class variables", "protected variables", "special variables"};

    public PyVariableCollection(AbstractDebugTarget target, String name, String type, String value, IVariableLocator locator, String scope) {
        super(target, name, type, value, locator, scope);
    }

    @Override
    public String getDetailText() throws DebugException {
        return super.getDetailText();
    }

    public static PyVariable[] getCommandVariables(AbstractDebuggerCommand cmd, AbstractDebugTarget target, IVariableLocator locator) {
        PyVariable[] tempVariables;
        block10: {
            tempVariables = new PyVariable[]{};
            try {
                List<PyVariable> list;
                String payload = ((GetVariableCommand)cmd).getResponse();
                tempVariables = XMLUtils.XMLToVariables(target, locator, payload);
                HashMap<String, ArrayList<PyVariable>> scopedVars = new HashMap<String, ArrayList<PyVariable>>();
                ArrayList<PyVariable> otherVars = new ArrayList<PyVariable>(tempVariables.length);
                Object[] objectArray = tempVariables;
                int n = tempVariables.length;
                int n2 = 0;
                while (n2 < n) {
                    PyVariable v = objectArray[n2];
                    if (v.scope != null && v.scope.length() > 0) {
                        list = (ArrayList<PyVariable>)scopedVars.get(v.scope);
                        if (list == null) {
                            list = new ArrayList<PyVariable>();
                            scopedVars.put(v.scope, (ArrayList<PyVariable>)list);
                        }
                        list.add(v);
                    } else {
                        otherVars.add(v);
                    }
                    ++n2;
                }
                if (!scopedVars.isEmpty()) {
                    objectArray = SCOPES_SORTED_REVERSED;
                    n = SCOPES_SORTED_REVERSED.length;
                    n2 = 0;
                    while (n2 < n) {
                        Object scope = objectArray[n2];
                        list = (List)scopedVars.remove(scope);
                        if (list != null && list.size() > 0) {
                            PyVariableGroup element = new PyVariableGroup(target, (String)scope, "", "", locator.getThreadId(), "", locator.getUniqueId());
                            element.setVariables(list);
                            otherVars.add(0, element);
                        }
                        ++n2;
                    }
                    for (Map.Entry entry : scopedVars.entrySet()) {
                        Log.log((String)("Unexpected scope: " + (String)entry.getKey()));
                        List list2 = (List)entry.getValue();
                        PyVariableGroup element = new PyVariableGroup(target, (String)entry.getKey(), "", "", locator.getThreadId(), "", locator.getUniqueId());
                        element.setVariables(list2);
                        otherVars.add(0, element);
                    }
                    tempVariables = otherVars.toArray(new PyVariable[0]);
                }
            }
            catch (CoreException e) {
                tempVariables = new PyVariable[]{new PyVariable(target, "Error", "pydev ERROR", "Could not resolve variable", locator, "")};
                String msg = e.getMessage();
                if (msg != null && (msg.indexOf("Error resolving frame:") != -1 || msg.indexOf("from thread:") != -1)) break block10;
                PydevDebugPlugin.log(4, "Error fetching a variable", e);
            }
        }
        return tempVariables;
    }

    @Override
    public IVariable[] getVariables() throws DebugException {
        return this.variableContainer.getVariables();
    }

    @Override
    public GetVariableCommand getVariableCommand(AbstractDebugTarget dbg) {
        return new GetVariableCommand(dbg, this.getPyDBLocation());
    }

    @Override
    public void forceGetNewVariables() {
        this.variableContainer.forceGetNewVariables();
    }

    @Override
    public boolean hasVariables() throws DebugException {
        return true;
    }

    @Override
    public String getReferenceTypeName() throws DebugException {
        return this.type;
    }

    @Override
    public AbstractDebugTarget getTarget() {
        return this.target;
    }

    @Override
    public IVariableLocator getGlobalLocator() {
        return null;
    }
}

