/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model.remote;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.model.remote.AbstractDebuggerCommand;

public class DebuggerWriter
implements Runnable {
    private Socket socket;
    private BlockingQueue<AbstractDebuggerCommand> cmdQueue = new ArrayBlockingQueue<AbstractDebuggerCommand>(64);
    private OutputStreamWriter out;
    private volatile boolean done = false;

    public DebuggerWriter(Socket s) throws IOException {
        this.socket = s;
        this.out = new OutputStreamWriter(s.getOutputStream(), StandardCharsets.UTF_8);
    }

    public void postCommand(AbstractDebuggerCommand cmd) {
        this.cmdQueue.offer(cmd);
    }

    public void done() {
        this.done = true;
    }

    @Override
    public void run() {
        while (!this.done) {
            block9: {
                AbstractDebuggerCommand cmd = null;
                try {
                    cmd = this.cmdQueue.poll(100L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    cmd = null;
                    Log.log((Throwable)e);
                }
                try {
                    String outgoing;
                    block10: {
                        if (cmd == null) break block9;
                        try {
                            outgoing = cmd.getOutgoing();
                            if (outgoing == null) {
                            }
                            break block10;
                        }
                        catch (Throwable e) {
                            Log.log((Throwable)e);
                        }
                        continue;
                    }
                    cmd.aboutToSend();
                    this.out.write(outgoing);
                    this.out.write("\n");
                    this.out.flush();
                }
                catch (IOException e) {
                    this.done = true;
                }
                catch (Throwable e1) {
                    Log.log((Throwable)e1);
                }
            }
            if (this.socket != null && this.socket.isConnected()) continue;
            this.done = true;
        }
    }
}

