/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.newconsole;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.PyStackFrame;
import org.python.pydev.debug.model.remote.AbstractDebuggerCommand;
import org.python.pydev.debug.model.remote.EvaluateConsoleExpressionCommand;
import org.python.pydev.debug.model.remote.ICommandResponseListener;
import org.python.pydev.shared_core.string.StringUtils;

public class EvaluateDebugConsoleExpression
implements ICommandResponseListener {
    String EMPTY = "";
    private String payload;
    private final PyStackFrame frame;

    public EvaluateDebugConsoleExpression(PyStackFrame frame) {
        Assert.isNotNull((Object)frame);
        this.frame = frame;
    }

    @Override
    public void commandComplete(AbstractDebuggerCommand cmd) {
        try {
            this.payload = ((EvaluateConsoleExpressionCommand)cmd).getResponse();
        }
        catch (CoreException e) {
            this.payload = e.getMessage();
        }
    }

    public void executeCommand(String command, boolean bufferedOutput) {
        AbstractDebugTarget target = this.frame.getTarget();
        String locator = this.getLocator(this.frame.getThreadId(), this.frame.getId(), bufferedOutput ? "EVALUATE" : "EVALUATE_UNBUFFERED", command);
        EvaluateConsoleExpressionCommand cmd = new EvaluateConsoleExpressionCommand(target, locator, new ICommandResponseListener(){

            @Override
            public void commandComplete(AbstractDebuggerCommand cmd) {
                EvaluateDebugConsoleExpression.this.frame.forceGetNewVariables();
                EvaluateDebugConsoleExpression.this.commandComplete(cmd);
            }
        });
        target.postCommand(cmd);
    }

    public String getCompletions(String actTok, int offset) {
        AbstractDebugTarget target = this.frame.getTarget();
        String locator = this.getLocator(this.frame.getThreadId(), this.frame.getId(), "GET_COMPLETIONS", actTok);
        EvaluateConsoleExpressionCommand cmd = new EvaluateConsoleExpressionCommand(target, locator, this);
        target.postCommand(cmd);
        return this.waitForCommand();
    }

    public String waitForCommand() {
        int timeout = 500;
        while (--timeout > 0 && this.payload == null) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        String temp = this.payload;
        this.payload = null;
        if (temp == null) {
            Log.logInfo((String)"Timeout for waiting for command to return elapsed (3 seconds).");
            return this.EMPTY;
        }
        return temp;
    }

    private String getLocator(String ... locators) {
        return StringUtils.join((String)"\t", (String[])locators);
    }

    public static class PydevDebugConsoleMessage {
        private boolean more;
        private StringBuilder outputMessage = new StringBuilder();
        private StringBuilder errorMessage = new StringBuilder();

        public boolean isMore() {
            return this.more;
        }

        public void setMore(boolean more) {
            this.more = more;
        }

        public void appendMessage(String output, boolean isError) {
            if (!isError) {
                this.outputMessage.append(output);
                this.outputMessage.append("\n");
            } else {
                this.errorMessage.append(output);
                this.errorMessage.append("\n");
            }
        }

        public StringBuilder getOutputMessage() {
            return this.outputMessage;
        }

        public StringBuilder getErrorMessage() {
            return this.errorMessage;
        }
    }
}

