/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.newconsole.prefs;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.string.StringUtils;

public class ColorManager {
    private static ColorManager fgColorManager;
    protected Map<RGB, Color> fColorTable = new HashMap<RGB, Color>(10);
    public static final RGB dimBlack;
    public static final RGB dimRed;
    public static final RGB dimGreen;
    public static final RGB dimYellow;
    public static final RGB dimBlue;
    public static final RGB dimMagenta;
    public static final RGB dimCyan;
    public static final RGB dimWhite;
    public static final RGB brightBlack;
    public static final RGB brightRed;
    public static final RGB brightGreen;
    public static final RGB brightYellow;
    public static final RGB brightBlue;
    public static final RGB brightMagenta;
    public static final RGB brightCyan;
    public static final RGB brightWhite;

    static {
        dimBlack = new RGB(0, 0, 0);
        dimRed = new RGB(205, 0, 0);
        dimGreen = new RGB(0, 205, 0);
        dimYellow = new RGB(205, 205, 0);
        dimBlue = new RGB(0, 0, 238);
        dimMagenta = new RGB(205, 0, 205);
        dimCyan = new RGB(0, 205, 205);
        dimWhite = new RGB(229, 229, 229);
        brightBlack = new RGB(127, 127, 127);
        brightRed = new RGB(255, 0, 0);
        brightGreen = new RGB(0, 252, 0);
        brightYellow = new RGB(255, 255, 0);
        brightBlue = new RGB(0, 0, 252);
        brightMagenta = new RGB(255, 0, 255);
        brightCyan = new RGB(0, 255, 255);
        brightWhite = new RGB(255, 255, 255);
    }

    private ColorManager() {
    }

    public static ColorManager getDefault() {
        if (fgColorManager == null) {
            fgColorManager = new ColorManager();
        }
        return fgColorManager;
    }

    public TextAttribute getAnsiTextAttribute(String str, TextAttribute prevAttribute, TextAttribute resetAttribute) {
        int foundM;
        if (str.startsWith("[")) {
            str = str.substring(1);
        }
        if ((foundM = str.indexOf(109)) == -1) {
            return prevAttribute;
        }
        if ((str = str.substring(0, foundM)).equals("0")) {
            return resetAttribute;
        }
        boolean bright = false;
        Color foreground = null;
        Color background = null;
        List split = StringUtils.split((String)str, (char)';');
        for (String string : split) {
            try {
                int parsed = Integer.parseInt(string);
                switch (parsed) {
                    case 0: {
                        bright = false;
                        break;
                    }
                    case 1: {
                        bright = true;
                        break;
                    }
                    case 30: {
                        foreground = this.getColor(bright ? brightBlack : dimBlack);
                        break;
                    }
                    case 31: {
                        foreground = this.getColor(bright ? brightRed : dimRed);
                        break;
                    }
                    case 32: {
                        foreground = this.getColor(bright ? brightGreen : dimGreen);
                        break;
                    }
                    case 33: {
                        foreground = this.getColor(bright ? brightYellow : dimYellow);
                        break;
                    }
                    case 34: {
                        foreground = this.getColor(bright ? brightBlue : dimBlue);
                        break;
                    }
                    case 35: {
                        foreground = this.getColor(bright ? brightMagenta : dimMagenta);
                        break;
                    }
                    case 36: {
                        foreground = this.getColor(bright ? brightCyan : dimCyan);
                        break;
                    }
                    case 37: {
                        foreground = this.getColor(bright ? brightWhite : dimWhite);
                        break;
                    }
                    case 40: {
                        background = this.getColor(bright ? brightBlack : dimBlack);
                        break;
                    }
                    case 41: {
                        background = this.getColor(bright ? brightRed : dimRed);
                        break;
                    }
                    case 42: {
                        background = this.getColor(bright ? brightGreen : dimGreen);
                        break;
                    }
                    case 43: {
                        background = this.getColor(bright ? brightYellow : dimYellow);
                        break;
                    }
                    case 44: {
                        background = this.getColor(bright ? brightBlue : dimBlue);
                        break;
                    }
                    case 45: {
                        background = this.getColor(bright ? brightMagenta : dimMagenta);
                        break;
                    }
                    case 46: {
                        background = this.getColor(bright ? brightCyan : dimCyan);
                        break;
                    }
                    case 47: {
                        background = this.getColor(bright ? brightWhite : dimWhite);
                        break;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new TextAttribute(foreground != null ? foreground : prevAttribute.getForeground(), background != null ? background : prevAttribute.getBackground(), prevAttribute.getStyle());
    }

    public Color getColor(RGB rgb) {
        Color color;
        Display current = Display.getCurrent();
        if (current == null) {
            Log.log((String)"Should not try to get color in a non-ui thread (it will fail if the color is not cached!)");
        }
        if ((color = this.fColorTable.get(rgb)) == null) {
            color = new Color((Device)current, rgb);
            this.fColorTable.put(rgb, color);
        }
        return color;
    }

    public void dispose() {
        Iterator<Color> e = this.fColorTable.values().iterator();
        while (e.hasNext()) {
            e.next().dispose();
        }
    }

    public Color getPreferenceColor(String type) {
        if (SharedCorePlugin.inTestMode()) {
            return null;
        }
        PydevDebugPlugin plugin = PydevDebugPlugin.getDefault();
        IPreferenceStore preferenceStore = plugin.getPreferenceStore();
        return this.getColor(PreferenceConverter.getColor((IPreferenceStore)preferenceStore, (String)type));
    }

    public TextAttribute getConsoleErrorTextAttribute() {
        Color color = this.getPreferenceColor("pydevconsole_syserr_color");
        return new TextAttribute(color, null, 0);
    }

    public TextAttribute getConsoleOutputTextAttribute() {
        Color color = this.getPreferenceColor("pydevconsole_sysout_color");
        return new TextAttribute(color, null, 0);
    }

    public TextAttribute getConsoleInputTextAttribute() {
        Color color = this.getPreferenceColor("pydevconsole_sysin_color");
        return new TextAttribute(color, null, 0);
    }

    public TextAttribute getConsolePromptTextAttribute() {
        Color color = this.getPreferenceColor("pydevconsole_prompt_color");
        return new TextAttribute(color, null, 0);
    }

    public Color getConsoleBackgroundColor() {
        Color color = this.getPreferenceColor("pydevconsole_background_color");
        return color;
    }

    public Color getDebugConsoleBackgroundColor() {
        Color color = this.getPreferenceColor("pydevdebugconsole_background_color");
        return color;
    }

    public TextAttribute getHyperlinkTextAttribute() {
        return null;
    }

    public TextAttribute getForegroundTextAttribute() {
        return null;
    }
}

