/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.pyunit;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_ui.ImageCache;

public class CounterPanel
extends Composite {
    public final Text fNumberOfErrors;
    public final Text fNumberOfFailures;
    public final Text fNumberOfRuns;
    private final Image fErrorIcon = ImageCache.asImage((IImageHandle)PydevDebugPlugin.getImageCache().get("icons/ovr16/error_ovr.gif"));
    private final Image fFailureIcon = ImageCache.asImage((IImageHandle)PydevDebugPlugin.getImageCache().get("icons/ovr16/failed_ovr.gif"));

    public CounterPanel(Composite parent) {
        super(parent, 64);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.fNumberOfRuns = this.createLabel("Runs: ", null, "0/0", "Test Run/Tests Collected");
        this.fNumberOfErrors = this.createLabel("", this.fErrorIcon, "0", "Errors");
        this.fNumberOfFailures = this.createLabel("", this.fFailureIcon, "0", "Failures");
    }

    private Text createLabel(String name, Image image, String init, String tooltip) {
        Label label;
        if (image != null) {
            label = new Label((Composite)this, 0);
            if (image != null) {
                image.setBackground(label.getBackground());
                label.setImage(image);
            }
            label.setToolTipText(tooltip);
            GridData gridData = new GridData(32);
            gridData.minimumWidth = 14;
            label.setLayoutData((Object)gridData);
        }
        if (name.length() > 0) {
            label = new Label((Composite)this, 0);
            label.setText(name);
            GridData data = new GridData(32);
            data.minimumWidth = 20;
            label.setLayoutData((Object)data);
        }
        Text value = new Text((Composite)this, 8);
        value.setToolTipText(tooltip);
        value.setText(init);
        value.setBackground(this.getDisplay().getSystemColor(22));
        GridData data = new GridData(800);
        data.minimumWidth = 25;
        value.setLayoutData((Object)data);
        return value;
    }

    public void reset() {
        this.setErrorValue(0);
        this.setFailureValue(0);
        this.setRunValue(0, "0");
    }

    public void setRunValue(int value, String total) {
        String runString = Integer.toString(value) + " / " + total;
        this.fNumberOfRuns.setText(runString);
        this.fNumberOfRuns.redraw();
        this.redraw();
    }

    public void setErrorValue(int value) {
        this.fNumberOfErrors.setText(Integer.toString(value));
        this.redraw();
    }

    public void setFailureValue(int value) {
        this.fNumberOfFailures.setText(Integer.toString(value));
        this.redraw();
    }
}

