/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.pyunit;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.ISourceLocator;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.console_actions.RestartLaunchAction;
import org.python.pydev.debug.model.PySourceLocator;
import org.python.pydev.debug.model.XMLUtils;
import org.python.pydev.debug.pyunit.IPyUnitLaunch;
import org.python.pydev.debug.pyunit.PyUnitTestResult;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PyUnitLaunch
implements IPyUnitLaunch {
    private final ILaunchConfiguration configuration;
    private final ILaunch launch;

    public PyUnitLaunch(ILaunch launch, ILaunchConfiguration configuration) {
        this.launch = launch;
        this.configuration = configuration;
    }

    @Override
    public ILaunchConfiguration getLaunchConfiguration() {
        return this.configuration;
    }

    @Override
    public void fillXMLElement(Document document, Element launchElement) {
        try {
            if (this.launch != null) {
                launchElement.setAttribute("mode", this.launch.getLaunchMode());
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        try {
            if (this.configuration != null) {
                launchElement.appendChild(XMLUtils.createBinaryElement(document, "launch_memento", this.configuration.getMemento()));
            }
        }
        catch (CoreException e) {
            Log.log((Throwable)e);
        }
    }

    public static IPyUnitLaunch fromIO(String mode, String memento) {
        if (memento != null && mode != null && mode.length() > 0 && memento.length() > 0) {
            try {
                ILaunchConfiguration launchConfiguration = DebugPlugin.getDefault().getLaunchManager().getLaunchConfiguration(memento);
                return new PyUnitLaunch((ILaunch)new Launch(launchConfiguration, mode, (ISourceLocator)new PySourceLocator()), launchConfiguration);
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        return new PyUnitLaunch(null, null);
    }

    @Override
    public void stop() {
        if (this.launch != null) {
            try {
                this.launch.terminate();
            }
            catch (DebugException e) {
                Log.log((Throwable)e);
            }
        }
    }

    @Override
    public void relaunch() {
        if (this.launch == null || this.configuration == null) {
            Log.log((String)"Unable to launch (launch configuration was not properly restored from IO or the related launch was already removed).");
            return;
        }
        RestartLaunchAction.relaunch(this.launch, this.configuration);
    }

    @Override
    public void relaunchTestResults(List<PyUnitTestResult> runsToRelaunch) {
        this.relaunchTestResults(runsToRelaunch, null);
    }

    @Override
    public void relaunchTestResults(List<PyUnitTestResult> runsToRelaunch, String mode) {
        if (this.launch == null || this.configuration == null) {
            Log.log((String)"Unable to launch (launch configuration was not properly restored from IO or the related launch was already removed).");
            return;
        }
        FastStringBuffer buf = new FastStringBuffer(100 * runsToRelaunch.size());
        for (PyUnitTestResult pyUnitTestResult : runsToRelaunch) {
            buf.append(pyUnitTestResult.location).append("|").append(pyUnitTestResult.test).append('\n');
        }
        try {
            String launchMode;
            String name = this.configuration.getName();
            ILaunchConfigurationWorkingCopy workingCopy = name.indexOf("[pyunit run]") != -1 ? this.configuration.getWorkingCopy() : this.configuration.copy(name + " [pyunit run]");
            workingCopy.setAttribute("org.python.pydev.debug.ATTR_UNITTEST_CONFIGURATION_FILE", buf.toString());
            ILaunchConfiguration newConf = workingCopy.doSave();
            ILaunch l = this.launch;
            if (mode != null && !mode.equals(launchMode = this.launch.getLaunchMode())) {
                l = new Launch(newConf, mode, this.launch.getSourceLocator());
            }
            RestartLaunchAction.relaunch(l, newConf);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }
}

