/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.pyunit;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.python.pydev.ast.codecompletion.revisited.CompletionCache;
import org.python.pydev.ast.codecompletion.revisited.CompletionStateFactory;
import org.python.pydev.ast.item_pointer.ItemPointer;
import org.python.pydev.ast.location.FindWorkspaceFiles;
import org.python.pydev.ast.refactoring.PyRefactoringFindDefinition;
import org.python.pydev.core.BaseModuleRequest;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModuleRequestState;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.pyunit.PyUnitTestRun;
import org.python.pydev.editor.actions.PyOpenAction;
import org.python.pydev.parser.fastparser.FastDefinitionsParser;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.string.FastStringBuffer;

public class PyUnitTestResult {
    public final String status;
    public final String location;
    public final String test;
    public final String capturedOutput;
    public final String errorContents;
    public final String time;
    private WeakReference<PyUnitTestRun> testRun;
    public final String STATUS_OK = "ok";
    public final String STATUS_OK_SKIPPED = "ok (skipped)";
    public final String STATUS_SKIP = "skip";
    public final String STATUS_FAIL = "fail";
    public final String STATUS_ERROR = "error";
    public final String index;

    public PyUnitTestResult(PyUnitTestRun testRun, String status, String location, String test, String capturedOutput, String errorContents, String time) {
        Assert.isNotNull((Object)capturedOutput);
        Assert.isNotNull((Object)errorContents);
        Assert.isNotNull((Object)time);
        Assert.isNotNull((Object)test);
        Assert.isNotNull((Object)location);
        Assert.isNotNull((Object)status);
        Assert.isNotNull((Object)testRun);
        this.testRun = new WeakReference<PyUnitTestRun>(testRun);
        this.status = status;
        this.location = location;
        this.test = test;
        this.capturedOutput = capturedOutput;
        this.errorContents = errorContents;
        this.time = time;
        this.index = testRun.getNextTestIndex();
    }

    public PyUnitTestRun getTestRun() {
        return (PyUnitTestRun)this.testRun.get();
    }

    public boolean isOk() {
        return "ok".equals(this.status);
    }

    public boolean isSkip() {
        return "skip".equals(this.status) || "ok (skipped)".equals(this.status);
    }

    public String toString() {
        int fixedContentsLen = 50;
        FastStringBuffer buf = new FastStringBuffer(this.test.length() + this.status.length() + this.time.length() + this.location.length() + this.errorContents.length() + this.capturedOutput.length() + fixedContentsLen);
        return buf.append(this.test).append(" Status: ").append(this.status).append(" Time: ").append(this.time).append("\n\n").append("File: ").append(this.location).append("\n\n").append(this.errorContents).append("\n\n").append(this.capturedOutput).append("\n\n").toString();
    }

    public void open() {
        File file = new File(this.location);
        if (file.exists()) {
            PyOpenAction openAction = new PyOpenAction();
            String fileContents = FileUtils.getFileContents((File)file);
            String thisTest = this.test;
            int i = thisTest.indexOf(91);
            if (i != -1) {
                thisTest = thisTest.substring(0, i).trim();
            }
            if ((i = thisTest.indexOf(40)) != -1) {
                thisTest = thisTest.substring(0, i).trim();
            }
            ItemPointer itemPointer = PyUnitTestResult.getItemPointer(file, fileContents, thisTest);
            openAction.run(itemPointer);
        }
    }

    public static ItemPointer getItemPointer(File file, String fileContents, String testPath) {
        ItemPointer itemPointer;
        SimpleNode testNode = null;
        if (fileContents != null) {
            SimpleNode node = FastDefinitionsParser.parse((String)fileContents, (String)"", (File)file);
            if (testPath != null && testPath.length() > 0) {
                testNode = NodeUtils.getNodeFromPath((SimpleNode)node, (String)testPath);
            }
        }
        if (testNode != null) {
            itemPointer = new ItemPointer((Object)file, testNode);
        } else {
            try {
                CompletionCache completionCache;
                IDefinition[] definitions;
                IModule mod;
                PythonNature nature;
                String moduleName;
                IProject project;
                IFile workspaceFile = FindWorkspaceFiles.getWorkspaceFile((File)file, null);
                if (workspaceFile != null && workspaceFile.exists() && (project = workspaceFile.getProject()) != null && project.exists() && (moduleName = (nature = PythonNature.getPythonNature((IProject)project)).resolveModule(file)) != null && (mod = nature.getAstManager().getModule(moduleName, (IPythonNature)nature, true, (IModuleRequestState)new BaseModuleRequest(true))) != null && (definitions = mod.findDefinition(CompletionStateFactory.getEmptyCompletionState((String)testPath, (IPythonNature)nature, (ICompletionCache)(completionCache = new CompletionCache())), -1, -1, (IPythonNature)nature)) != null && definitions.length > 0) {
                    ArrayList pointers = new ArrayList();
                    PyRefactoringFindDefinition.getAsPointers(pointers, (IDefinition[])definitions);
                    if (pointers.size() > 0) {
                        return (ItemPointer)pointers.get(0);
                    }
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
            itemPointer = new ItemPointer((Object)file);
        }
        return itemPointer;
    }
}

