/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui;

import java.util.List;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.preferences.PydevPrefs;
import org.python.pydev.debug.ui.IDebugPreferencesPageParticipant;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.preferences.PyDevEditorPreferences;

public class DebugPrefsPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public DebugPrefsPage() {
        super("Debug", 1);
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        Composite p = this.getFieldEditorParent();
        this.addField((FieldEditor)new IntegerFieldEditor("CONNECT_TIMEOUT", "Connect timeout for debugger (ms)", p, 10));
        BooleanFieldEditor editor = new BooleanFieldEditor("RELOAD_MODULE_ON_CHANGE", "When file is changed, automatically reload module?", 1, p);
        Control c = editor.getDescriptionControl(p);
        c.setToolTipText("The debugger will automatically reload a module,\nwhen a file is saved if this setting is on.\n\nSee pydevd_reload.py for details, limitations and which hooks\nare provided so that your own classes act upon this change.");
        this.addField((FieldEditor)editor);
        editor = new BooleanFieldEditor("DONT_TRACE_ENABLED", "On a step in, skip over methods which have a @DontTrace comment?", 1, p);
        c = editor.getDescriptionControl(p);
        c.setToolTipText("When a comment: # @DontTrace is found after a method, it's skipped by the debugger if this setting is on.\n\nUse Ctrl+1 in a method line to add such a comment.");
        this.addField((FieldEditor)editor);
        editor = new BooleanFieldEditor("SHOW_RETURN_VALUES", "Show return values for methods?", 1, p);
        c = editor.getDescriptionControl(p);
        c.setToolTipText("When this option is enabled, upon returning from a method, its return value is shown.");
        this.addField((FieldEditor)editor);
        List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_debug_preferences_page");
        for (IDebugPreferencesPageParticipant participant : participants) {
            participant.createFieldEditors(this, p);
        }
        editor = new BooleanFieldEditor("DEBUG_MULTIPROCESSING_ENABLED", "Attach to subprocess automatically while debugging?", 1, p);
        c = editor.getDescriptionControl(p);
        c.setToolTipText("Enabling this option will patch the functions related to launching a new process\nand will attempt to automatically connect new launched processes to the debugger.");
        this.addField((FieldEditor)editor);
        editor = new BooleanFieldEditor("GEVENT_DEBUGGING", "Gevent compatible debugging?", 1, p);
        c = editor.getDescriptionControl(p);
        c.setToolTipText("When this option is turned on, the debugger will be able to debug GEvent programs.");
        this.addField((FieldEditor)editor);
        editor = new BooleanFieldEditor("DEBUG_JUST_MY_CODE", "Debug just my code (i.e.: only source code in source folders in PyDev)?", 1, p);
        c = editor.getDescriptionControl(p);
        c.setToolTipText("When this option is turned on, the debugger will ignore any files which are not under a PyDev source folder.");
        this.addField((FieldEditor)editor);
        ComboFieldEditor comboEditor = new ComboFieldEditor("QT_THREADS_DEBUG_MODE", "Qt Threads:", PyDevEditorPreferences.ENTRIES_VALUES_QT_THREADS_DEBUG_MODE, p);
        Label labelControl = comboEditor.getLabelControl(p);
        labelControl.setToolTipText("Specify whether the debugger should patch Qt to debug inside QThreads.");
        this.addField((FieldEditor)comboEditor);
    }

    public static boolean getReloadModuleOnChange() {
        return PydevPrefs.getEclipsePreferences().getBoolean("RELOAD_MODULE_ON_CHANGE", true);
    }

    public static boolean getDontTraceEnabled() {
        return PydevPrefs.getEclipsePreferences().getBoolean("DONT_TRACE_ENABLED", true);
    }

    public static boolean getShowReturnValuesEnabled() {
        return PydevPrefs.getEclipsePreferences().getBoolean("SHOW_RETURN_VALUES", true);
    }

    public static boolean getDebugMultiprocessingEnabled() {
        return PydevPrefs.getEclipsePreferences().getBoolean("DEBUG_MULTIPROCESSING_ENABLED", true);
    }

    public static boolean getGeventDebugging() {
        return PydevPrefs.getEclipsePreferences().getBoolean("GEVENT_DEBUGGING", false);
    }

    public static boolean getJustMyCode() {
        return PydevPrefs.getEclipsePreferences().getBoolean("DEBUG_JUST_MY_CODE", false);
    }

    public static String getQtThreadsDebugMode() {
        return PydevPrefs.getEclipsePreferences().get("QT_THREADS_DEBUG_MODE", "none");
    }

    public void addField(FieldEditor editor) {
        super.addField(editor);
    }
}

