/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui;

import java.util.List;
import java.util.Optional;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.json.eclipsesource.JsonArray;
import org.python.pydev.json.eclipsesource.JsonObject;
import org.python.pydev.json.eclipsesource.JsonValue;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.WrapAndCaseUtils;
import org.python.pydev.shared_ui.field_editors.ButtonFieldEditor;
import org.python.pydev.shared_ui.field_editors.JsonFieldEditor;

public class PathMappingsPrefsPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private JsonFieldEditor jsonFieldEditor;
    private final String pathMappingsListTemplate = "[\n    {\n      \"localRoot\": \"c:/temp\", \n      \"remoteRoot\": \"/usr/temp\"\n    }\n]";
    private final String pathMappingsObjectTemplate = ",\n    {\n      \"localRoot\": \"c:/src\", \n      \"remoteRoot\": \"/usr/src\"\n    }\n]";
    private ButtonFieldEditor btFieldEditor;

    public PathMappingsPrefsPage() {
        super("Path Mapping", 1);
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        Composite p = this.getFieldEditorParent();
        this.jsonFieldEditor = new JsonFieldEditor("PATH_MAPPINGS", WrapAndCaseUtils.wrap((String)"Path Mappings JSON input.\n\nWhen the debugger is running in a different machine/VM/Docker, it's possible to set how paths should be translated.", (int)90) + "\n\n" + WrapAndCaseUtils.wrap((String)"The field below should be filled with JSON (with a list of objects with \"localRoot\" and \"remoteRoot\"). Use the \"Add path mapping template entry.\" button below to add one entry.", (int)90), p);
        this.jsonFieldEditor.setAdditionalJsonValidation(json -> this.checkPathMappingsFormat((JsonValue)json));
        this.addField((FieldEditor)this.jsonFieldEditor);
        this.btFieldEditor = new ButtonFieldEditor("__UNUSED__", "Add path mapping template entry.", p, new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PathMappingsPrefsPage.this.addTemplateButtonClick();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.addField((FieldEditor)this.btFieldEditor);
        this.addField((FieldEditor)new BooleanFieldEditor("DEBUG_PATH_MAPPINGS", "Debug path translation? i.e.: Prints the translation to stderr on the server.", p));
    }

    private void addTemplateButtonClick() {
        StyledText textField;
        if (this.jsonFieldEditor != null && (textField = this.jsonFieldEditor.getTextControl(this.getFieldEditorParent())) != null && !textField.isDisposed()) {
            FastStringBuffer contentBuffer = new FastStringBuffer();
            contentBuffer.append(textField.getText()).trim();
            if (contentBuffer.isEmpty()) {
                textField.setText("[\n    {\n      \"localRoot\": \"c:/temp\", \n      \"remoteRoot\": \"/usr/temp\"\n    }\n]");
            } else if (this.jsonFieldEditor.isValidToApply()) {
                contentBuffer.deleteLast();
                contentBuffer.trim().append(",\n    {\n      \"localRoot\": \"c:/src\", \n      \"remoteRoot\": \"/usr/src\"\n    }\n]");
                textField.setText(contentBuffer.toString());
            }
        }
    }

    protected void updateApplyButton() {
        super.updateApplyButton();
        this.btFieldEditor.getButtonControl(this.getFieldEditorParent()).setEnabled(this.isValid());
    }

    private Optional<String> checkPathMappingsFormat(JsonValue json) {
        if (!json.isArray()) {
            return Optional.of("Path Mappings JSON must be an array.");
        }
        JsonArray array = json.asArray();
        int i = 0;
        for (JsonValue value : array) {
            if (!value.isObject()) {
                return Optional.of("Only objects with \"localRoot\" and \"remoteRoot\" are accepted as path mapping entries.");
            }
            String objectId = "Path mapping entry: " + ++i;
            JsonObject object = value.asObject();
            if (object.size() != 2) {
                return Optional.of(objectId + " is expected to contain \"localRoot\" and \"remoteRoot\" keys.");
            }
            List objectNames = object.names();
            if (!objectNames.contains("localRoot")) {
                return Optional.of(objectId + " does not contain \"localRoot\" key.");
            }
            if (!objectNames.contains("remoteRoot")) {
                return Optional.of(objectId + " does not contain \"remoteRoot\" key.");
            }
            if (!object.get("localRoot").isString()) {
                return Optional.of(objectId + " \"localRoot\" value is not a string.");
            }
            if (object.get("remoteRoot").isString()) continue;
            return Optional.of(objectId + " \"remoteRoot\" value is not a string.");
        }
        return Optional.empty();
    }

    protected void performApply() {
        if (this.jsonFieldEditor.isValidToApply()) {
            super.performApply();
        }
    }
}

