/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.debug.ui.IPyToggleBreakpointsTarget;
import org.python.pydev.debug.ui.actions.PyBreakpointRulerAction;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.shared_ui.editor.BaseEditor;

public class PyToggleBreakpointsTarget
implements IToggleBreakpointsTarget,
IToggleBreakpointsTargetExtension,
IPyToggleBreakpointsTarget {
    PyToggleBreakpointsTarget() {
    }

    public void toggleBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        if (part instanceof PyEdit && selection instanceof TextSelection) {
            PyEdit pyEdit = (PyEdit)part;
            TextSelection textSelection = (TextSelection)selection;
            int startLine = textSelection.getStartLine();
            List<IMarker> markersFromCurrentFile = PyBreakpointRulerAction.getMarkersFromCurrentFile((BaseEditor)pyEdit, startLine);
            if (markersFromCurrentFile.size() > 0) {
                PyBreakpointRulerAction.removeMarkers(markersFromCurrentFile);
            } else {
                PyBreakpointRulerAction.addBreakpointMarker(pyEdit.getDocument(), startLine + 1, (ITextEditor)pyEdit, "python-line");
            }
        }
    }

    public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
        return selection instanceof TextSelection && part instanceof PyEdit;
    }

    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        this.toggleBreakpoints(part, selection);
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return this.canToggleBreakpoints(part, selection);
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        this.toggleBreakpoints(part, selection);
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return this.canToggleBreakpoints(part, selection);
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        this.toggleBreakpoints(part, selection);
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return this.canToggleBreakpoints(part, selection);
    }

    @Override
    public void addBreakpointMarker(IDocument document, int line, ITextEditor fTextEditor) {
        PyBreakpointRulerAction.addBreakpointMarker(document, line, fTextEditor, "python-line");
    }
}

