/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.console.FileLink;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.console.IHyperlink;
import org.python.pydev.ast.item_pointer.ItemPointer;
import org.python.pydev.ast.location.FindWorkspaceFiles;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.preferences.FileTypesPreferences;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.ui.ILinkContainer;
import org.python.pydev.debug.ui.launching.PythonRunnerConfig;
import org.python.pydev.editor.actions.PyOpenAction;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.structure.Location;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.utils.PlatformUtils;

public class PythonConsoleLineTracker
implements IConsoleLineTracker {
    private ILinkContainer linkContainer;
    private boolean onlyCreateLinksForExistingFiles = true;
    private IProject project;
    private boolean updatedProjectAndWorkingDir = false;
    private IPath workingDirectory;
    static Pattern regularPythonlinePattern = Pattern.compile(".*(File) \\\"([^\\\"]*)\\\", line (\\d*).*");
    static Pattern insideQuotesMatcher1 = Pattern.compile(".*\\\"(.*)?\\\".*");
    static Pattern insideQuotesMatcher2 = Pattern.compile(".*\\'(.*)?\\'.*");
    private final Map<Object, Boolean> cacheFileExists = new HashMap<Object, Boolean>();
    private static final long CACHE_TIMEOUT_IN_MILLIS = 1500L;
    private long lastTimeCacheFileExistsCalled = 0L;

    private void updateProjectAndWorkingDir() {
        ILaunch launch;
        if (this.updatedProjectAndWorkingDir) {
            return;
        }
        IProcess process = DebugUITools.getCurrentProcess();
        if (process != null && (launch = process.getLaunch()) != null) {
            this.updatedProjectAndWorkingDir = true;
            ILaunchConfiguration lc = launch.getLaunchConfiguration();
            this.initLaunchConfiguration(lc);
        }
    }

    private IProject getProject() {
        IProject project = this.project;
        if (project == null) {
            this.updateProjectAndWorkingDir();
        }
        return project;
    }

    public IPath getWorkingDirectory() {
        if (this.workingDirectory == null) {
            this.updateProjectAndWorkingDir();
        }
        return this.workingDirectory;
    }

    public void init(final IConsole console) {
        ILaunch launch;
        IProcess process = console.getProcess();
        if (process != null && (launch = process.getLaunch()) != null) {
            this.initLaunchConfiguration(launch.getLaunchConfiguration());
        }
        this.linkContainer = new ILinkContainer(){

            @Override
            public void addLink(IHyperlink link, int offset, int length) {
                if (length <= 0) {
                    return;
                }
                console.addLink(link, offset, length);
            }

            @Override
            public String getContents(int offset, int length) throws BadLocationException {
                return console.getDocument().get(offset, length);
            }
        };
    }

    public void init(ILaunchConfiguration launchConfiguration, ILinkContainer linkContainer) {
        this.linkContainer = linkContainer;
        this.initLaunchConfiguration(launchConfiguration);
    }

    private void initLaunchConfiguration(ILaunchConfiguration launchConfiguration) {
        if (launchConfiguration != null) {
            try {
                IResource[] mappedResources = launchConfiguration.getMappedResources();
                if (mappedResources != null && mappedResources.length > 0) {
                    this.project = mappedResources[0].getProject();
                    PythonNature nature = PythonNature.getPythonNature((IProject)this.project);
                    if (nature != null) {
                        this.workingDirectory = PythonRunnerConfig.getWorkingDirectory(launchConfiguration, (IPythonNature)nature);
                    }
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
    }

    public void lineAppended(IRegion line) {
        try {
            String text;
            int lineOffset = line.getOffset();
            int lineLength = line.getLength();
            try {
                text = this.linkContainer.getContents(lineOffset, lineLength);
            }
            catch (BadLocationException e) {
                PydevDebugPlugin.log(4, "unexpected error", e);
                return;
            }
            Matcher m = regularPythonlinePattern.matcher(text);
            if (m.matches()) {
                try {
                    this.regularPythonMatcher(lineOffset, lineLength, m);
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
                return;
            }
            PythonConsoleLineTracker.forEachStringToCheck(text, FileTypesPreferences.getDottedValidSourceFiles(), (matchStartCol, matchEndCol, textFound, lineNumberAtText) -> this.checkMapFilenameToHyperlink(lineOffset, matchStartCol, matchEndCol, textFound, lineNumberAtText));
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    public static void forEachStringToCheck(String text, String[] dottedFileExtensions, OnStringToCheck onString) {
        int length = text.length();
        FastStringBuffer tempBuf = new FastStringBuffer();
        boolean foundDot = false;
        int i = 0;
        while (i < length) {
            char c = text.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                tempBuf.append(c);
            } else if (c == '\\' || c == '/') {
                tempBuf.append(c);
            } else if (c == '.') {
                foundDot = true;
                tempBuf.append(c);
            } else if (c == ':' && PlatformUtils.isWindowsPlatform() && tempBuf.length() == 1 && Character.isLetter(tempBuf.charAt(0))) {
                tempBuf.append(c);
            } else {
                if (!tempBuf.isEmpty()) {
                    if (foundDot) {
                        i = PythonConsoleLineTracker.analyzeText(text, dottedFileExtensions, onString, length, tempBuf, i, c);
                    }
                    tempBuf.clear();
                }
                foundDot = false;
            }
            ++i;
        }
        if (foundDot && !tempBuf.isEmpty()) {
            char c = '\u0000';
            int i2 = length;
            PythonConsoleLineTracker.analyzeText(text, dottedFileExtensions, onString, length, tempBuf, i2, c);
        }
    }

    private static int analyzeText(String text, String[] dottedFileExtensions, OnStringToCheck onString, int length, FastStringBuffer tempBuf, int i, char c) {
        String string = tempBuf.toString();
        String[] stringArray = dottedFileExtensions;
        int n = dottedFileExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            String fileExtension = stringArray[n2];
            if (string.endsWith(fileExtension)) {
                Tuple<Integer, String> extractedLineNumber;
                int lineNumberAtText = 0;
                int foundColumn = i - string.length();
                if (c == ':' && (extractedLineNumber = PythonConsoleLineTracker.extractLineNumber(i + 1, text, length, tempBuf.clear())) != null) {
                    i = (Integer)extractedLineNumber.o1;
                    lineNumberAtText = Integer.parseInt((String)extractedLineNumber.o2);
                }
                onString.onString(foundColumn, i, string, lineNumberAtText);
            }
            ++n2;
        }
        return i;
    }

    private static Tuple<Integer, String> extractLineNumber(int i, String text, int length, FastStringBuffer tempBuf) {
        while (i < length) {
            char c = text.charAt(i);
            if (!Character.isDigit(c)) break;
            tempBuf.append(c);
            ++i;
        }
        if (tempBuf.length() > 0) {
            return new Tuple((Object)i, (Object)tempBuf.toString());
        }
        return null;
    }

    private boolean internalFileExists(Object file, ICallback<Boolean, Object> existsCallback) {
        Boolean saved;
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis - this.lastTimeCacheFileExistsCalled > 1500L) {
            this.lastTimeCacheFileExistsCalled = currentTimeMillis;
            this.cacheFileExists.clear();
        }
        if ((saved = this.cacheFileExists.get(file)) != null) {
            return saved;
        }
        boolean exists = (Boolean)existsCallback.call(file);
        this.cacheFileExists.put(file, exists);
        return exists;
    }

    protected boolean fileExists(File file) {
        return this.internalFileExists(file, (ICallback<Boolean, Object>)((ICallback)f -> file.exists()));
    }

    protected boolean fileExists(IFile file) {
        return this.internalFileExists(file, (ICallback<Boolean, Object>)((ICallback)f -> file.exists()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkMapFilenameToHyperlink(int lineOffset, int matchStartCol, int matchEndCol, String filename, int lineNumberInt) {
        IPath full;
        File file;
        IPath workingDir;
        File realFile = new File(filename);
        if (this.fileExists(realFile)) {
            this.createLinkToFile(lineOffset, matchStartCol, matchEndCol, lineNumberInt, realFile);
            return true;
        }
        IPath path = Path.fromOSString((String)filename);
        if (path.isAbsolute()) {
            return false;
        }
        IProject project = this.getProject();
        try {
            if (project != null && this.createLinkFromContainerAndPath(lineOffset, matchStartCol, matchEndCol, lineNumberInt, path, (IContainer)project)) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e1) {
            Log.log((Throwable)e1);
        }
        if ((workingDir = this.getWorkingDirectory()) != null && project != null && !workingDir.equals((Object)project.getLocation()) && this.fileExists(file = (full = workingDir.append(path)).toFile())) {
            this.createLinkToFile(lineOffset, matchStartCol, matchEndCol, lineNumberInt, file);
            return true;
        }
        PythonNature nature = PythonNature.getPythonNature((IProject)project);
        if (nature == null) return false;
        try {
            IContainer iContainer;
            IResource iResource;
            Set projectSourcePathFolderSet = nature.getPythonPathNature().getProjectSourcePathFolderSet();
            Iterator iterator = projectSourcePathFolderSet.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!((iResource = (IResource)iterator.next()) instanceof IContainer) || (iContainer = (IContainer)iResource).equals((Object)project) || workingDir != null && iContainer.getLocation().equals((Object)workingDir) || !this.createLinkFromContainerAndPath(lineOffset, matchStartCol, matchEndCol, lineNumberInt, path, iContainer));
            return true;
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }

    private boolean createLinkToFile(int lineOffset, int matchStartCol, int matchEndCol, int lineNumberInt, File realFile) {
        ItemPointer p = new ItemPointer((Object)realFile, new Location(lineNumberInt - 1, 0), null);
        ConsoleLink link = new ConsoleLink(p);
        this.linkContainer.addLink(link, lineOffset + matchStartCol, matchEndCol - matchStartCol);
        return true;
    }

    private boolean createLinkFromContainerAndPath(int lineOffset, int matchStartCol, int matchEndCol, int lineNumberInt, IPath path, IContainer iContainer) {
        try {
            IFile file2 = iContainer.getFile(path);
            if (this.fileExists(file2)) {
                FileLink link = new FileLink(file2, null, -1, -1, lineNumberInt);
                this.linkContainer.addLink((IHyperlink)link, lineOffset + matchStartCol, matchEndCol - matchStartCol);
                return true;
            }
        }
        catch (IllegalArgumentException file2) {
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return false;
    }

    private boolean regularPythonMatcher(int lineOffset, int lineLength, Matcher m) {
        String lineNumber = null;
        int col = -1;
        String fileName = m.group(2);
        lineNumber = m.group(3);
        col = m.start(1);
        int lineNumberInt = 0;
        try {
            lineNumberInt = lineNumber != null ? Integer.parseInt(lineNumber) : 0;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return this.createHyperlink(lineOffset, col, lineLength, fileName, lineNumberInt);
    }

    private boolean createHyperlink(int lineOffset, int startCol, int endCol, String fileName, int lineNumberInt) {
        if (fileName != null) {
            IFile file = null;
            if (!SharedCorePlugin.inTestMode()) {
                try {
                    file = FindWorkspaceFiles.getFileForLocation((IPath)Path.fromOSString((String)fileName), (IProject)this.getProject());
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
            }
            if (file != null && this.fileExists(file)) {
                FileLink link = new FileLink(file, null, -1, -1, lineNumberInt);
                this.linkContainer.addLink((IHyperlink)link, lineOffset + startCol, endCol - startCol);
                return true;
            }
            File realFile = new File(fileName);
            if (!this.onlyCreateLinksForExistingFiles || this.fileExists(realFile)) {
                ItemPointer p = new ItemPointer((Object)realFile, new Location(lineNumberInt - 1, 0), null);
                ConsoleLink link = new ConsoleLink(p);
                this.linkContainer.addLink(link, lineOffset + startCol, endCol - startCol);
                return true;
            }
        }
        return false;
    }

    public void dispose() {
        this.cacheFileExists.clear();
    }

    public void setOnlyCreateLinksForExistingFiles(boolean b) {
        this.onlyCreateLinksForExistingFiles = b;
    }

    public void splitInLinesAndAppendToLineTracker(String string) {
        int len = string.length();
        int last = 0;
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            if (c == '\r') {
                this.lineAppended((IRegion)new Region(last, i - last - 1));
                if (i < len - 1 && string.charAt(i + 1) == '\n') {
                    ++i;
                }
                last = i + 1;
            }
            if (c == '\n') {
                this.lineAppended((IRegion)new Region(last, i - last - 1));
                last = i + 1;
            }
            ++i;
        }
        int lastLen = len - last;
        if (lastLen > 0) {
            this.lineAppended((IRegion)new Region(last, lastLen));
        }
    }

    public class ConsoleLink
    implements IHyperlink {
        ItemPointer pointer;

        public ConsoleLink(ItemPointer pointer) {
            this.pointer = pointer;
        }

        public void linkEntered() {
        }

        public void linkExited() {
        }

        public void linkActivated() {
            PyOpenAction open = new PyOpenAction();
            open.run(this.pointer);
        }
    }

    public static interface OnStringToCheck {
        public void onString(int var1, int var2, String var3, int var4);
    }
}

