/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui.launching;

import org.eclipse.core.expressions.PropertyTester;
import org.python.pydev.ast.interpreter_managers.InterpreterManagersAPI;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.log.Log;

public class InterpreterTypeTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IInterpreterManager interpreterManager = null;
        String str = expectedValue.toString();
        if ("python".equals(str)) {
            interpreterManager = InterpreterManagersAPI.getPythonInterpreterManager();
        } else if ("jython".equals(str)) {
            interpreterManager = InterpreterManagersAPI.getJythonInterpreterManager();
        } else if ("ironpython".equals(str)) {
            interpreterManager = InterpreterManagersAPI.getIronpythonInterpreterManager();
        } else {
            Log.log((String)("Unable to check for: " + String.valueOf(expectedValue)));
        }
        if (interpreterManager != null) {
            try {
                String defaultInterpreter = interpreterManager.getDefaultInterpreterInfo(false).getExecutableOrJar();
                return defaultInterpreter != null;
            }
            catch (MisconfigurationException e) {
                return false;
            }
        }
        return false;
    }
}

