/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.python.pydev.debug.model.PyDebugModelPresentation;
import org.python.pydev.debug.views.ILaunchAndDebugListener;
import org.python.pydev.shared_ui.utils.RunInUiThread;

public abstract class BaseDebugView
extends ViewPart {
    protected TreeViewer viewer;
    protected ProgressBar progressBar;
    protected Composite parent;
    protected ITreeContentProvider provider;
    private ILaunchAndDebugListener listener;
    protected final Job updateTreeJob = new UIJob("Update PyDev Debug view"){

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (BaseDebugView.this.viewer.getTree().isDisposed()) {
                return Status.OK_STATUS;
            }
            BaseDebugView.this.onSetTreeInput();
            RunInUiThread.async((Runnable)new Runnable(){

                @Override
                public void run() {
                    if ((this).BaseDebugView.this.viewer != null && (this).BaseDebugView.this.viewer.getTree() != null && !(this).BaseDebugView.this.viewer.getTree().isDisposed()) {
                        Object input = (this).BaseDebugView.this.viewer.getInput();
                        BaseDebugView.this.makeLastVisibleInTree(input);
                    }
                }
            });
            return Status.OK_STATUS;
        }
    };
    private int inProgress = 0;
    private Object progressLock = new Object();
    Job updateProgressBarJob = new UIJob("Update Referrers view"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            Object object = BaseDebugView.this.progressLock;
            synchronized (object) {
                if (BaseDebugView.this.inProgress > 0) {
                    if (BaseDebugView.this.progressBar == null || BaseDebugView.this.progressBar.isDisposed()) {
                        BaseDebugView.this.progressBar = new ProgressBar(BaseDebugView.this.parent, 65538);
                        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)BaseDebugView.this.progressBar);
                        BaseDebugView.this.parent.layout(true);
                        final Display display = Display.getCurrent();
                        display.timerExec(100, new Runnable(){
                            int i = 0;

                            @Override
                            public void run() {
                                if ((this).BaseDebugView.this.progressBar == null || (this).BaseDebugView.this.progressBar.isDisposed()) {
                                    return;
                                }
                                (this).BaseDebugView.this.progressBar.setSelection(this.i++);
                                display.timerExec(100, (Runnable)this);
                            }
                        });
                    }
                } else if (BaseDebugView.this.progressBar != null && !BaseDebugView.this.progressBar.isDisposed()) {
                    BaseDebugView.this.progressBar.dispose();
                    BaseDebugView.this.progressBar = null;
                    BaseDebugView.this.parent.layout(true);
                }
            }
            return Status.OK_STATUS;
        }
    };

    public void createPartControl(Composite parent) {
        IViewSite viewSite = this.getViewSite();
        if (viewSite != null) {
            this.configureToolBar(viewSite);
        }
        parent.setLayout((Layout)new GridLayout(1, true));
        this.viewer = new TreeViewer(parent);
        this.provider = this.createContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.provider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new PyDebugModelPresentation(false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.viewer.getTree());
        MenuManager menuManager = new MenuManager();
        Menu menu = menuManager.createContextMenu((Control)this.viewer.getTree());
        this.viewer.getTree().setMenu(menu);
        IWorkbenchPartSite site = this.getSite();
        site.registerContextMenu(menuManager, (ISelectionProvider)this.viewer);
        site.setSelectionProvider((ISelectionProvider)this.viewer);
        this.parent = parent;
        this.listener = this.createListener();
        if (this.listener != null) {
            DebugPlugin plugin = DebugPlugin.getDefault();
            ILaunchManager launchManager = plugin.getLaunchManager();
            launchManager.addLaunchListener((ILaunchListener)this.listener);
            plugin.addDebugEventListener((IDebugEventSetListener)this.listener);
        }
    }

    protected abstract ITreeContentProvider createContentProvider();

    protected abstract ILaunchAndDebugListener createListener();

    protected abstract void configureToolBar(IViewSite var1);

    public void dispose() {
        super.dispose();
        if (this.listener != null) {
            DebugPlugin plugin = DebugPlugin.getDefault();
            ILaunchManager launchManager = plugin.getLaunchManager();
            launchManager.removeLaunchListener((ILaunchListener)this.listener);
            plugin.removeDebugEventListener((IDebugEventSetListener)this.listener);
        }
        this.clear();
    }

    public void setFocus() {
        if (this.viewer == null || this.viewer.getTree().isDisposed()) {
            return;
        }
        this.viewer.getTree().setFocus();
    }

    public void clear() {
        this.updateTreeJob.schedule();
    }

    protected abstract void makeLastVisibleInTree(Object var1);

    protected abstract void onSetTreeInput();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endProgress() {
        Object object = this.progressLock;
        synchronized (object) {
            --this.inProgress;
        }
        this.updateProgressBarJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startProgress() {
        Object object = this.progressLock;
        synchronized (object) {
            ++this.inProgress;
        }
        this.updateProgressBarJob.schedule(600L);
    }
}

