/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis;

import com.python.pydev.analysis.AnalysisPreferenceInitializer;
import com.python.pydev.analysis.flake8.Flake8PrefInitializer;
import com.python.pydev.analysis.mypy.MypyPrefInitializer;
import com.python.pydev.analysis.pylint.PyLintPrefInitializer;
import com.python.pydev.analysis.ruff.RuffPrefInitializer;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;
import org.python.pydev.ast.codecompletion.revisited.CompletionStateFactory;
import org.python.pydev.ast.codecompletion.revisited.visitors.Definition;
import org.python.pydev.ast.codecompletion.revisited.visitors.HeuristicFindAttrs;
import org.python.pydev.ast.item_pointer.ItemPointer;
import org.python.pydev.ast.refactoring.PyRefactoringFindDefinition;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.IInfo;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModuleRequestState;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.shared_core.structure.Location;

public class AnalysisPlugin
extends Plugin {
    private static AnalysisPlugin plugin;
    public static IPath stateLocation;

    public AnalysisPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        PyLintPrefInitializer.initializeDefaultPreferences();
        MypyPrefInitializer.initializeDefaultPreferences();
        Flake8PrefInitializer.initializeDefaultPreferences();
        RuffPrefInitializer.initializeDefaultPreferences();
        new AnalysisPreferenceInitializer().initializeDefaultPreferences();
        stateLocation = AnalysisPlugin.getDefault().getStateLocation();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static boolean getDefinitionFromIInfo(List<ItemPointer> pointers, ICodeCompletionASTManager manager, IPythonNature nature, IInfo info, ICompletionState completionCache, boolean requireIDefinition, boolean force) {
        String file;
        if (pointers == null) {
            pointers = new ArrayList<ItemPointer>();
        }
        if (!requireIDefinition && (file = info.getFile()) != null) {
            File f = new File(file);
            int line = info.getLine();
            int col = info.getCol();
            if (line > 0 && col > 0) {
                ItemPointer itemPointer = new ItemPointer((Object)f, new Location(line - 1, col - 1), new Location(line - 1, col - 1), null, null, f.toURI());
                pointers.add(itemPointer);
                return true;
            }
        }
        if (!force) {
            return false;
        }
        IModule mod = manager.getModule(info.getDeclaringModuleName(), nature, true, (IModuleRequestState)completionCache);
        if (mod != null) {
            if (info.getType() == 5) {
                Definition definition = new Definition(1, 1, "", null, null, mod);
                PyRefactoringFindDefinition.getAsPointers(pointers, (IDefinition[])new Definition[]{definition});
                return true;
            }
            Object tok = "";
            String path = info.getPath();
            if (path != null && path.length() > 0) {
                tok = path + ".";
            }
            tok = (String)tok + info.getName();
            try {
                IDefinition[] contextDefinitions;
                IDefinition[] definitions = mod.findDefinition(CompletionStateFactory.getEmptyCompletionState((String)tok, (IPythonNature)nature, (ICompletionCache)completionCache), -1, -1, nature);
                if ((definitions == null || definitions.length == 0) && path != null && path.length() > 0 && (contextDefinitions = mod.findDefinition(CompletionStateFactory.getEmptyCompletionState((String)path, (IPythonNature)nature, (ICompletionCache)completionCache), -1, -1, nature)) != null && contextDefinitions.length > 0) {
                    IDefinition[] iDefinitionArray = contextDefinitions;
                    int n = contextDefinitions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IDefinition iDefinition = iDefinitionArray[n2];
                        if (iDefinition instanceof Definition) {
                            Definition definition = (Definition)iDefinition;
                            if (definition.ast instanceof FunctionDef) {
                                exprType[] args;
                                FunctionDef functionDef = (FunctionDef)definition.ast;
                                if (functionDef.args != null && (args = functionDef.args.args) != null && args.length > 0) {
                                    HashMap repToTokenWithArgs = new HashMap();
                                    HeuristicFindAttrs heuristicFindAttrs = new HeuristicFindAttrs(2, 0, "", definition.module.getName(), null, repToTokenWithArgs, nature, definition.module);
                                    heuristicFindAttrs.visitFunctionDef(functionDef);
                                    List tokens = heuristicFindAttrs.getTokens();
                                    ArrayList<Definition> newDefs = new ArrayList<Definition>();
                                    for (IToken iToken : tokens) {
                                        if (!info.getName().equals(iToken.getRepresentation())) continue;
                                        newDefs.add(new Definition(iToken, definition.scope, definition.module));
                                    }
                                    definitions = newDefs.toArray(new IDefinition[newDefs.size()]);
                                }
                            }
                        }
                        ++n2;
                    }
                }
                PyRefactoringFindDefinition.getAsPointers(pointers, (IDefinition[])definitions);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    public static AnalysisPlugin getDefault() {
        return plugin;
    }

    public static File getStorageDirForProject(IProject p) {
        IPath location;
        if (AnalysisPlugin.getDefault() == null) {
            return new File(".");
        }
        IPath path = location = p.getWorkingLocation("com.python.pydev.analysis");
        File file = new File(path.toOSString());
        return file;
    }

    public static String getPluginID() {
        return AnalysisPlugin.getDefault().getBundle().getSymbolicName();
    }
}

