/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis;

import com.python.pydev.analysis.pep8.Pep8Visitor;
import com.python.pydev.analysis.tabnanny.TabNanny;
import com.python.pydev.analysis.visitors.OccurrencesVisitor;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.ast.analysis.messages.IMessage;
import org.python.pydev.ast.analysis.messages.Message;
import org.python.pydev.ast.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.core.IAnalysisPreferences;
import org.python.pydev.core.IIndentPrefs;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.io.PyUnsupportedEncodingException;

public class OccurrencesAnalyzer {
    public IMessage[] analyzeDocument(IPythonNature nature, final SourceModule module, final IAnalysisPreferences prefs, final IDocument document, final IProgressMonitor monitor, IIndentPrefs indentPrefs) {
        OccurrencesVisitor visitor;
        Thread t;
        ArrayList pep8Messages;
        block14: {
            pep8Messages = new ArrayList();
            t = new Thread(){

                @Override
                public void run() {
                    pep8Messages.addAll(new Pep8Visitor().getMessages(module, document, monitor, prefs));
                }
            };
            t.start();
            visitor = new OccurrencesVisitor(nature, module.getName(), (IModule)module, prefs, document, monitor);
            try {
                SimpleNode ast = module.getAst();
                if (ast == null || !nature.startRequests()) break block14;
                try {
                    ast.accept((VisitorIF)visitor);
                }
                finally {
                    nature.endRequests();
                }
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                Log.log((int)4, (String)("Error while visiting " + module.getName() + " (" + String.valueOf(module.getFile()) + ")"), (Throwable)e);
            }
        }
        ArrayList<Object> messages = new ArrayList<Object>();
        if (!monitor.isCanceled()) {
            messages.addAll(visitor.getMessages());
            try {
                FileUtils.getPythonFileEncoding((IDocument)document, (String)module.getName());
            }
            catch (PyUnsupportedEncodingException e) {
                Message m = new Message(18, (Object)e.getMessage(), e.getLine(), e.getLine(), e.getColumn(), e.getColumn() + e.getMessage().length(), prefs);
                messages.add(m);
            }
            try {
                messages.addAll(TabNanny.analyzeDoc(document, prefs, module.getName(), indentPrefs, monitor));
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        if (!monitor.isCanceled()) {
            try {
                t.join();
                messages.addAll(pep8Messages);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return messages.toArray(new IMessage[messages.size()]);
    }
}

