/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.additionalinfo;

import java.io.Serializable;
import org.python.pydev.ast.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.core.IInfo;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.ObjectsInternPool;
import org.python.pydev.core.log.Log;
import org.python.pydev.shared_core.string.StringUtils;

public abstract class AbstractInfo
implements IInfo,
Serializable {
    private static final long serialVersionUID = 3L;
    public final String name;
    public final String path;
    public final String moduleDeclared;
    public final IPythonNature nature;
    public final String file;
    public final int line;
    public final int col;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractInfo(String name, String moduleDeclared, String path, IPythonNature nature, String file, int line, int col) {
        if (line <= 0 || col <= 0) {
            if (file != null && PythonPathHelper.isValidSourceFile((String)file)) {
                Log.log((String)StringUtils.format((String)"Not expecting to get negative line for: %s - %s - %s - %s - %s - %s", (Object[])new Object[]{name, moduleDeclared, path, file, line, col}));
            }
            if (line < 0) {
                line = 0;
            }
            if (col < 0) {
                col = 0;
            }
        }
        Object object = ObjectsInternPool.lock;
        synchronized (object) {
            this.name = ObjectsInternPool.internUnsynched((String)name);
            this.moduleDeclared = ObjectsInternPool.internUnsynched((String)moduleDeclared);
            this.path = ObjectsInternPool.internUnsynched((String)path);
            this.file = ObjectsInternPool.internUnsynched((String)file);
            this.line = line;
            this.col = col;
        }
        this.nature = nature;
    }

    public AbstractInfo(String name, String moduleDeclared, String path, boolean doNotInternOnThisContstruct, IPythonNature nature, String file, int line, int col) {
        if (line <= 0 || col <= 0) {
            if (file != null && PythonPathHelper.isValidSourceFile((String)file)) {
                Log.log((String)StringUtils.format((String)"Not expecting to get negative line for: %s - %s - %s - %s - %s - %s", (Object[])new Object[]{name, moduleDeclared, path, file, line, col}));
            }
            if (line < 0) {
                line = 0;
            }
            if (col < 0) {
                col = 0;
            }
        }
        this.name = name;
        this.moduleDeclared = moduleDeclared;
        this.path = path;
        this.nature = nature;
        this.file = file;
        this.line = line;
        this.col = col;
    }

    public IPythonNature getNature() {
        return this.nature;
    }

    public String getName() {
        return this.name;
    }

    public String getDeclaringModuleName() {
        return this.moduleDeclared;
    }

    public String getPath() {
        return this.path;
    }

    public String getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }

    public int getCol() {
        return this.col;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IInfo)) {
            return false;
        }
        IInfo otherInfo = (IInfo)obj;
        if (otherInfo.getType() != this.getType()) {
            return false;
        }
        if (!otherInfo.getDeclaringModuleName().equals(this.moduleDeclared)) {
            return false;
        }
        if (!otherInfo.getName().equals(this.name)) {
            return false;
        }
        String otherPath = otherInfo.getPath();
        String myPath = this.getPath();
        if (otherPath == null || myPath == null) {
            return otherPath == myPath;
        }
        return otherPath.equals(myPath);
    }

    public int hashCode() {
        return 7 * this.name.hashCode() + this.moduleDeclared.hashCode() * this.getType();
    }

    public String toString() {
        return this.name + " (" + this.moduleDeclared + ") - Path:" + this.getPath();
    }

    public int compareTo(IInfo o) {
        int r = this.name.compareTo(o.getName());
        if (r != 0) {
            return r;
        }
        return this.moduleDeclared.compareTo(o.getDeclaringModuleName());
    }
}

