/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.additionalinfo;

import com.python.pydev.analysis.AnalysisPlugin;
import com.python.pydev.analysis.additionalinfo.AbstractAdditionalDependencyInfo;
import com.python.pydev.analysis.additionalinfo.AbstractAdditionalInfoWithBuild;
import com.python.pydev.analysis.additionalinfo.AbstractAdditionalTokensInfo;
import com.python.pydev.analysis.additionalinfo.AdditionalSystemInterpreterInfo;
import com.python.pydev.analysis.system_info_builder.InterpreterInfoBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.python.pydev.ast.codecompletion.revisited.ProjectModulesManager;
import org.python.pydev.ast.interpreter_managers.InterpreterManagersAPI;
import org.python.pydev.core.FileUtilsFileBuffer;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.IInfo;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.plugin.nature.SystemPythonNature;
import org.python.pydev.shared_core.global_feedback.GlobalFeedback;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.OrderedMap;
import org.python.pydev.shared_core.structure.Tuple;

public class AdditionalProjectInterpreterInfo
extends AbstractAdditionalInfoWithBuild {
    private final IProject project;
    private final File persistingFolder;
    private final File persistingLocation;
    private PythonNature nature;
    private static final Map<String, AbstractAdditionalDependencyInfo> additionalNatureInfo = new HashMap<String, AbstractAdditionalDependencyInfo>();
    private static final Object additionalNatureInfoLock = new Object();

    public IProject getProject() {
        return this.project;
    }

    @Override
    protected IPythonNature getNature() {
        return this.nature;
    }

    @Override
    protected File getPersistingFolder() {
        return this.persistingFolder;
    }

    @Override
    protected File getPersistingLocation() {
        return this.persistingLocation;
    }

    public AdditionalProjectInterpreterInfo(IProject project) throws MisconfigurationException {
        super(false);
        File f;
        Assert.isNotNull((Object)project);
        this.project = project;
        this.nature = PythonNature.getPythonNature((IProject)project);
        try {
            f = AnalysisPlugin.getStorageDirForProject(project);
        }
        catch (NullPointerException e) {
            Log.logInfo((String)"Error getting persisting folder", (Throwable)e);
            f = new File(".");
        }
        this.persistingFolder = f;
        this.persistingLocation = new File(this.persistingFolder, "AdditionalProjectInterpreterInfo.pydevinfo");
        this.init();
    }

    @Override
    protected String getUIRepresentation() {
        return this.project != null ? this.project.getName() : "Unknown project";
    }

    @Override
    protected Set<String> getPythonPathFolders() {
        PythonNature pythonNature = PythonNature.getPythonNature((IProject)this.project);
        IPythonPathNature pythonPathNature = pythonNature.getPythonPathNature();
        HashSet<String> ret = new HashSet<String>();
        try {
            ret.addAll(pythonPathNature.getOnlyProjectPythonPathStr(true, true));
        }
        catch (CoreException e) {
            Log.log((Throwable)e);
        }
        return ret;
    }

    public static List<AbstractAdditionalTokensInfo> getAdditionalInfo(IPythonNature nature) throws MisconfigurationException {
        return AdditionalProjectInterpreterInfo.getAdditionalInfo(nature, true, false);
    }

    public static List<AbstractAdditionalTokensInfo> getAdditionalInfo(IPythonNature nature, boolean addSystemInfo, boolean addReferencingProjects) throws MisconfigurationException {
        List<Tuple<AbstractAdditionalTokensInfo, IPythonNature>> infoAndNature = AdditionalProjectInterpreterInfo.getAdditionalInfoAndNature(nature, addSystemInfo, addReferencingProjects);
        ArrayList<AbstractAdditionalTokensInfo> ret = new ArrayList<AbstractAdditionalTokensInfo>();
        for (Tuple<AbstractAdditionalTokensInfo, IPythonNature> tuple : infoAndNature) {
            ret.add((AbstractAdditionalTokensInfo)tuple.o1);
        }
        return ret;
    }

    public static List<Tuple<AbstractAdditionalTokensInfo, IPythonNature>> getAdditionalInfoAndNature(IPythonNature nature, boolean addSystemInfo, boolean addReferencingProjects) throws MisconfigurationException {
        return AdditionalProjectInterpreterInfo.getAdditionalInfoAndNature(nature, addSystemInfo, addReferencingProjects, true);
    }

    public static List<Tuple<AbstractAdditionalTokensInfo, IPythonNature>> getAdditionalInfoAndNature(IPythonNature nature, boolean addSystemInfo, boolean addReferencingProjects, boolean addReferencedProjects) throws MisconfigurationException {
        ArrayList<Tuple<AbstractAdditionalTokensInfo, IPythonNature>> ret = new ArrayList<Tuple<AbstractAdditionalTokensInfo, IPythonNature>>();
        IProject project = nature.getProject();
        if (addSystemInfo) {
            AbstractAdditionalDependencyInfo systemInfo;
            try {
                systemInfo = AdditionalSystemInterpreterInfo.getAdditionalSystemInfo(InterpreterManagersAPI.getInterpreterManager((IPythonNature)nature), nature.getProjectInterpreter().getExecutableOrJar());
            }
            catch (MisconfigurationException e) {
                throw e;
            }
            catch (PythonNatureWithoutProjectException e) {
                throw new RuntimeException(e);
            }
            ret.add((Tuple<AbstractAdditionalTokensInfo, IPythonNature>)new Tuple((Object)systemInfo, (Object)new SystemPythonNature(nature.getRelatedInterpreterManager())));
        }
        if (project != null) {
            AbstractAdditionalDependencyInfo additionalInfoForProject = AdditionalProjectInterpreterInfo.getAdditionalInfoForProject(nature);
            if (additionalInfoForProject != null) {
                ret.add((Tuple<AbstractAdditionalTokensInfo, IPythonNature>)new Tuple((Object)additionalInfoForProject, (Object)nature));
            }
            try {
                if (addReferencedProjects) {
                    Set referencedProjects = ProjectModulesManager.getReferencedProjects((IProject)project);
                    for (IProject refProject : referencedProjects) {
                        additionalInfoForProject = AdditionalProjectInterpreterInfo.getAdditionalInfoForProject((IPythonNature)PythonNature.getPythonNature((IProject)refProject));
                        if (additionalInfoForProject == null) continue;
                        ret.add((Tuple<AbstractAdditionalTokensInfo, IPythonNature>)new Tuple((Object)additionalInfoForProject, (Object)PythonNature.getPythonNature((IProject)refProject)));
                    }
                }
                if (addReferencingProjects) {
                    Set referencingProjects = ProjectModulesManager.getReferencingProjects((IProject)project);
                    for (IProject refProject : referencingProjects) {
                        additionalInfoForProject = AdditionalProjectInterpreterInfo.getAdditionalInfoForProject((IPythonNature)PythonNature.getPythonNature((IProject)refProject));
                        if (additionalInfoForProject == null) continue;
                        ret.add((Tuple<AbstractAdditionalTokensInfo, IPythonNature>)new Tuple((Object)additionalInfoForProject, (Object)PythonNature.getPythonNature((IProject)refProject)));
                    }
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AbstractAdditionalDependencyInfo getAdditionalInfoForProject(final IPythonNature nature) throws MisconfigurationException {
        if (nature == null) {
            return null;
        }
        IProject project = nature.getProject();
        if (project == null) {
            return null;
        }
        String name = FileUtilsFileBuffer.getValidProjectName((IProject)project);
        Object object = additionalNatureInfoLock;
        synchronized (object) {
            AbstractAdditionalDependencyInfo info = additionalNatureInfo.get(name);
            if (info == null) {
                info = new AdditionalProjectInterpreterInfo(project);
                additionalNatureInfo.put(name, info);
                if (!info.load()) {
                    AdditionalProjectInterpreterInfo.recreateAllInfo(nature, (IProgressMonitor)new NullProgressMonitor());
                } else {
                    final AbstractAdditionalDependencyInfo temp = info;
                    temp.setWaitForIntegrityCheck(true);
                    Job j = new Job("Check index integrity for: " + project.getName()){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                try {
                                    Throwable throwable = null;
                                    Object var3_5 = null;
                                    try (GlobalFeedback.GlobalFeedbackReporter r = GlobalFeedback.start((String)"Check index integrity...");){
                                        new InterpreterInfoBuilder().syncInfoToPythonPath(monitor, nature);
                                    }
                                    catch (Throwable throwable2) {
                                        if (throwable == null) {
                                            throwable = throwable2;
                                        } else if (throwable != throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                        throw throwable;
                                    }
                                }
                                catch (Exception e) {
                                    Log.log((Throwable)e);
                                    temp.setWaitForIntegrityCheck(false);
                                }
                            }
                            finally {
                                temp.setWaitForIntegrityCheck(false);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    j.setPriority(10);
                    j.setSystem(true);
                    j.schedule();
                }
            }
            return info;
        }
    }

    public static List<IInfo> getTokensEqualTo(String qualifier, IPythonNature nature, int getWhat) throws MisconfigurationException {
        ArrayList<IInfo> ret = new ArrayList<IInfo>(50);
        List<AbstractAdditionalTokensInfo> additionalInfo = AdditionalProjectInterpreterInfo.getAdditionalInfo(nature);
        for (AbstractAdditionalTokensInfo info : additionalInfo) {
            info.getTokensEqualTo(qualifier, getWhat, ret);
        }
        return ret;
    }

    public static List<IInfo> getTokensStartingWith(String qualifier, IPythonNature nature, int getWhat) throws MisconfigurationException {
        ArrayList<IInfo> ret = new ArrayList<IInfo>();
        List<AbstractAdditionalTokensInfo> additionalInfo = AdditionalProjectInterpreterInfo.getAdditionalInfo(nature);
        for (AbstractAdditionalTokensInfo info : additionalInfo) {
            info.getTokensStartingWith(qualifier, getWhat, ret);
        }
        return ret;
    }

    public static List<AbstractAdditionalDependencyInfo> getAdditionalInfoForProjectAndReferencing(IPythonNature nature) throws MisconfigurationException {
        ArrayList<AbstractAdditionalDependencyInfo> ret = new ArrayList<AbstractAdditionalDependencyInfo>();
        IProject project = nature.getProject();
        if (project == null) {
            return ret;
        }
        ret.add(AdditionalProjectInterpreterInfo.getAdditionalInfoForProject(nature));
        Set referencingProjects = ProjectModulesManager.getReferencingProjects((IProject)project);
        for (IProject p : referencingProjects) {
            AbstractAdditionalDependencyInfo info2 = AdditionalProjectInterpreterInfo.getAdditionalInfoForProject((IPythonNature)PythonNature.getPythonNature((IProject)p));
            if (info2 == null) continue;
            ret.add(info2);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void recreateAllInfo(IPythonNature nature, IProgressMonitor monitor) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                IModulesManager m;
                block20: {
                    ICodeCompletionASTManager astManager;
                    GlobalFeedback.GlobalFeedbackReporter r;
                    block19: {
                        r = GlobalFeedback.start((String)"Full projects reindex...");
                        Object object = additionalNatureInfoLock;
                        // MONITORENTER : object
                        astManager = nature.getAstManager();
                        if (astManager != null) break block19;
                        // MONITOREXIT : object
                        if (r == null) return;
                        r.close();
                        return;
                    }
                    m = astManager.getModulesManager();
                    if (m != null) break block20;
                    // MONITOREXIT : object
                    if (r == null) return;
                    r.close();
                    return;
                }
                IProject project = nature.getProject();
                AbstractAdditionalDependencyInfo currInfo = AdditionalProjectInterpreterInfo.getAdditionalInfoForProject(nature);
                if (currInfo != null) {
                    currInfo.clearAllInfo();
                    currInfo.dispose();
                }
                String feedback = "(project:" + project.getName() + ")";
                IModulesManager iModulesManager = m;
                // MONITORENTER : iModulesManager
                AbstractAdditionalDependencyInfo info = (AbstractAdditionalDependencyInfo)AdditionalProjectInterpreterInfo.restoreInfoForModuleManager(monitor, m, feedback, new AdditionalProjectInterpreterInfo(project), nature, nature.getGrammarVersion());
                if (info != null) {
                    additionalNatureInfo.put(FileUtilsFileBuffer.getValidProjectName((IProject)project), info);
                    info.save();
                }
                // MONITOREXIT : iModulesManager
                return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        return this.getProject().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AdditionalProjectInterpreterInfo)) {
            return false;
        }
        AdditionalProjectInterpreterInfo additionalProjectInterpreterInfo = (AdditionalProjectInterpreterInfo)obj;
        return this.getProject().equals((Object)additionalProjectInterpreterInfo.getProject());
    }

    public List<ModulesKey> getModulesWithToken(String token, IProgressMonitor monitor) throws OperationCanceledException {
        NullProgressMonitor nullMonitor = new NullProgressMonitor();
        if (monitor == null) {
            monitor = nullMonitor;
        }
        int length = token.length();
        if (token == null || length == 0) {
            return new ArrayList<ModulesKey>();
        }
        int i = 0;
        while (i < length) {
            char c = token.charAt(i);
            if (!Character.isJavaIdentifierPart(c) && c != '.') {
                throw new RuntimeException(StringUtils.format((String)"Token: %s is not a valid token to search for.", (Object[])new Object[]{token}));
            }
            ++i;
        }
        StringUtils.checkTokensValidForWildcardQuery((String)token);
        OrderedMap fieldNameToValues = new OrderedMap();
        HashSet<String> split = new HashSet<String>();
        for (String s : StringUtils.splitForIndexMatching((String)token)) {
            split.add(s.toLowerCase());
        }
        fieldNameToValues.put((Object)"contents", split);
        List<ModulesKey> search = this.getReferenceSearches().search(this.project, (OrderedMap<String, Set<String>>)fieldNameToValues, monitor);
        return search;
    }
}

