/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.external;

import com.python.pydev.analysis.external.IExternalAnalyzer;
import com.python.pydev.analysis.external.IExternalCodeAnalysisStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.python.pydev.core.log.Log;
import org.python.pydev.shared_core.callbacks.ICallback0;
import org.python.pydev.shared_core.io.ThreadStreamReader;

public final class ExternalAnalizerProcessWatchDoc
extends Thread {
    private final IExternalCodeAnalysisStream out;
    private final IProgressMonitor monitor;
    private final IExternalAnalyzer externalAnalyzer;
    private final ICallback0<Process> launchProcessCallback;
    private final boolean useProjectLock;
    private final IProject project;
    private static Map<IProject, Semaphore> projectToSemaphore = new HashMap<IProject, Semaphore>();

    public ExternalAnalizerProcessWatchDoc(IExternalCodeAnalysisStream out, IProgressMonitor monitor, IExternalAnalyzer externalAnalyzer, ICallback0<Process> launchProcessCallback, IProject project, boolean useProjectLock) {
        this.setDaemon(true);
        this.out = out;
        this.monitor = monitor;
        this.externalAnalyzer = externalAnalyzer;
        this.launchProcessCallback = launchProcessCallback;
        this.project = project;
        this.useProjectLock = useProjectLock;
        if (useProjectLock) {
            Assert.isNotNull((Object)project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Semaphore getProjectSemaphore(IProject project) {
        Map<IProject, Semaphore> map = projectToSemaphore;
        synchronized (map) {
            Semaphore semaphore = projectToSemaphore.get(project);
            if (semaphore != null) {
                return semaphore;
            }
            semaphore = new Semaphore(1);
            projectToSemaphore.put(project, semaphore);
            return semaphore;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ThreadStreamReader err;
        ThreadStreamReader std;
        Semaphore semaphore = null;
        if (this.useProjectLock) {
            semaphore = ExternalAnalizerProcessWatchDoc.getProjectSemaphore(this.project);
            try {
                semaphore.acquire();
            }
            catch (InterruptedException e1) {
                Log.log((Throwable)e1);
                return;
            }
        }
        try {
            Process process;
            try {
                process = (Process)this.launchProcessCallback.call();
            }
            catch (Exception e1) {
                Log.log((Throwable)e1);
                if (semaphore != null) {
                    semaphore.release();
                }
                return;
            }
            std = new ThreadStreamReader(process.getInputStream(), false, null);
            err = new ThreadStreamReader(process.getErrorStream(), false, null);
            std.start();
            err.start();
            while (process.isAlive()) {
                if (this.monitor.isCanceled()) {
                    std.stopGettingOutput();
                    err.stopGettingOutput();
                    return;
                }
                ExternalAnalizerProcessWatchDoc e1 = this;
                synchronized (e1) {
                    try {
                        this.wait(20L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        finally {
            if (semaphore != null) {
                semaphore.release();
            }
        }
        if (this.monitor.isCanceled()) {
            std.stopGettingOutput();
            err.stopGettingOutput();
            return;
        }
        try {
            std.join();
        }
        catch (InterruptedException process) {
            // empty catch block
        }
        try {
            err.join();
        }
        catch (InterruptedException process) {
            // empty catch block
        }
        if (this.monitor.isCanceled()) {
            std.stopGettingOutput();
            err.stopGettingOutput();
            return;
        }
        String output = std.getAndClearContents();
        String errors = err.getAndClearContents();
        this.externalAnalyzer.afterRunProcess(output, errors, this.out);
    }
}

