/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.flake8;

import com.python.pydev.analysis.external.IExternalCodeAnalysisStream;
import java.io.File;
import java.net.MalformedURLException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.preferences.PyScopedPreferences;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.callbacks.ICallback;

public class Flake8Preferences {
    public static final String FLAKE8_FILE_LOCATION = "FLAKE8_FILE_LOCATION";
    public static final String USE_FLAKE8 = "USE_FLAKE8";
    public static final boolean DEFAULT_USE_FLAKE8 = false;
    public static final int SEVERITY_IGNORE = -1;
    public static final String FLAKE8_USE_CONSOLE = "FLAKE8_USE_CONSOLE";
    public static final boolean DEFAULT_FLAKE8_USE_CONSOLE = false;
    public static final String SEARCH_FLAKE8_LOCATION = "SEARCH_FLAKE8_LOCATION";
    public static final String LOCATION_SEARCH = "SEARCH";
    public static final String LOCATION_SPECIFY = "SPECIFY";
    public static final String DEFAULT_SEARCH_FLAKE8_LOCATION = "SEARCH";
    public static final String FLAKE8_ARGS = "FLAKE8_ARGS";
    public static final String DEFAULT_FLAKE8_ARGS = "";
    public static final String FLAKE8_CODES_CONFIG = "FLAKE8_CODES_CONFIG";
    public static final String DEFAULT_FLAKE8_CODES_CONFIG = "{\n    \"F\": \"error\",\n    \"E\": \"error\",\n    \"E[400,500]\": \"error\",\n    \"E600\": \"error\",\n    \"W\": \"warning\",\n    \"N8\": \"warning\",\n    \"C9\": \"info\"\n}";
    public static ICallback<IExternalCodeAnalysisStream, IAdaptable> createFlake8Stream = projectAdaptable -> null;

    public static boolean useFlake8(IAdaptable projectAdaptable) {
        return PyScopedPreferences.getBoolean((String)USE_FLAKE8, (IAdaptable)projectAdaptable);
    }

    public static boolean useFlake8Console(IAdaptable projectAdaptable) {
        return PyScopedPreferences.getBoolean((String)FLAKE8_USE_CONSOLE, (IAdaptable)projectAdaptable);
    }

    public static String getFlake8Args(IAdaptable projectAdaptable) {
        return PyScopedPreferences.getString((String)FLAKE8_ARGS, (IAdaptable)projectAdaptable);
    }

    public static boolean useFlake8FromPythonNature(IPythonNature pythonNature, IAdaptable projectAdaptable) {
        String searchlocation = PyScopedPreferences.getString((String)SEARCH_FLAKE8_LOCATION, (IAdaptable)projectAdaptable);
        return !LOCATION_SPECIFY.equals(searchlocation);
    }

    public static File getFlake8Location(PythonNature pythonNature) {
        IProject project = pythonNature.getProject();
        String searchlocation = PyScopedPreferences.getString((String)SEARCH_FLAKE8_LOCATION, (IAdaptable)project);
        if (LOCATION_SPECIFY.equals(searchlocation)) {
            return new File(PyScopedPreferences.getString((String)FLAKE8_FILE_LOCATION, (IAdaptable)project));
        }
        return null;
    }

    public static IExternalCodeAnalysisStream getConsoleOutputStream(IAdaptable projectAdaptable) throws MalformedURLException {
        return (IExternalCodeAnalysisStream)createFlake8Stream.call((Object)projectAdaptable);
    }

    public static String getCodesConfig(IAdaptable projectAdaptable) {
        return PyScopedPreferences.getString((String)FLAKE8_CODES_CONFIG, (IAdaptable)projectAdaptable);
    }
}

