/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.flake8;

import com.python.pydev.analysis.external.IExternalCodeAnalysisStream;
import com.python.pydev.analysis.flake8.Flake8Analysis;
import com.python.pydev.analysis.flake8.Flake8Preferences;
import com.python.pydev.analysis.flake8.OnlyRemoveMarkersFlake8Visitor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.markers.PyMarkerUtils;
import org.python.pydev.shared_core.progress.NullProgressMonitorWrapper;

public final class Flake8Visitor
extends OnlyRemoveMarkersFlake8Visitor {
    private IDocument document;
    private IProgressMonitor monitor;
    private final Object lock = new Object();
    private Flake8Analysis flake8Runnable;

    Flake8Visitor(IResource resource, IDocument document, ICallback<IModule, Integer> module, IProgressMonitor monitor) {
        super(resource);
        this.document = document;
        this.monitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startVisit() {
        if (this.resource == null || !Flake8Preferences.useFlake8((IAdaptable)this.resource) || this.document == null && !(this.resource instanceof IContainer)) {
            this.deleteMarkers();
            return;
        }
        IProject project = this.resource.getProject();
        PythonNature pythonNature = PythonNature.getPythonNature((IProject)project);
        if (pythonNature == null) {
            this.deleteMarkers();
            return;
        }
        File flake8Location = null;
        if (!(Flake8Preferences.useFlake8FromPythonNature((IPythonNature)pythonNature, (IAdaptable)project) || (flake8Location = Flake8Preferences.getFlake8Location(pythonNature)) != null && FileUtils.enhancedIsFile((File)flake8Location))) {
            if (flake8Location == null) {
                Log.log((String)("Unable to find flake8. Project: " + project.getName()));
            } else {
                Log.log((String)("flake8 location does not exist: " + String.valueOf(flake8Location)));
            }
            this.deleteMarkers();
            return;
        }
        try {
            if (pythonNature.getInterpreterType() != 0) {
                this.deleteMarkers();
                return;
            }
        }
        catch (Exception e) {
            this.deleteMarkers();
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.flake8Runnable != null) {
                return;
            }
            if (project != null) {
                IContainer dir;
                IPath location;
                if (this.resource instanceof IFile) {
                    IFile file = (IFile)this.resource;
                    IPath location2 = file.getLocation();
                    if (location2 != null) {
                        this.flake8Runnable = new Flake8Analysis(this.resource, this.document, location2, (IProgressMonitor)new NullProgressMonitorWrapper(this.monitor), flake8Location);
                        try {
                            IExternalCodeAnalysisStream out = Flake8Preferences.getConsoleOutputStream((IAdaptable)project);
                            this.flake8Runnable.createFlake8Process(out);
                        }
                        catch (Exception e) {
                            Log.log((Throwable)e);
                        }
                    }
                } else if (this.resource instanceof IContainer && (location = (dir = (IContainer)this.resource).getLocation()) != null) {
                    this.flake8Runnable = new Flake8Analysis(this.resource, null, location, (IProgressMonitor)new NullProgressMonitorWrapper(this.monitor), flake8Location);
                    try {
                        IExternalCodeAnalysisStream out = Flake8Preferences.getConsoleOutputStream((IAdaptable)project);
                        this.flake8Runnable.createFlake8Process(out);
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    public void join() {
        if (this.flake8Runnable != null) {
            this.flake8Runnable.join();
        }
    }

    @Override
    public List<PyMarkerUtils.MarkerInfo> getMarkers(IResource resource) {
        ArrayList<PyMarkerUtils.MarkerInfo> ret = new ArrayList<PyMarkerUtils.MarkerInfo>();
        if (this.flake8Runnable == null) {
            return ret;
        }
        return this.flake8Runnable.getMarkers(resource);
    }

    @Override
    public boolean getRequiresAnalysis() {
        return true;
    }
}

