/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.pylint;

import com.python.pydev.analysis.external.ExternalAnalizerProcessWatchDoc;
import com.python.pydev.analysis.external.IExternalAnalyzer;
import com.python.pydev.analysis.external.IExternalCodeAnalysisStream;
import com.python.pydev.analysis.external.WriteToStreamHelper;
import com.python.pydev.analysis.pylint.PyLintPreferences;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.python.pydev.ast.runners.SimplePythonRunner;
import org.python.pydev.ast.runners.SimpleRunner;
import org.python.pydev.core.CheckAnalysisErrors;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.callbacks.ICallback0;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.markers.PyMarkerUtils;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;

final class PyLintAnalysis
implements IExternalAnalyzer {
    private IResource resource;
    private IDocument fDocument;
    private IPath location;
    private final Map<IResource, List<PyMarkerUtils.MarkerInfo>> fileToMarkers = new HashMap<IResource, List<PyMarkerUtils.MarkerInfo>>();
    private IProgressMonitor monitor;
    private Thread processWatchDoc;
    private File pyLintLocation;
    private static Pattern PYLINT_MATCH_PATTERN = Pattern.compile("\\A[CRWEFI]:\\s*(\\d+)\\s*,\\s*(\\d+)\\s*:\\s*\\((.*?)\\)(.*)\\Z");

    public PyLintAnalysis(IResource resource, IDocument document, IPath location, IProgressMonitor monitor, File pyLintLocation) {
        this.resource = resource;
        this.fDocument = document;
        this.location = location;
        this.monitor = monitor;
        this.pyLintLocation = pyLintLocation;
    }

    void createPyLintProcess(IExternalCodeAnalysisStream out) throws CoreException, MisconfigurationException, PythonNatureWithoutProjectException {
        ICallback0 launchProcessCallback;
        String target = FileUtils.getFileAbsolutePath((File)new File(this.location.toOSString()));
        ArrayList<String> cmdList = new ArrayList<String>();
        String userArgs = StringUtils.replaceNewLines((String)PyLintPreferences.getPyLintArgs((IAdaptable)this.resource), (String)" ");
        StringTokenizer tokenizer2 = new StringTokenizer(userArgs);
        while (tokenizer2.hasMoreTokens()) {
            String token = tokenizer2.nextToken();
            if (token.equals("--output-format=parseable") || token.startsWith("--msg-template=") || token.startsWith("--output-format=")) continue;
            cmdList.add(token);
        }
        cmdList.add("--output-format=text");
        cmdList.add("--msg-template='{C}:{line:3d},{column:2d}: ({symbol}) {msg}'");
        cmdList.add(target);
        IProject project = this.resource.getProject();
        File workingDir = project.getLocation().toFile();
        if (this.pyLintLocation == null) {
            PythonNature nature = PythonNature.getPythonNature((IProject)project);
            if (nature == null) {
                RuntimeException e = new RuntimeException("PyLint ERROR: Nature not configured for: " + String.valueOf(project));
                Log.log((Throwable)e);
                return;
            }
            launchProcessCallback = () -> {
                String interpreter;
                try {
                    interpreter = nature.getProjectInterpreter().getExecutableOrJar();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                cmdList.add(0, "pylint");
                String[] args = cmdList.toArray(new String[0]);
                WriteToStreamHelper.write("PyLint: Executing command line:", out, "python", "-m", args);
                SimplePythonRunner runner = new SimplePythonRunner();
                String[] parameters = SimplePythonRunner.preparePythonCallParameters((String)interpreter, (String)"-m", (String[])args);
                Tuple r = runner.run(parameters, workingDir, (IPythonNature)nature, this.monitor);
                return (Process)r.o1;
            };
        } else {
            String script = FileUtils.getFileAbsolutePath((File)this.pyLintLocation);
            cmdList.add(0, script);
            String[] args = cmdList.toArray(new String[0]);
            launchProcessCallback = () -> {
                WriteToStreamHelper.write("PyLint: Executing command line:", out, new Object[]{args});
                SimpleRunner simpleRunner = new SimpleRunner();
                Tuple r = simpleRunner.run(args, workingDir, (IPythonNature)PythonNature.getPythonNature((IProject)project), null);
                return (Process)r.o1;
            };
        }
        this.processWatchDoc = new ExternalAnalizerProcessWatchDoc(out, this.monitor, this, (ICallback0<Process>)launchProcessCallback, null, false);
        this.processWatchDoc.start();
    }

    @Override
    public void afterRunProcess(String output, String errors, IExternalCodeAnalysisStream out) {
        boolean resourceIsContainer = this.resource instanceof IContainer;
        IProject project = null;
        IFile moduleFile = null;
        if (resourceIsContainer) {
            project = this.resource.getProject();
            if (project == null) {
                Log.log((String)"Expected resource to have project for PyLintAnalysis.");
                return;
            }
            if (!project.isAccessible()) {
                Log.log((String)"Expected project to be accessible for PyLintAnalysis.");
                return;
            }
        } else if (this.resource instanceof IFile) {
            moduleFile = (IFile)this.resource;
        } else {
            return;
        }
        output = output.trim();
        errors = errors.trim();
        if (!output.isEmpty()) {
            WriteToStreamHelper.write("PyLint: The stdout of the command line is:\n", out, output);
        }
        if (!errors.isEmpty()) {
            WriteToStreamHelper.write("PyLint: The stderr of the command line is:\n", out, errors);
        }
        StringTokenizer tokenizer = new StringTokenizer(output, "\r\n");
        int wSeverity = PyLintPreferences.wSeverity((IAdaptable)this.resource);
        int eSeverity = PyLintPreferences.eSeverity((IAdaptable)this.resource);
        int fSeverity = PyLintPreferences.fSeverity((IAdaptable)this.resource);
        int cSeverity = PyLintPreferences.cSeverity((IAdaptable)this.resource);
        int rSeverity = PyLintPreferences.rSeverity((IAdaptable)this.resource);
        int iSeverity = PyLintPreferences.iSeverity((IAdaptable)this.resource);
        if (this.monitor.isCanceled()) {
            return;
        }
        if (output.indexOf("Traceback (most recent call last):") != -1) {
            RuntimeException e = new RuntimeException("PyLint ERROR: \n" + output);
            Log.log((Throwable)e);
            return;
        }
        if (errors.indexOf("Traceback (most recent call last):") != -1) {
            RuntimeException e = new RuntimeException("PyLint ERROR: \n" + errors);
            Log.log((Throwable)e);
            return;
        }
        FastStringBuffer moduleNameBuf = new FastStringBuffer();
        IDocument document = this.fDocument;
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            if (this.monitor.isCanceled()) {
                return;
            }
            if (resourceIsContainer) {
                if (tok.startsWith("*")) {
                    moduleNameBuf.clear().append(tok);
                    int i = tok.lastIndexOf("* Module ");
                    if (i < 0) continue;
                    moduleNameBuf.deleteFirstChars(i + "* Module ".length());
                    moduleNameBuf.replaceAll('.', '/').append(".py");
                    Path modulePath = new Path(moduleNameBuf.toString());
                    try {
                        moduleFile = project.getFile((IPath)modulePath);
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                    }
                    document = FileUtils.getDocFromResource((IResource)moduleFile);
                    continue;
                }
                if (document == null) continue;
            }
            try {
                int priority = 0;
                int indexOfDoublePoints = tok.indexOf(":");
                if (indexOfDoublePoints != 1) continue;
                char c = tok.charAt(0);
                switch (c) {
                    case 'C': {
                        priority = cSeverity;
                        break;
                    }
                    case 'R': {
                        priority = rSeverity;
                        break;
                    }
                    case 'W': {
                        priority = wSeverity;
                        break;
                    }
                    case 'E': {
                        priority = eSeverity;
                        break;
                    }
                    case 'F': {
                        priority = fSeverity;
                        break;
                    }
                    case 'I': {
                        priority = iSeverity;
                    }
                }
                if (priority <= -1) continue;
                try {
                    int line = -1;
                    int column = -1;
                    String messageId = "";
                    Matcher m = PYLINT_MATCH_PATTERN.matcher(tok);
                    if (!m.matches()) continue;
                    line = Integer.parseInt(tok.substring(m.start(1), m.end(1)));
                    column = Integer.parseInt(tok.substring(m.start(2), m.end(2)));
                    messageId = tok.substring(m.start(3), m.end(3)).trim();
                    tok = tok.substring(m.start(4), m.end(4)).trim();
                    IRegion region = null;
                    try {
                        region = document.getLineInformation(line - 1);
                    }
                    catch (Exception e) {
                        region = document.getLineInformation(line);
                    }
                    String lineContents = document.get(region.getOffset(), region.getLength());
                    if (CheckAnalysisErrors.isPyLintErrorHandledAtLine((String)lineContents, (String)messageId)) continue;
                    this.addToMarkers(tok, priority, messageId, line - 1, column, lineContents, moduleFile, document);
                }
                catch (RuntimeException e2) {
                    Log.log((Throwable)e2);
                }
            }
            catch (Exception e1) {
                Log.log((Throwable)e1);
            }
        }
    }

    private void addToMarkers(String tok, int priority, String id, int line, int column, String lineContents, IFile moduleFile, IDocument document) {
        HashMap<String, String> additionalInfo = new HashMap<String, String>();
        additionalInfo.put("pylint_message_id", id);
        List<PyMarkerUtils.MarkerInfo> list = this.fileToMarkers.get(moduleFile);
        if (list == null) {
            list = new ArrayList<PyMarkerUtils.MarkerInfo>();
            this.fileToMarkers.put((IResource)moduleFile, list);
        }
        list.add(new PyMarkerUtils.MarkerInfo(document, "PyLint: " + tok, "org.python.pydev.pylintproblemmarker", priority, false, false, line, column, line, lineContents.length(), additionalInfo));
    }

    @Override
    public void join() {
        if (this.processWatchDoc != null) {
            try {
                this.processWatchDoc.join();
            }
            catch (InterruptedException e) {
                Log.log((Throwable)e);
            }
        }
    }

    public List<PyMarkerUtils.MarkerInfo> getMarkers(IResource resource) {
        List<PyMarkerUtils.MarkerInfo> ret = this.fileToMarkers.get(resource);
        if (ret == null) {
            return new ArrayList<PyMarkerUtils.MarkerInfo>();
        }
        return new ArrayList<PyMarkerUtils.MarkerInfo>(ret);
    }
}

