/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.pyright;

import com.python.pydev.analysis.external.IExternalCodeAnalysisStream;
import java.io.File;
import java.net.MalformedURLException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.preferences.PyScopedPreferences;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.callbacks.ICallback;

public class PyrightPreferences {
    public static final String PYRIGHT_FILE_LOCATION = "PYRIGHT_FILE_LOCATION";
    public static final String USE_PYRIGHT = "USE_PYRIGHT";
    public static final boolean DEFAULT_USE_PYRIGHT = false;
    public static final String PYRIGHT_USE_CONSOLE = "PYRIGHT_USE_CONSOLE";
    public static final boolean DEFAULT_PYRIGHT_USE_CONSOLE = false;
    public static final String SEARCH_PYRIGHT_LOCATION = "SEARCH_PYRIGHT_LOCATION";
    public static final String LOCATION_SEARCH = "SEARCH";
    public static final String LOCATION_SPECIFY = "SPECIFY";
    public static final String DEFAULT_SEARCH_PYRIGHT_LOCATION = "SEARCH";
    public static final String PYRIGHT_ARGS = "PYRIGHT_ARGS";
    public static final String DEFAULT_PYRIGHT_ARGS = "--outputformat json";
    public static ICallback<IExternalCodeAnalysisStream, IAdaptable> createPyrightStream = projectAdaptable -> null;

    public static boolean usePyright(IAdaptable projectAdaptable) {
        return PyScopedPreferences.getBoolean((String)USE_PYRIGHT, (IAdaptable)projectAdaptable);
    }

    public static boolean usePyrightConsole(IAdaptable projectAdaptable) {
        return PyScopedPreferences.getBoolean((String)PYRIGHT_USE_CONSOLE, (IAdaptable)projectAdaptable);
    }

    public static String getPyrightArgs(IAdaptable projectAdaptable) {
        return PyScopedPreferences.getString((String)PYRIGHT_ARGS, (IAdaptable)projectAdaptable);
    }

    public static boolean usePyrightFromPythonNature(IPythonNature pythonNature, IAdaptable projectAdaptable) {
        return !LOCATION_SPECIFY.equals(PyScopedPreferences.getString((String)SEARCH_PYRIGHT_LOCATION, (IAdaptable)projectAdaptable));
    }

    public static File getPyrightLocation(PythonNature pythonNature) {
        IProject project = pythonNature.getProject();
        if (LOCATION_SPECIFY.equals(PyScopedPreferences.getString((String)SEARCH_PYRIGHT_LOCATION, (IAdaptable)project))) {
            return new File(PyScopedPreferences.getString((String)PYRIGHT_FILE_LOCATION, (IAdaptable)project));
        }
        return null;
    }

    public static IExternalCodeAnalysisStream getConsoleOutputStream(IAdaptable projectAdaptable) throws MalformedURLException {
        return (IExternalCodeAnalysisStream)createPyrightStream.call((Object)projectAdaptable);
    }
}

