/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.refactoring.quick_fixes;

import com.python.pydev.analysis.AnalysisPreferences;
import com.python.pydev.analysis.additionalinfo.AbstractAdditionalTokensInfo;
import com.python.pydev.analysis.additionalinfo.AdditionalProjectInterpreterInfo;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.BadLocationException;
import org.python.pydev.ast.codecompletion.ProposalsComparator;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.IInfo;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.proposals.CompletionProposalFactory;
import org.python.pydev.shared_core.code_completion.ICompletionProposalHandle;
import org.python.pydev.shared_core.code_completion.IPyCompletionProposal;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.FullRepIterable;
import org.python.pydev.shared_core.structure.Tuple;

public class UndefinedVariableQuickFixCreator {
    public static void createImportQuickProposalsFromMarkerSelectedText(IAdaptable projectAdaptable, PySelection ps, int offset, IPythonNature initialNature, List<ICompletionProposalHandle> props, ICodeCompletionASTManager astManager, int start, int end, boolean forceReparseOnApply) throws BadLocationException {
        List<AbstractAdditionalTokensInfo> additionalInfo;
        ps.setSelection(start, end);
        String markerContents = ps.getSelectedText();
        String fullRep = ps.getFullRepAfterSelection();
        IModulesManager projectModulesManager = astManager.getModulesManager();
        IModulesManager[] managersInvolved = projectModulesManager.getManagersInvolved(true);
        boolean doIgnoreImportsStartingWithUnder = AnalysisPreferences.doIgnoreImportsStartingWithUnder(projectAdaptable);
        FastStringBuffer buffer = new FastStringBuffer();
        HashSet<Tuple<String, String>> mods = new HashSet<Tuple<String, String>>();
        IModulesManager[] iModulesManagerArray = managersInvolved;
        int n = managersInvolved.length;
        int n2 = 0;
        while (n2 < n) {
            IModulesManager iModulesManager = iModulesManagerArray[n2];
            Set allModules = iModulesManager.getAllModuleNames(false, markerContents.toLowerCase());
            ProposalsComparator.CompareContext compareContext = new ProposalsComparator.CompareContext(iModulesManager.getNature());
            for (String completeName : allModules) {
                FullRepIterable iterable = new FullRepIterable(completeName);
                for (String mod : iterable) {
                    String displayString;
                    String realImportRep;
                    if (fullRep.startsWith(mod) && (fullRep.length() == mod.length() || fullRep.length() > mod.length() && fullRep.charAt(mod.length()) == '.')) {
                        buffer.clear();
                        String realImportRep2 = buffer.append("import ").append(mod).toString();
                        buffer.clear();
                        String displayString2 = buffer.append("Import ").append(mod).toString();
                        UndefinedVariableQuickFixCreator.addProp(props, realImportRep2, displayString2, 6, offset, mods, (IPyCompletionProposal.ICompareContext)compareContext, forceReparseOnApply);
                    }
                    String[] strings = FullRepIterable.headAndTail((String)mod);
                    String packageName = strings[0];
                    String importRep = strings[1];
                    if (!importRep.equals(markerContents)) continue;
                    if (packageName.length() > 0) {
                        buffer.clear();
                        realImportRep = buffer.append("from ").append(packageName).append(" ").append("import ").append(strings[1]).toString();
                        buffer.clear();
                        displayString = buffer.append("Import ").append(importRep).append(" (").append(packageName).append(")").toString();
                        UndefinedVariableQuickFixCreator.addProp(props, realImportRep, displayString, 6, offset, mods, (IPyCompletionProposal.ICompareContext)compareContext, forceReparseOnApply);
                        continue;
                    }
                    buffer.clear();
                    realImportRep = buffer.append("import ").append(strings[1]).toString();
                    buffer.clear();
                    displayString = buffer.append("Import ").append(importRep).toString();
                    UndefinedVariableQuickFixCreator.addProp(props, realImportRep, displayString, 6, offset, mods, (IPyCompletionProposal.ICompareContext)compareContext, forceReparseOnApply);
                }
            }
            ++n2;
        }
        try {
            additionalInfo = AdditionalProjectInterpreterInfo.getAdditionalInfo(initialNature);
        }
        catch (MisconfigurationException e) {
            return;
        }
        FastStringBuffer tempBuf = new FastStringBuffer();
        for (AbstractAdditionalTokensInfo info : additionalInfo) {
            Collection<IInfo> tokensEqualTo = info.getTokensEqualTo(markerContents, 1);
            for (IInfo found : tokensEqualTo) {
                String name = found.getName();
                String declPackage = found.getDeclaringModuleName();
                String declPackageWithoutInit = declPackage;
                if (declPackageWithoutInit.endsWith(".__init__")) {
                    declPackageWithoutInit = declPackageWithoutInit.substring(0, declPackageWithoutInit.length() - 9);
                }
                declPackageWithoutInit = AnalysisPreferences.removeImportsStartingWithUnderIfNeeded(declPackageWithoutInit, tempBuf, doIgnoreImportsStartingWithUnder);
                buffer.clear();
                String importDeclaration = buffer.append("from ").append(declPackageWithoutInit).append(" import ").append(name).toString();
                buffer.clear();
                String displayImport = buffer.append("Import ").append(name).append(" (").append(declPackage).append(")").toString();
                UndefinedVariableQuickFixCreator.addProp(props, importDeclaration, displayImport, found.getType(), offset, mods, (IPyCompletionProposal.ICompareContext)new ProposalsComparator.CompareContext(found.getNature()), forceReparseOnApply);
            }
        }
    }

    private static void addProp(List<ICompletionProposalHandle> props, String importDeclaration, String displayImport, int infoTypeForImage, int offset, Set<Tuple<String, String>> mods, IPyCompletionProposal.ICompareContext compareContext, boolean forceReparseOnApply) {
        Tuple tuple = new Tuple((Object)importDeclaration, (Object)displayImport);
        if (mods.contains(tuple)) {
            return;
        }
        mods.add((Tuple<String, String>)tuple);
        props.add(CompletionProposalFactory.get().createCtxInsensitiveImportComplProposalReparseOnApply("", offset, 0, 0, infoTypeForImage, displayImport, null, importDeclaration, -1, importDeclaration, compareContext, forceReparseOnApply));
    }
}

