/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.refactoring.refactorer;

import com.python.pydev.analysis.refactoring.refactorer.RefactorerFindDefinition;
import com.python.pydev.analysis.refactoring.refactorer.RefactorerFinds;
import com.python.pydev.analysis.refactoring.wizards.rename.PyReferenceSearcher;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.python.pydev.ast.codecompletion.revisited.visitors.AssignOrTypeAliasDefinition;
import org.python.pydev.ast.item_pointer.ItemPointer;
import org.python.pydev.ast.refactoring.AbstractPyRefactoring;
import org.python.pydev.ast.refactoring.HierarchyNodeModel;
import org.python.pydev.ast.refactoring.IPyRefactoring2;
import org.python.pydev.ast.refactoring.RefactoringRequest;
import org.python.pydev.ast.refactoring.TooManyMatchesException;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.shared_core.structure.Tuple;

public class Refactorer
extends AbstractPyRefactoring
implements IPyRefactoring2 {
    public String getName() {
        return "PyDev Extensions Refactorer";
    }

    public ItemPointer[] findDefinition(RefactoringRequest request) throws TooManyMatchesException, BadLocationException {
        return new RefactorerFindDefinition().findDefinition(request);
    }

    public boolean areAllInSameClassHierarchy(List<AssignOrTypeAliasDefinition> defs) {
        return new RefactorerFinds(this).areAllInSameClassHierarchy(defs);
    }

    public HierarchyNodeModel findClassHierarchy(RefactoringRequest request, boolean findOnlyParents) {
        return new RefactorerFinds(this).findClassHierarchy(request, findOnlyParents);
    }

    public Map<Tuple<String, File>, HashSet<ASTEntry>> findAllOccurrences(RefactoringRequest req) throws OperationCanceledException, CoreException {
        PyReferenceSearcher pyReferenceSearcher = new PyReferenceSearcher(req);
        req.checkCancelled();
        IProgressMonitor monitor = req.getMonitor();
        try {
            monitor.beginTask("Find all occurrences", 100);
            monitor.setTaskName("Find all occurrences");
            try {
                try {
                    req.pushMonitor((IProgressMonitor)new SubProgressMonitor(monitor, 10));
                    pyReferenceSearcher.prepareSearch(req);
                }
                catch (PyReferenceSearcher.SearchException | BadLocationException e) {
                    req.popMonitor().done();
                    monitor.done();
                    return null;
                }
            }
            finally {
                req.popMonitor().done();
            }
        }
        finally {
            monitor.done();
        }
    }
}

