/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.refactoring.refactorer;

import com.python.pydev.analysis.additionalinfo.AbstractAdditionalDependencyInfo;
import com.python.pydev.analysis.additionalinfo.AdditionalProjectInterpreterInfo;
import com.python.pydev.analysis.refactoring.refactorer.Refactorer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.python.pydev.ast.codecompletion.revisited.CompletionCache;
import org.python.pydev.ast.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.ast.codecompletion.revisited.visitors.AssignOrTypeAliasDefinition;
import org.python.pydev.ast.codecompletion.revisited.visitors.Definition;
import org.python.pydev.ast.item_pointer.ItemPointer;
import org.python.pydev.ast.refactoring.HierarchyNodeModel;
import org.python.pydev.ast.refactoring.PyRefactoringFindDefinition;
import org.python.pydev.ast.refactoring.RefactoringRequest;
import org.python.pydev.core.BaseModuleRequest;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModuleRequestState;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.log.Log;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.parser.visitors.scope.EasyASTIteratorVisitor;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.string.StringUtils;

public class RefactorerFinds {
    public static boolean DEBUG = false;
    private Refactorer refactorer;

    public RefactorerFinds(Refactorer refactorer) {
        this.refactorer = refactorer;
    }

    private void findParentDefinitions(IPythonNature nature, IModule module, List<IDefinition> definitions, List<String> withoutAstDefinitions, HierarchyNodeModel model, ICompletionCache completionCache, RefactoringRequest request) throws Exception {
        exprType[] exprTypeArray = model.ast.bases;
        int n = model.ast.bases.length;
        int n2 = 0;
        while (n2 < n) {
            exprType exp = exprTypeArray[n2];
            String n3 = NodeUtils.getFullRepresentationString((SimpleNode)exp);
            int line = exp.beginLine;
            int col = exp.beginColumn + n3.length();
            if (module != null) {
                ArrayList foundDefs = new ArrayList();
                PyRefactoringFindDefinition.findActualDefinition((IProgressMonitor)request.getMonitor(), (boolean)request.acceptTypeshed, (IModule)module, (String)n3, foundDefs, (int)line, (int)col, (IPythonNature)nature, (ICompletionCache)completionCache);
                if (foundDefs.size() > 0) {
                    definitions.addAll(foundDefs);
                } else {
                    withoutAstDefinitions.add(n3);
                }
            } else {
                withoutAstDefinitions.add(n3);
            }
            ++n2;
        }
    }

    private void findParents(IPythonNature nature, Definition d, HierarchyNodeModel initialModel, HashMap<HierarchyNodeModel, HierarchyNodeModel> allFound, RefactoringRequest request) throws Exception {
        request.getMonitor().beginTask("Find parents", -1);
        try {
            HashSet<HierarchyNodeModel> foundOnRound = new HashSet<HierarchyNodeModel>();
            foundOnRound.add(initialModel);
            CompletionCache completionCache = new CompletionCache();
            while (foundOnRound.size() > 0) {
                HashSet nextRound = new HashSet(foundOnRound);
                foundOnRound.clear();
                for (HierarchyNodeModel toFindOnRound : nextRound) {
                    ArrayList<IDefinition> definitions = new ArrayList<IDefinition>();
                    ArrayList<String> withoutAstDefinitions = new ArrayList<String>();
                    this.findParentDefinitions(nature, toFindOnRound.module, definitions, withoutAstDefinitions, toFindOnRound, (ICompletionCache)completionCache, request);
                    request.communicateWork(StringUtils.format((String)"Found: %s parents for: %s", (Object[])new Object[]{definitions.size(), d.value}));
                    for (IDefinition iDefinition : definitions) {
                        Definition definition = (Definition)iDefinition;
                        HierarchyNodeModel model2 = this.createHierarhyNodeFromClassDef(definition);
                        if (model2 != null) {
                            if (!allFound.containsKey(model2)) {
                                allFound.put(model2, model2);
                                toFindOnRound.parents.add(model2);
                                foundOnRound.add(model2);
                                continue;
                            }
                            model2 = allFound.get(model2);
                            Assert.isNotNull((Object)model2);
                            toFindOnRound.parents.add(model2);
                            continue;
                        }
                        withoutAstDefinitions.add(definition.value);
                    }
                    for (String string : withoutAstDefinitions) {
                        toFindOnRound.parents.add(new HierarchyNodeModel(string));
                    }
                }
            }
        }
        finally {
            request.getMonitor().done();
        }
    }

    private void findChildren(RefactoringRequest request, HierarchyNodeModel initialModel, HashMap<HierarchyNodeModel, HierarchyNodeModel> allFound) {
        try {
            List<AbstractAdditionalDependencyInfo> infoForProject;
            request.getMonitor().beginTask("Find children", 100);
            try {
                infoForProject = AdditionalProjectInterpreterInfo.getAdditionalInfoForProjectAndReferencing(request.nature);
            }
            catch (MisconfigurationException e) {
                Log.log((Throwable)e);
                request.getMonitor().done();
                return;
            }
            HashSet<HierarchyNodeModel> foundOnRound = new HashSet<HierarchyNodeModel>();
            foundOnRound.add(initialModel);
            int totalWork = 1000;
            while (foundOnRound.size() > 0) {
                HashSet nextRound = new HashSet(foundOnRound);
                foundOnRound.clear();
                for (HierarchyNodeModel toFindOnRound : nextRound) {
                    HashSet<SourceModule> modulesToAnalyze;
                    int work = totalWork / 250;
                    if (work <= 0) {
                        work = 1;
                        totalWork = 0;
                    }
                    totalWork -= work;
                    try {
                        request.pushMonitor((IProgressMonitor)new SubProgressMonitor(request.getMonitor(), work));
                        modulesToAnalyze = this.findLikelyModulesWithChildren(request, toFindOnRound, infoForProject);
                    }
                    finally {
                        request.popMonitor().done();
                    }
                    request.communicateWork("Likely modules with matches:" + modulesToAnalyze.size());
                    this.findChildrenOnModules(request, allFound, foundOnRound, toFindOnRound, modulesToAnalyze);
                }
            }
        }
        finally {
            request.getMonitor().done();
        }
    }

    private void findChildrenOnModules(RefactoringRequest request, HashMap<HierarchyNodeModel, HierarchyNodeModel> allFound, HashSet<HierarchyNodeModel> foundOnRound, HierarchyNodeModel toFindOnRound, HashSet<SourceModule> modulesToAnalyze) {
        Iterator<SourceModule> iterator = modulesToAnalyze.iterator();
        while (iterator.hasNext()) {
            SourceModule module;
            SourceModule m = module = iterator.next();
            request.communicateWork("Analyzing:" + m.getName());
            Iterator entries = EasyASTIteratorVisitor.createClassIterator((SimpleNode)m.getAst());
            while (entries.hasNext()) {
                ASTEntry entry = (ASTEntry)entries.next();
                ClassDef def = (ClassDef)entry.node;
                List parentNames = NodeUtils.getParentNames((ClassDef)def, (boolean)true);
                if (!parentNames.contains(toFindOnRound.name)) continue;
                HierarchyNodeModel newNode = new HierarchyNodeModel((IModule)module, def);
                if (!allFound.containsKey(newNode)) {
                    toFindOnRound.children.add(newNode);
                    allFound.put(newNode, newNode);
                    foundOnRound.add(newNode);
                    continue;
                }
                newNode = allFound.get(newNode);
                Assert.isNotNull((Object)newNode);
                toFindOnRound.children.add(newNode);
            }
        }
    }

    private HashSet<SourceModule> findLikelyModulesWithChildren(RefactoringRequest request, HierarchyNodeModel model, List<AbstractAdditionalDependencyInfo> infoForProject) {
        HashSet<SourceModule> modulesToAnalyze = new HashSet<SourceModule>();
        for (AbstractAdditionalDependencyInfo additionalInfo : infoForProject) {
            IProgressMonitor monitor = request.getMonitor();
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask("Find likely modules with children", 100);
            monitor.setTaskName("Searching: " + model.name);
            try {
                List<ModulesKey> modules;
                try {
                    request.pushMonitor((IProgressMonitor)new SubProgressMonitor(monitor, 90));
                    if (!(additionalInfo instanceof AdditionalProjectInterpreterInfo)) continue;
                    AdditionalProjectInterpreterInfo additionalProjectInterpreterInfo = (AdditionalProjectInterpreterInfo)additionalInfo;
                    modules = additionalProjectInterpreterInfo.getModulesWithToken(model.name, monitor);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                }
                finally {
                    request.popMonitor().done();
                }
                try {
                    request.pushMonitor((IProgressMonitor)new SubProgressMonitor(monitor, 10));
                    request.getMonitor().beginTask("Find likely modules with children", modules.size());
                    for (ModulesKey declaringModuleName : modules) {
                        if (DEBUG) {
                            System.out.println("findLikelyModulesWithChildren: " + String.valueOf(declaringModuleName));
                        }
                        IModule module = null;
                        IPythonNature pythonNature = null;
                        if (additionalInfo instanceof AdditionalProjectInterpreterInfo) {
                            AdditionalProjectInterpreterInfo projectInterpreterInfo = (AdditionalProjectInterpreterInfo)additionalInfo;
                            pythonNature = PythonNature.getPythonNature((IProject)projectInterpreterInfo.getProject());
                        }
                        if (pythonNature == null) {
                            pythonNature = request.nature;
                        }
                        BaseModuleRequest moduleRequest = new BaseModuleRequest(request.acceptTypeshed);
                        module = pythonNature.getAstManager().getModule(declaringModuleName.name, pythonNature, false, (IModuleRequestState)moduleRequest);
                        if (module == null && pythonNature != request.nature) {
                            module = request.nature.getAstManager().getModule(declaringModuleName.name, request.nature, false, (IModuleRequestState)moduleRequest);
                        }
                        if (module instanceof SourceModule) {
                            modulesToAnalyze.add((SourceModule)module);
                        }
                        request.getMonitor().worked(1);
                    }
                }
                finally {
                    request.popMonitor().done();
                }
            }
            finally {
                monitor.done();
            }
        }
        return modulesToAnalyze;
    }

    public HierarchyNodeModel findClassHierarchy(RefactoringRequest request, boolean findOnlyParents) {
        block23: {
            try {
                HierarchyNodeModel model;
                ItemPointer[] pointers;
                request.getMonitor().beginTask("Find class hierarchy", 100);
                try {
                    request.pushMonitor((IProgressMonitor)new SubProgressMonitor(request.getMonitor(), 5));
                    request.setAdditionalInfo("findDefinitionInAdditionalInfo", (Object)false);
                    pointers = this.refactorer.findDefinition(request);
                }
                finally {
                    request.popMonitor().done();
                }
                if (pointers.length != 1) break block23;
                Definition d = pointers[0].definition;
                try {
                    request.pushMonitor((IProgressMonitor)new SubProgressMonitor(request.getMonitor(), 5));
                    model = this.createHierarhyNodeFromClassDef(d);
                }
                finally {
                    request.popMonitor().done();
                }
                if (model == null) {
                    return null;
                }
                HashMap<HierarchyNodeModel, HierarchyNodeModel> allFound = new HashMap<HierarchyNodeModel, HierarchyNodeModel>();
                allFound.put(model, model);
                try {
                    request.pushMonitor((IProgressMonitor)new SubProgressMonitor(request.getMonitor(), 10));
                    this.findParents(request.nature, d, model, allFound, request);
                }
                finally {
                    request.popMonitor().done();
                }
                if (!findOnlyParents) {
                    try {
                        request.pushMonitor((IProgressMonitor)new SubProgressMonitor(request.getMonitor(), 80));
                        this.findChildren(request, model, allFound);
                    }
                    finally {
                        request.popMonitor().done();
                    }
                }
                HierarchyNodeModel hierarchyNodeModel = model;
                return hierarchyNodeModel;
            }
            catch (OperationCanceledException pointers) {
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                request.getMonitor().done();
            }
        }
        return null;
    }

    private HierarchyNodeModel createHierarhyNodeFromClassDef(Definition d) {
        HierarchyNodeModel model = null;
        if (d.ast instanceof ClassDef) {
            model = new HierarchyNodeModel(d.module, (ClassDef)d.ast);
        }
        return model;
    }

    public boolean areAllInSameClassHierarchy(List<AssignOrTypeAliasDefinition> defs) {
        return true;
    }
}

