/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.refactoring.tdd;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.python.pydev.core.log.Log;

public class TemplateInfo {
    public Template fTemplate;
    public TemplateContext fContext;
    public IRegion fRegion;

    public TemplateInfo(Template template, TemplateContext context, IRegion region) {
        this.fTemplate = template;
        this.fContext = context;
        this.fRegion = region;
    }

    protected final int getReplaceOffset() {
        int start;
        if (this.fContext instanceof DocumentTemplateContext) {
            DocumentTemplateContext docContext = (DocumentTemplateContext)this.fContext;
            start = docContext.getStart();
        } else {
            start = this.fRegion.getOffset();
        }
        return start;
    }

    protected final int getReplaceEndOffset() {
        int end;
        if (this.fContext instanceof DocumentTemplateContext) {
            DocumentTemplateContext docContext = (DocumentTemplateContext)this.fContext;
            end = docContext.getEnd();
        } else {
            end = this.fRegion.getOffset() + this.fRegion.getLength();
        }
        return end;
    }

    public void apply(IDocument document) {
        try {
            TemplateBuffer templateBuffer;
            this.fContext.setReadOnly(false);
            try {
                templateBuffer = this.fContext.evaluate(this.fTemplate);
            }
            catch (TemplateException e1) {
                return;
            }
            int start = this.getReplaceOffset();
            int end = this.getReplaceEndOffset();
            String templateString = templateBuffer.getString();
            document.replace(start, end - start, templateString);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }
}

