/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.refactoring.wizards.rename;

import com.python.pydev.analysis.refactoring.wizards.rename.AbstractRenameRefactorProcess;
import com.python.pydev.analysis.refactoring.wizards.rename.IRefactorCustomEntry;
import com.python.pydev.analysis.refactoring.wizards.rename.ImportRenameAstEntry;
import com.python.pydev.analysis.refactoring.wizards.rename.PyRenameImportProcess;
import com.python.pydev.analysis.refactoring.wizards.rename.TextEditCreation;
import com.python.pydev.analysis.scopeanalysis.ScopeAnalysis;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.python.pydev.ast.codecompletion.revisited.CompletionCache;
import org.python.pydev.ast.codecompletion.revisited.CompletionStateFactory;
import org.python.pydev.ast.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.ast.refactoring.PyRefactoringFindDefinition;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.IIndentPrefs;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.autoedit.DefaultIndentPrefs;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.preferences.InterpreterGeneralPreferences;
import org.python.pydev.core.structure.CompletionRecursionException;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Import;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.Module;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.NameTokType;
import org.python.pydev.parser.jython.ast.VisitorBase;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.aliasType;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.prettyprinterv2.IPrettyPrinterPrefs;
import org.python.pydev.parser.prettyprinterv2.MakeAstValidForPrettyPrintingVisitor;
import org.python.pydev.parser.prettyprinterv2.PrettyPrinterPrefsV2;
import org.python.pydev.parser.prettyprinterv2.PrettyPrinterV2;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.shared_core.model.ISimpleNode;
import org.python.pydev.shared_core.string.FullRepIterable;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.FastStack;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.utils.ArrayUtils;

public class MatchImportsVisitor
extends VisitorBase {
    private IPythonNature nature;
    private String initialModuleName;
    private SourceModule currentModule;
    public final List<ImportFrom> importFromsMatchingOnModulePart = new ArrayList<ImportFrom>();
    public final List<ImportFrom> importFromsMatchingOnAliasPart = new ArrayList<ImportFrom>();
    public final List<Import> importsMatchingOnAliasPart = new ArrayList<Import>();
    public final List<ASTEntry> occurrences = new ArrayList<ASTEntry>();
    public final Set<String> searchStringsAs = new HashSet<String>();
    private ICompletionState completionState;
    private IProgressMonitor monitor;
    private String lastPart;
    private FastStack<SimpleNode> stack = new FastStack(10);

    public MatchImportsVisitor(IPythonNature nature, String initialName, SourceModule module, IProgressMonitor monitor) {
        this.nature = nature;
        this.initialModuleName = this.getWithoutInit(initialName);
        this.currentModule = module;
        this.completionState = CompletionStateFactory.getEmptyCompletionState((IPythonNature)nature, (ICompletionCache)new CompletionCache());
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.monitor = monitor;
        this.lastPart = FullRepIterable.getLastPart((String)this.initialModuleName);
    }

    protected String getModuleNameLastPart() {
        return this.lastPart;
    }

    protected Object unhandled_node(SimpleNode node) throws Exception {
        return null;
    }

    public void traverse(SimpleNode node) throws Exception {
        node.traverse((VisitorIF)this);
    }

    public Object visitModule(Module node) throws Exception {
        this.stack.push((Object)node);
        super.visitModule(node);
        this.stack.pop();
        return null;
    }

    public Object visitFunctionDef(FunctionDef node) throws Exception {
        this.stack.push((Object)node);
        super.visitFunctionDef(node);
        this.stack.pop();
        return null;
    }

    public Object visitClassDef(ClassDef node) throws Exception {
        this.stack.push((Object)node);
        super.visitClassDef(node);
        this.stack.pop();
        return null;
    }

    public Object visitAttribute(Attribute node) throws Exception {
        Object ret = super.visitAttribute(node);
        NameTok attr = (NameTok)node.attr;
        if (attr.ctx == 8 && attr.id.equals(this.getModuleNameLastPart())) {
            AttributeASTEntry entry;
            String checkName = NodeUtils.getFullRepresentationString((SimpleNode)node);
            if (checkName.equals(this.initialModuleName)) {
                List parts = NodeUtils.getAttributeParts((Attribute)node);
                entry = new AttributeASTEntry(checkName, (SimpleNode)parts.get(0), true);
            } else {
                entry = new AttributeASTEntry(attr.id, (SimpleNode)attr, false);
            }
            if (this.checkIndirectReferenceFromDefinition(checkName, true, entry, attr.beginColumn, attr.beginLine)) {
                return true;
            }
        }
        return ret;
    }

    public Object visitImportFrom(ImportFrom node) throws Exception {
        Tuple modNameAndIsRelative;
        int level = node.level;
        String modRep = NodeUtils.getRepresentationString((ISimpleNode)node.module);
        if (level > 0) {
            modRep = this.makeRelative(level, modRep);
            modNameAndIsRelative = new Tuple((Object)modRep, (Object)false);
        } else {
            modNameAndIsRelative = new Tuple((Object)modRep, (Object)false);
        }
        boolean matched = this.handleNames((SimpleNode)node, node.names, (String)modNameAndIsRelative.o1, true);
        if (!matched) {
            String modRep2 = (String)modNameAndIsRelative.o1;
            boolean isRelative = (Boolean)modNameAndIsRelative.o2;
            if (modRep2.equals(this.initialModuleName) || !isRelative && (modRep2 + ".").startsWith(this.initialModuleName + ".")) {
                this.importFromsMatchingOnModulePart.add(node);
                this.occurrences.add(new ImportFromModPartRenameAstEntry(null, node, modRep2, this.initialModuleName));
                matched = true;
            }
        }
        return null;
    }

    protected String makeRelative(int level, String modRep) {
        String parentPackage = this.currentModule.getName();
        List moduleParts = StringUtils.split((String)parentPackage, (char)'.');
        if (moduleParts.size() > level) {
            String relative = FullRepIterable.joinParts((List)moduleParts, (int)(moduleParts.size() - level));
            modRep = modRep.isEmpty() ? relative : StringUtils.join((String)".", (Object[])new Object[]{relative, modRep});
        }
        return modRep;
    }

    public boolean handleNames(SimpleNode node, aliasType[] names, String modRep, boolean onlyFullMatch) {
        boolean handled = false;
        if (names != null && names.length > 0) {
            TreeSet<Integer> aliasesHandled = new TreeSet<Integer>();
            ImportFromRenameAstEntry renameAstEntry = new ImportFromRenameAstEntry(null, node);
            int i = 0;
            while (i < names.length) {
                aliasType aliasType2 = names[i];
                NameTok name = (NameTok)aliasType2.name;
                String nameInImport = name.id;
                String full = modRep != null && modRep.length() > 0 ? StringUtils.join((String)".", (Object[])new Object[]{modRep, nameInImport}) : nameInImport;
                boolean addAsSearchString = aliasType2.asname == null;
                boolean equals = full.equals(this.initialModuleName);
                boolean startsWith = (full + ".").startsWith(this.initialModuleName);
                if (equals || startsWith && !onlyFullMatch) {
                    if (node instanceof ImportFrom) {
                        this.importFromsMatchingOnAliasPart.add((ImportFrom)node);
                        aliasesHandled.add(i);
                        if (addAsSearchString) {
                            this.searchStringsAs.add(nameInImport);
                        }
                    } else if (node instanceof Import) {
                        this.importsMatchingOnAliasPart.add((Import)node);
                        aliasesHandled.add(i);
                        if (addAsSearchString) {
                            this.searchStringsAs.add(nameInImport);
                        }
                    }
                    if (aliasType2.asname == null) {
                        boolean forceFull = node instanceof Import && startsWith && full.contains(".");
                        String checkName = forceFull ? this.initialModuleName : nameInImport;
                        this.findOccurrences(forceFull, checkName);
                    }
                    handled = true;
                } else if (nameInImport.equals(this.getModuleNameLastPart()) && this.checkIndirectReferenceFromDefinition(nameInImport, addAsSearchString, renameAstEntry, node.beginColumn, node.beginLine)) {
                    this.findOccurrences(false, nameInImport);
                    aliasesHandled.add(i);
                    handled = true;
                }
                ++i;
            }
            if (aliasesHandled.size() > 0) {
                renameAstEntry.indexes = aliasesHandled;
                this.occurrences.add(renameAstEntry);
            }
        }
        return handled;
    }

    protected void findOccurrences(boolean forceFull, String checkName) {
        List<ASTEntry> localOccurrences = ScopeAnalysis.getLocalOccurrences(checkName, (SimpleNode)this.stack.peek());
        for (ASTEntry astEntry : localOccurrences) {
            if (astEntry.node instanceof NameTok && (((NameTok)astEntry.node).ctx == 4 || ((NameTok)astEntry.node).ctx == 7)) continue;
            this.occurrences.add(new PyRenameImportProcess.FixedInputStringASTEntry(checkName, null, astEntry.node, forceFull));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean checkIndirectReferenceFromDefinition(String nameInImport, boolean addAsSearchString, ASTEntry renameAstEntry, int beginColumn, int beginLine) {
        ArrayList definitions = new ArrayList();
        try {
            IDefinition iDefinition;
            String modName;
            boolean acceptTypeshed = InterpreterGeneralPreferences.getUseTypeshed();
            PyRefactoringFindDefinition.findActualDefinition((IProgressMonitor)this.monitor, (boolean)acceptTypeshed, (IModule)this.currentModule, (String)nameInImport, definitions, (int)beginLine, (int)beginColumn, (IPythonNature)this.nature, (ICompletionCache)this.completionState);
            Iterator iterator = definitions.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(modName = this.getWithoutInit((iDefinition = (IDefinition)iterator.next()).getModule().getName())).equals(this.initialModuleName));
            this.occurrences.add(renameAstEntry);
            if (!addAsSearchString) return true;
            this.searchStringsAs.add(nameInImport);
            return true;
        }
        catch (CompletionRecursionException e) {
            Log.log((Throwable)e);
            return false;
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return false;
    }

    private String getWithoutInit(String initialName) {
        if (initialName.endsWith(".__init__")) {
            initialName = initialName.substring(0, initialName.length() - 9);
        }
        return initialName;
    }

    public Object visitImport(Import node) throws Exception {
        aliasType[] names = node.names;
        boolean matched = this.handleNames((SimpleNode)node, names, "", false);
        if (!matched && this.nature.getGrammarVersion() < 99) {
            String relative = this.makeRelative(1, "");
            this.handleNames((SimpleNode)node, names, relative, true);
        }
        return null;
    }

    public List<ASTEntry> getEntryOccurrences() {
        return new ArrayList<ASTEntry>(this.occurrences);
    }

    private static final class AttributeASTEntry
    extends ASTEntry
    implements IRefactorCustomEntry {
        private final String fixedInitialString;
        private final boolean fullAttrMatch;

        private AttributeASTEntry(String initial, SimpleNode node, boolean fullAttrMatch) {
            super(null, node);
            this.fixedInitialString = initial;
            this.fullAttrMatch = fullAttrMatch;
        }

        @Override
        public List<TextEdit> createRenameEdit(IDocument doc, String initialName, String inputName, RefactoringStatus status, IPath file, IPythonNature nature) {
            initialName = this.fixedInitialString;
            if (!this.fullAttrMatch) {
                inputName = FullRepIterable.getLastPart((String)inputName);
            }
            int offset = AbstractRenameRefactorProcess.getOffset(doc, this);
            TextEditCreation.checkExpectedInput(doc, this.node.beginLine, offset, initialName, status, file);
            ReplaceEdit replaceEdit = new ReplaceEdit(offset, initialName.length(), inputName);
            List<TextEdit> edits = Arrays.asList(replaceEdit);
            return edits;
        }
    }

    private static final class ImportFromModPartRenameAstEntry
    extends ImportRenameAstEntry {
        private String matchedAs;
        private String initialModuleName;

        private ImportFromModPartRenameAstEntry(ASTEntry parent, ImportFrom node, String matchedAs, String initialModuleName) {
            super(parent, (SimpleNode)node);
            this.matchedAs = matchedAs;
            this.initialModuleName = initialModuleName;
        }

        @Override
        public List<TextEdit> createRenameEdit(IDocument doc, String initialName, String inputName, RefactoringStatus status, IPath file, IPythonNature nature) {
            ImportFrom f = (ImportFrom)this.node;
            String modId = ((NameTok)f.module).id;
            if (!(modId + ".").startsWith(initialName)) {
                initialName = modId;
            }
            int offset = PySelection.getAbsoluteCursorOffset((IDocument)doc, (int)(f.module.beginLine - 1), (int)(f.module.beginColumn - 1));
            TextEditCreation.checkExpectedInput(doc, this.node.beginLine, offset, initialName, status, file);
            ReplaceEdit replaceEdit = new ReplaceEdit(offset - f.level, initialName.length() + f.level, inputName);
            return Arrays.asList(replaceEdit);
        }
    }

    private static final class ImportFromRenameAstEntry
    extends ImportRenameAstEntry {
        public Set<Integer> indexes;

        private ImportFromRenameAstEntry(ASTEntry parent, SimpleNode node) {
            super(parent, node);
            Assert.isTrue((node instanceof ImportFrom || node instanceof Import ? 1 : 0) != 0);
        }

        @Override
        public List<TextEdit> createRenameEdit(IDocument doc, String initialName, String inputName, RefactoringStatus status, IPath file, IPythonNature nature) {
            String line = PySelection.getLine((IDocument)doc, (int)(this.node.beginLine - 1));
            ArrayList<TextEdit> ret = new ArrayList<TextEdit>();
            stmtType importFrom = (stmtType)this.node;
            stmtType copied = (stmtType)importFrom.createCopy(false);
            ArrayList<Integer> sorted = new ArrayList<Integer>(this.indexes);
            Collections.sort(sorted);
            Collections.reverse(sorted);
            ArrayList body = new ArrayList();
            ArrayList<aliasType> names = new ArrayList<aliasType>();
            ArrayList<Import> forcedImports = new ArrayList<Import>();
            for (int aliasIndex : this.indexes) {
                Object[] copiedNodeNames = this.getNames((SimpleNode)copied);
                aliasType alias = copiedNodeNames[aliasIndex];
                this.setNames((SimpleNode)copied, (aliasType[])ArrayUtils.remove((Object[])copiedNodeNames, (int)aliasIndex, aliasType.class));
                String full = this.getFull(importFrom, (NameTok)alias.name);
                boolean forceImport = importFrom instanceof Import && full.contains(".");
                String firstPart = forceImport ? inputName : FullRepIterable.getLastPart((String)inputName);
                if (full.startsWith(initialName + ".")) {
                    t = (NameTok)alias.name;
                    t.id = firstPart + "." + full.substring(initialName.length() + 1);
                } else {
                    t = (NameTok)alias.name;
                    t.id = firstPart;
                }
                if (forceImport) {
                    forcedImports.add(new Import(new aliasType[]{alias}));
                    continue;
                }
                names.add(alias);
            }
            if (forcedImports.size() > 0) {
                body.addAll(forcedImports);
            }
            if (names.size() > 0) {
                if (inputName.indexOf(".") == -1) {
                    body.add(new Import(names.toArray(new aliasType[names.size()])));
                } else {
                    String[] headAndTail = FullRepIterable.headAndTail((String)inputName);
                    NameTok nameTok = new NameTok(headAndTail[0], 7);
                    body.add(new ImportFrom((NameTokType)nameTok, names.toArray(new aliasType[names.size()]), 0));
                }
            }
            if (this.getNames((SimpleNode)copied).length > 0) {
                body.add(0, copied);
            }
            Module module = new Module(body.toArray(new stmtType[body.size()]));
            String delimiter = PySelection.getDelimiter((IDocument)doc);
            PrettyPrinterPrefsV2 prefsV2 = PrettyPrinterV2.createDefaultPrefs((IGrammarVersionProvider)nature, (IIndentPrefs)DefaultIndentPrefs.get((IAdaptable)nature), (String)delimiter);
            PrettyPrinterV2 prettyPrinterV2 = new PrettyPrinterV2((IPrettyPrinterPrefs)prefsV2);
            String str = null;
            try {
                try {
                    MakeAstValidForPrettyPrintingVisitor.makeValid((SimpleNode)module);
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
                str = prettyPrinterV2.print((SimpleNode)module);
            }
            catch (IOException e) {
                status.addFatalError("Unexpected exception: " + e.getMessage());
                Log.log((Throwable)e);
            }
            if (str != null) {
                str = StringUtils.rightTrim((String)str);
                Tuple startEndOffset = NodeUtils.getStartEndOffset((IDocument)doc, (SimpleNode)this.node);
                ReplaceEdit replaceEdit = new ReplaceEdit(((Integer)startEndOffset.o1).intValue(), (Integer)startEndOffset.o2 - (Integer)startEndOffset.o1, str);
                ret.add((TextEdit)replaceEdit);
            }
            return ret;
        }

        private String getFull(stmtType imp, NameTok name) {
            if (imp instanceof ImportFrom) {
                ImportFrom importFrom = (ImportFrom)imp;
                return ((NameTok)importFrom.module).id + "." + name.id;
            }
            return name.id;
        }

        private void setNames(SimpleNode copied, aliasType[] arr) {
            if (copied instanceof ImportFrom) {
                ((ImportFrom)copied).names = arr;
                return;
            }
            if (copied instanceof Import) {
                ((Import)copied).names = arr;
                return;
            }
            throw new AssertionError((Object)("Expected Import or ImportFrom. Found: " + String.valueOf(copied.getClass())));
        }

        private aliasType[] getNames(SimpleNode copied) {
            if (copied instanceof ImportFrom) {
                return ((ImportFrom)copied).names;
            }
            if (copied instanceof Import) {
                return ((Import)copied).names;
            }
            throw new AssertionError((Object)("Expected Import or ImportFrom. Found: " + String.valueOf(copied.getClass())));
        }
    }
}

