/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.ruff;

import com.python.pydev.analysis.external.ExternalAnalizerProcessWatchDoc;
import com.python.pydev.analysis.external.IExternalAnalyzer;
import com.python.pydev.analysis.external.IExternalCodeAnalysisStream;
import com.python.pydev.analysis.external.WriteToStreamHelper;
import com.python.pydev.analysis.ruff.RuffPreferences;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.python.pydev.ast.location.FindWorkspaceFiles;
import org.python.pydev.ast.runners.SimplePythonRunner;
import org.python.pydev.ast.runners.SimpleRunner;
import org.python.pydev.core.CheckAnalysisErrors;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.json.eclipsesource.JsonArray;
import org.python.pydev.json.eclipsesource.JsonObject;
import org.python.pydev.json.eclipsesource.JsonValue;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.callbacks.ICallback0;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.markers.PyMarkerUtils;
import org.python.pydev.shared_core.process.ProcessUtils;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.utils.ArrayUtils;

final class RuffAnalysis
implements IExternalAnalyzer {
    private final IResource resource;
    private final IDocument fDocument;
    private final IPath location;
    private final Map<IResource, List<PyMarkerUtils.MarkerInfo>> fileToMarkers = new HashMap<IResource, List<PyMarkerUtils.MarkerInfo>>();
    private final IProgressMonitor monitor;
    private Thread processWatchDoc;
    private final File ruffLocation;

    public RuffAnalysis(IResource resource, IDocument document, IPath location, IProgressMonitor monitor, File ruffLocation) {
        this.resource = resource;
        this.fDocument = document;
        this.location = location;
        this.monitor = monitor;
        this.ruffLocation = ruffLocation;
    }

    void createRuffProcess(IExternalCodeAnalysisStream out) throws CoreException, MisconfigurationException, PythonNatureWithoutProjectException {
        ICallback0 launchProcessCallback;
        String target = this.location.toOSString();
        ArrayList<String> cmdList = new ArrayList<String>();
        String userArgs = StringUtils.replaceNewLines((String)RuffPreferences.getRuffArgs((IAdaptable)this.resource), (String)" ");
        ArrayList<String> userArgsAsList = new ArrayList<String>(Arrays.asList(ProcessUtils.parseArguments((String)userArgs)));
        IProject project = this.resource.getProject();
        if (project == null || !project.isAccessible()) {
            Log.log((String)("Unable to run ruff in: " + target + ". Project not available (" + String.valueOf(project) + ")."));
            return;
        }
        File workingDir = project.getLocation().toFile();
        cmdList.addAll(userArgsAsList);
        cmdList.add(target);
        PythonNature nature = PythonNature.getPythonNature((IProject)project);
        ICallback<String[], String[]> updateEnv = new ICallback<String[], String[]>(){

            public String[] call(String[] arg) {
                int i = 0;
                while (i < arg.length) {
                    if (arg[i].startsWith("RUFF_FORMAT=")) {
                        arg[i] = "RUFF_FORMAT=json";
                    } else if (arg[i].startsWith("RUFF_OUTPUT_FORMAT=")) {
                        arg[i] = "RUFF_OUTPUT_FORMAT=json";
                    }
                    ++i;
                }
                return (String[])ArrayUtils.concatArrays((Object[][])new String[][]{arg, {"RUFF_FORMAT=json", "RUFF_OUTPUT_FORMAT=json"}});
            }
        };
        if (this.ruffLocation == null) {
            launchProcessCallback = () -> this.lambda$0((IPythonNature)nature, cmdList, out, workingDir, (ICallback)updateEnv);
        } else {
            String ruffExecutable = FileUtils.getFileAbsolutePath((File)this.ruffLocation);
            cmdList.add(0, ruffExecutable);
            cmdList.add(1, "check");
            launchProcessCallback = () -> RuffAnalysis.lambda$1(cmdList, out, workingDir, (IPythonNature)nature, (ICallback)updateEnv);
        }
        this.processWatchDoc = new ExternalAnalizerProcessWatchDoc(out, this.monitor, this, (ICallback0<Process>)launchProcessCallback, project, true);
        this.processWatchDoc.start();
    }

    @Override
    public void afterRunProcess(String output, String errors, IExternalCodeAnalysisStream out) {
        JsonValue jsonValue;
        boolean resourceIsContainer = this.resource instanceof IContainer;
        IProject project = null;
        IFile moduleFile = null;
        if (resourceIsContainer) {
            project = this.resource.getProject();
            if (project == null) {
                Log.log((String)"Expected resource to have project for RuffAnalysis.");
                return;
            }
            if (!project.isAccessible()) {
                Log.log((String)"Expected project to be accessible for RuffAnalysis.");
                return;
            }
        } else if (this.resource instanceof IFile) {
            moduleFile = (IFile)this.resource;
        } else {
            return;
        }
        output = output.trim();
        errors = errors.trim();
        HashMap<ModuleLineCol, MessageInfo> moduleLineColToMessage = new HashMap<ModuleLineCol, MessageInfo>();
        if (!output.isEmpty()) {
            WriteToStreamHelper.write("Ruff: The stdout of the command line is:\n", out, output);
        }
        if (!errors.isEmpty()) {
            WriteToStreamHelper.write("Ruff: The stderr of the command line is:\n", out, errors);
        }
        if (output.indexOf("Traceback (most recent call last):") != -1) {
            RuntimeException e = new RuntimeException("Ruff ERROR: \n" + output);
            Log.log((Throwable)e);
            return;
        }
        if (errors.indexOf("Traceback (most recent call last):") != -1) {
            RuntimeException e = new RuntimeException("Ruff ERROR: \n" + errors);
            Log.log((Throwable)e);
            return;
        }
        FastStringBuffer fileNameBuf = new FastStringBuffer();
        String loc = this.location != null ? this.location.toString().toLowerCase() : null;
        String res = null;
        if (this.resource != null && this.resource.getFullPath() != null) {
            res = this.resource.getFullPath().toString().toLowerCase();
        }
        if (output.isEmpty()) {
            return;
        }
        try {
            jsonValue = JsonValue.readFrom((String)output);
        }
        catch (Exception e) {
            Log.log((String)StringUtils.format((String)"Expected ruff output to be with json format. i.e.: --format=json.\nFile: %s\nOutput:\n%s", (Object[])new Object[]{this.resource.getFullPath(), output}), (Throwable)e);
            return;
        }
        if (jsonValue == null) {
            Log.log((String)"Ruff output returned null json value!");
            return;
        }
        HashMap<IFile, IDocument> resourceToDocCache = new HashMap<IFile, IDocument>();
        if (!jsonValue.isArray()) {
            Log.log((String)"Expected ruff output to be a json array");
            return;
        }
        JsonArray asArray = jsonValue.asArray();
        for (JsonValue problemValue : asArray) {
            IDocument document;
            if (this.monitor.isCanceled()) {
                return;
            }
            if (!problemValue.isObject()) {
                Log.log((String)("Ruff: In ruff output, expected value to be an object. Found: " + String.valueOf(problemValue)));
                continue;
            }
            JsonObject problemObject = problemValue.asObject();
            JsonValue location = problemObject.get("location");
            if (location == null) {
                Log.log((String)("Ruff: Expected to find location in ruff output. Found: " + String.valueOf(problemValue)));
                continue;
            }
            if (!location.isObject()) {
                Log.log((String)("Ruff: Expected location to be an object in ruff output. Found: " + String.valueOf(problemValue)));
                continue;
            }
            JsonObject locationObject = location.asObject();
            JsonValue rowJson = locationObject.get("row");
            if (rowJson == null || !rowJson.isNumber()) {
                Log.log((String)("Ruff: Expected row to be a number. Found: " + String.valueOf(rowJson)));
                continue;
            }
            int line = rowJson.asInt() - 1;
            JsonValue columnJson = locationObject.get("column");
            if (columnJson == null || !columnJson.isNumber()) {
                Log.log((String)("Ruff: Expected column to be a number. Found: " + String.valueOf(columnJson)));
            }
            int column = columnJson.asInt() - 1;
            JsonValue filename = problemObject.get("filename");
            if (filename == null || !filename.isString()) {
                Log.log((String)("Ruff: Expected filename to be a string. Found: " + String.valueOf(filename)));
            }
            if (resourceIsContainer) {
                block49: {
                    try {
                        moduleFile = FindWorkspaceFiles.getFileForLocation((IPath)Path.fromOSString((String)filename.asString()), (IProject)project);
                        if (moduleFile == null) {
                            Log.log((String)("Ruff: Could not find file for path: " + String.valueOf(filename)));
                        }
                        break block49;
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                    }
                    continue;
                }
                document = (IDocument)resourceToDocCache.get(moduleFile);
                if (document == null) {
                    document = FileUtils.getDocFromResource((IResource)moduleFile);
                    if (document == null) continue;
                    resourceToDocCache.put(moduleFile, document);
                }
            } else {
                document = this.fDocument;
                IFile fileForLocation = FindWorkspaceFiles.getFileForLocation((IPath)Path.fromOSString((String)filename.asString()), (IProject)project);
                if (fileForLocation == null) {
                    Log.log((String)("Ruff: Could not find file for path: " + String.valueOf(filename)));
                    continue;
                }
                fileNameBuf.clear();
                fileNameBuf.append(filename.asString()).trim().replaceAll('\\', '/');
                String fileName = fileNameBuf.toString().toLowerCase();
                if (!(loc == null && res == null || loc != null && loc.contains(fileName) || res != null && res.contains(fileName))) {
                    Log.log((String)("Ruff: Skipped file: " + fileName + " because it doesn match the current one: " + res));
                    continue;
                }
            }
            String messageId = "ruff";
            JsonValue messageJson = problemObject.get("message");
            if (messageJson == null || !messageJson.isString()) {
                Log.log((String)("Ruff: expected message to be a string in: " + String.valueOf(problemObject)));
                continue;
            }
            JsonValue code = problemObject.get("code");
            if (code == null || !code.isString()) {
                Log.log((String)("Ruff: expected code to be a string in: " + String.valueOf(problemObject)));
                continue;
            }
            String message = messageJson.asString() + " (code: " + code.asString() + ")";
            int markerSeverity = -1;
            switch (code.asString()) {
                case "E902": 
                case "E999": 
                case "F821": {
                    markerSeverity = 2;
                    break;
                }
                default: {
                    markerSeverity = 1;
                }
            }
            String lineContents = PySelection.getLine((IDocument)document, (int)line);
            if (CheckAnalysisErrors.isRuffErrorHandledAtLine((String)lineContents, (String)code.asString())) continue;
            IRegion region = null;
            try {
                region = document.getLineInformation(line);
                if (region == null || document == null) continue;
                ModuleLineCol moduleLineCol = new ModuleLineCol(moduleFile, line, column);
                MessageInfo messageInfo = (MessageInfo)moduleLineColToMessage.get(moduleLineCol);
                if (messageInfo == null) {
                    messageInfo = new MessageInfo(message, markerSeverity, messageId, line, column, document.get(region.getOffset(), region.getLength()), moduleFile, document);
                    moduleLineColToMessage.put(moduleLineCol, messageInfo);
                    continue;
                }
                messageInfo.addMessageLine(message);
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        for (MessageInfo messageInfo : moduleLineColToMessage.values()) {
            this.addToMarkers(messageInfo.message.toString(), messageInfo.markerSeverity, messageInfo.messageId, messageInfo.line, messageInfo.column, messageInfo.docLineContents, messageInfo.moduleFile, messageInfo.document);
        }
    }

    private void addToMarkers(String tok, int priority, String id, int line, int column, String lineContents, IFile moduleFile, IDocument document) {
        HashMap<String, String> additionalInfo = new HashMap<String, String>();
        additionalInfo.put("ruff_message_id", id);
        List<PyMarkerUtils.MarkerInfo> list = this.fileToMarkers.get(moduleFile);
        if (list == null) {
            list = new ArrayList<PyMarkerUtils.MarkerInfo>();
            this.fileToMarkers.put((IResource)moduleFile, list);
        }
        list.add(new PyMarkerUtils.MarkerInfo(document, "Ruff: " + tok, "org.python.pydev.ruffproblemmarker", priority, false, false, line, column, line, lineContents.length(), additionalInfo));
    }

    public List<PyMarkerUtils.MarkerInfo> getMarkers(IResource resource) {
        List<PyMarkerUtils.MarkerInfo> ret = this.fileToMarkers.get(resource);
        if (ret == null) {
            return new ArrayList<PyMarkerUtils.MarkerInfo>();
        }
        return new ArrayList<PyMarkerUtils.MarkerInfo>(ret);
    }

    @Override
    public void join() {
        if (this.processWatchDoc != null) {
            try {
                this.processWatchDoc.join();
            }
            catch (InterruptedException e) {
                Log.log((Throwable)e);
            }
        }
    }

    private /* synthetic */ Process lambda$0(IPythonNature iPythonNature, ArrayList arrayList, IExternalCodeAnalysisStream iExternalCodeAnalysisStream, File file, ICallback iCallback) {
        String interpreter;
        try {
            interpreter = iPythonNature.getProjectInterpreter().getExecutableOrJar();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        arrayList.add(0, "ruff");
        arrayList.add(1, "check");
        String[] args = arrayList.toArray(new String[0]);
        WriteToStreamHelper.write("Ruff: Executing command line:", iExternalCodeAnalysisStream, "python", "-m", args);
        SimplePythonRunner runner = new SimplePythonRunner();
        String[] parameters = SimplePythonRunner.preparePythonCallParameters((String)interpreter, (String)"-m", (String[])args);
        Tuple r = runner.run(parameters, file, iPythonNature, this.monitor, iCallback);
        return (Process)r.o1;
    }

    private static /* synthetic */ Process lambda$1(ArrayList arrayList, IExternalCodeAnalysisStream iExternalCodeAnalysisStream, File file, IPythonNature iPythonNature, ICallback iCallback) {
        String[] args = arrayList.toArray(new String[0]);
        WriteToStreamHelper.write("Ruff: Executing command line:", iExternalCodeAnalysisStream, new Object[]{args});
        SimpleRunner simpleRunner = new SimpleRunner();
        Tuple r = simpleRunner.run(args, file, iPythonNature, null, iCallback);
        Process process = (Process)r.o1;
        return process;
    }

    private static class MessageInfo {
        private final FastStringBuffer message = new FastStringBuffer();
        private final int markerSeverity;
        private final String messageId;
        private final int line;
        private final int column;
        private final String docLineContents;
        private final IFile moduleFile;
        private final IDocument document;

        public MessageInfo(String message, int markerSeverity, String messageId, int line, int column, String docLineContents, IFile moduleFile, IDocument document) {
            this.message.append(message);
            this.markerSeverity = markerSeverity;
            this.messageId = messageId;
            this.line = line;
            this.column = column;
            this.docLineContents = docLineContents;
            this.moduleFile = moduleFile;
            this.document = document;
        }

        public void addMessageLine(String message) {
            this.message.append('\n').append(message);
        }
    }

    private static class ModuleLineCol {
        private IFile moduleFile;
        private final int line;
        private final int col;

        public ModuleLineCol(IFile moduleFile, int line, int col) {
            this.moduleFile = moduleFile;
            this.line = line;
            this.col = col;
        }

        public int hashCode() {
            return Objects.hash(this.col, this.line, this.moduleFile);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ModuleLineCol other = (ModuleLineCol)obj;
            return this.col == other.col && this.line == other.line && Objects.equals(this.moduleFile, other.moduleFile);
        }
    }
}

