/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.scopeanalysis;

import com.python.pydev.analysis.scopeanalysis.ScopeAnalyzerVisitorWithoutImports;
import com.python.pydev.analysis.visitors.Found;
import com.python.pydev.analysis.visitors.ImportChecker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.ast.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.ast.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.ast.codecompletion.revisited.visitors.AbstractVisitor;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Import;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.NameTokType;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.aliasType;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.shared_core.string.FullRepIterable;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.structure.Tuple3;
import org.python.pydev.shared_core.structure.Tuple4;

public class ScopeAnalyzerVisitor
extends ScopeAnalyzerVisitorWithoutImports {
    private static final String UNRESOLVED_MOD_NAME = "__UNRESOLVED__MOD__NAME__!";
    protected Map<String, List<Tuple3<Found, Integer, ASTEntry>>> importsFoundFromModuleName = new HashMap<String, List<Tuple3<Found, Integer, ASTEntry>>>();
    protected Map<String, List<Tuple3<Found, Integer, ASTEntry>>> importsFound = new HashMap<String, List<Tuple3<Found, Integer, ASTEntry>>>();

    public ScopeAnalyzerVisitor(IPythonNature nature, String moduleName, IModule current, IProgressMonitor monitor, PySelection ps) throws BadLocationException {
        super(nature, moduleName, current, monitor, ps);
    }

    public ScopeAnalyzerVisitor(IPythonNature nature, String moduleName, IModule current, IDocument document, IProgressMonitor monitor, String pNameToFind, int absoluteCursorOffset, String[] tokenAndQual) throws BadLocationException {
        super(nature, moduleName, current, document, monitor, pNameToFind, absoluteCursorOffset, tokenAndQual);
    }

    private void addFoundToImportsMap(Found found, Map<String, List<Tuple3<Found, Integer, ASTEntry>>> map) {
        List<Tuple3<Found, Integer, ASTEntry>> prev;
        ImportChecker.ImportInfo info = found.importInfo;
        String modName = UNRESOLVED_MOD_NAME;
        if (info != null && info.mod != null) {
            modName = info.mod.getName();
        }
        if ((prev = map.get(modName)) == null) {
            prev = new ArrayList<Tuple3<Found, Integer, ASTEntry>>();
            map.put(modName, prev);
        }
        prev.add((Tuple3<Found, Integer, ASTEntry>)new Tuple3((Object)found, (Object)-1, (Object)this.peekParent()));
    }

    @Override
    public Object visitImportFrom(ImportFrom node) throws Exception {
        Object ret = super.visitImportFrom(node);
        NameTok tokModName = (NameTok)node.module;
        for (String m : new FullRepIterable(tokModName.id)) {
            if (m.indexOf(".") != -1) continue;
            aliasType[] names = new aliasType[1];
            NameTok importNameTok = new NameTok(m, 7);
            importNameTok.beginLine = tokModName.beginLine;
            importNameTok.beginColumn = tokModName.beginColumn;
            names[0] = new aliasType((NameTokType)importNameTok, null);
            names[0].beginLine = tokModName.beginLine;
            names[0].beginColumn = tokModName.beginColumn;
            Import importTok = new Import(names);
            importTok.beginLine = tokModName.beginLine;
            importTok.beginColumn = tokModName.beginColumn;
            List createdTokens = AbstractVisitor.makeImportToken((Import)importTok, null, (String)this.current.getName(), (boolean)true, (IPythonNature)this.current.getNature(), (IModule)this.current);
            for (IToken token : createdTokens) {
                ImportChecker.ImportInfo info = this.scope.importChecker.visitImportToken(token, false, this.completionCache);
                Found found = new Found(token, token, this.scope.getCurrScopeId(), this.scope.getCurrScopeItems());
                found.importInfo = info;
                this.checkFound(found, this.peekParent());
                this.addFoundToImportsMap(found, this.importsFoundFromModuleName);
            }
        }
        return ret;
    }

    @Override
    public void onImportInfoSetOnFound(Found found) {
        super.onImportInfoSetOnFound(found);
        this.addFoundToImportsMap(found, this.importsFound);
    }

    @Override
    protected void onGetCompleteTokenOccurrences(Tuple3<Found, Integer, ASTEntry> found, Set<IToken> f, ArrayList<Tuple4<IToken, Integer, ASTEntry, Found>> ret) {
        Tuple<List<Tuple4<IToken, Integer, ASTEntry, Found>>, List<Tuple4<IToken, Integer, ASTEntry, Found>>> matchingImportEntries = this.getImportEntries(found, f);
        List fromModule = (List)matchingImportEntries.o1;
        List fromImports = (List)matchingImportEntries.o2;
        ret.addAll(fromModule);
        ret.addAll(fromImports);
        for (Tuple4 tuple3 : fromImports) {
            try {
                if (!(tuple3.o1 instanceof SourceToken)) continue;
                SourceToken tok = (SourceToken)tuple3.o1;
                SimpleNode ast = tok.getAst();
                int line = 0;
                int col = 0;
                if (!(ast instanceof Import)) continue;
                Import import1 = (Import)ast;
                line = import1.names[0].beginLine - 1;
                col = import1.names[0].beginColumn - 1;
                PySelection ps = new PySelection(this.document, line, col);
                ScopeAnalyzerVisitorWithoutImports analyzerVisitorWithoutImports = new ScopeAnalyzerVisitorWithoutImports(this.nature, this.moduleName, this.current, this.monitor, ps);
                SourceModule s = (SourceModule)this.current;
                s.getAst().accept((VisitorIF)analyzerVisitorWithoutImports);
                analyzerVisitorWithoutImports.checkFinished();
                ArrayList<Tuple4<IToken, Integer, ASTEntry, Found>> completeTokenOccurrences = analyzerVisitorWithoutImports.getCompleteTokenOccurrences();
                for (Tuple4<IToken, Integer, ASTEntry, Found> oc : completeTokenOccurrences) {
                    if (f.contains(oc.o1) || ((IToken)oc.o1).isImport()) continue;
                    if ((Integer)oc.o2 < (Integer)tuple3.o2) {
                        oc.o2 = (Integer)tuple3.o2;
                    }
                    f.add((IToken)oc.o1);
                    ret.add(oc);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Tuple<List<Tuple4<IToken, Integer, ASTEntry, Found>>, List<Tuple4<IToken, Integer, ASTEntry, Found>>> getImportEntries(Tuple3<Found, Integer, ASTEntry> found, Set<IToken> f) {
        ArrayList<Tuple4<IToken, Integer, ASTEntry, Found>> fromModuleRet = new ArrayList<Tuple4<IToken, Integer, ASTEntry, Found>>();
        ArrayList<Tuple4<IToken, Integer, ASTEntry, Found>> fromImportsRet = new ArrayList<Tuple4<IToken, Integer, ASTEntry, Found>>();
        if (((Found)found.o1).isImport()) {
            String key = UNRESOLVED_MOD_NAME;
            if (((Found)found.o1).importInfo != null && ((Found)found.o1).importInfo.mod != null) {
                key = ((Found)found.o1).importInfo.mod.getName();
            }
            List<Tuple3<Found, Integer, ASTEntry>> fromModule = this.importsFoundFromModuleName.get(key);
            List<Tuple3<Found, Integer, ASTEntry>> fromImports = this.importsFound.get(key);
            this.checkImportEntries(fromModuleRet, f, fromModule, (Integer)found.o2);
            this.checkImportEntries(fromImportsRet, f, fromImports, (Integer)found.o2);
        }
        return new Tuple(fromModuleRet, fromImportsRet);
    }

    private void checkImportEntries(List<Tuple4<IToken, Integer, ASTEntry, Found>> ret, Set<IToken> f, List<Tuple3<Found, Integer, ASTEntry>> importEntries, int colDelta) {
        if (importEntries != null) {
            for (Tuple3<Found, Integer, ASTEntry> foundInFromModule : importEntries) {
                IToken generator = ((Found)foundInFromModule.o1).getSingle().generator;
                Tuple4 tup3 = new Tuple4((Object)generator, (Object)(colDelta > (Integer)foundInFromModule.o2 ? colDelta : (Integer)foundInFromModule.o2), (Object)((ASTEntry)foundInFromModule.o3), (Object)((Found)foundInFromModule.o1));
                if (f.contains(generator)) continue;
                f.add(generator);
                ret.add((Tuple4<IToken, Integer, ASTEntry, Found>)tup3);
            }
        }
    }
}

