/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.visitors;

import com.python.pydev.analysis.visitors.ScopeItems;
import java.util.ArrayList;
import java.util.List;
import org.python.pydev.core.IToken;
import org.python.pydev.shared_core.string.FastStringBuffer;

public final class GenAndTok {
    public final IToken generator;
    public final IToken tok;
    public final List<IToken> references = new ArrayList<IToken>();
    public final int scopeId;
    public final ScopeItems scopeFound;
    public final boolean inTypeChecking;

    public GenAndTok(IToken generator, IToken tok, int scopeId, ScopeItems scopeFound) {
        this.generator = generator;
        this.tok = tok;
        this.scopeId = scopeId;
        this.scopeFound = scopeFound;
        this.inTypeChecking = scopeFound.isInTypeChecking();
    }

    public String toString() {
        FastStringBuffer buffer = new FastStringBuffer();
        buffer.append("GenAndTok [ ");
        buffer.append(this.generator.getRepresentation());
        buffer.append(" - ");
        buffer.append(this.tok.getRepresentation());
        buffer.append(" (scopeId:");
        buffer.append(this.scopeId);
        buffer.append(") ");
        if (this.references.size() > 0) {
            buffer.append(" (references:");
            for (IToken ref : this.references) {
                buffer.append(ref.getRepresentation());
                buffer.append(",");
            }
            buffer.deleteLast();
            buffer.append(") ");
        }
        buffer.append("]");
        return buffer.toString();
    }

    public List<IToken> getAllTokens() {
        ArrayList<IToken> ret = new ArrayList<IToken>();
        ret.add(this.generator);
        ret.addAll(this.references);
        return ret;
    }
}

