/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.visitors;

import com.python.pydev.analysis.scopeanalysis.AbstractScopeAnalyzerVisitor;
import com.python.pydev.analysis.visitors.Found;
import com.python.pydev.analysis.visitors.GenAndTok;
import com.python.pydev.analysis.visitors.ImportChecker;
import com.python.pydev.analysis.visitors.ScopeItems;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.core.IterTokenEntry;
import org.python.pydev.core.TokensList;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.If;
import org.python.pydev.parser.jython.ast.Subscript;
import org.python.pydev.parser.jython.ast.TryExcept;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.structure.FastStack;
import org.python.pydev.shared_core.structure.Tuple;

public final class Scope
implements Iterable<ScopeItems> {
    public static final int SCOPE_TYPE_GLOBAL = 1;
    public static final int SCOPE_TYPE_METHOD = 2;
    public static final int SCOPE_TYPE_CLASS = 4;
    public static final int SCOPE_TYPE_LIST_COMP = 8;
    public static final int SCOPE_TYPE_LAMBDA = 16;
    public static final int SCOPE_TYPE_ANNOTATION = 32;
    public static final int SCOPE_TYPE_ANNOTATION_STR = 64;
    public boolean isInMethodDefinition = false;
    public static final int ACCEPTED_METHOD_SCOPES = 123;
    public static final int ACCEPTED_ALL_SCOPES = 127;
    public static final int ACCEPTED_GLOBAL_CLASS_OR_METHOD_SCOPE_TYPES = 23;
    public static final int ACCEPTED_METHOD_AND_LAMBDA = 18;
    public ImportChecker importChecker;
    private FastStack<ScopeItems> scope = new FastStack(10);
    private FastStack<Integer> scopeId = new FastStack(10);
    private int scopeUnique = 0;
    private AbstractScopeAnalyzerVisitor visitor;
    private int visitingTypeAnnotation = 0;
    private int visitingStrTypeAnnotation = 0;
    public final FastStack<Subscript> subscripts = new FastStack(3);
    public int inAssignWithoutValue;

    public static String getScopeTypeStr(int scopeType) {
        switch (scopeType) {
            case 1: {
                return "Global Scope";
            }
            case 4: {
                return "Class Scope";
            }
            case 2: {
                return "Method Scope";
            }
            case 16: {
                return "Lambda Scope";
            }
            case 8: {
                return "List Comp Scope";
            }
            case 32: {
                return "Annotation Scope";
            }
            case 64: {
                return "Annotation Scope (str)";
            }
        }
        return null;
    }

    public boolean isVisitingTypeAnnotation() {
        return this.visitingTypeAnnotation > 0;
    }

    public boolean isVisitingStrTypeAnnotation() {
        return this.visitingStrTypeAnnotation > 0;
    }

    private int getNewId() {
        ++this.scopeUnique;
        return this.scopeUnique;
    }

    public Scope(AbstractScopeAnalyzerVisitor visitor, IPythonNature nature, String moduleName) {
        this.visitor = visitor;
        this.importChecker = new ImportChecker(visitor, nature, moduleName);
    }

    public void addImportTokens(TokensList list, IToken generator, ICompletionCache completionCache) {
        ScopeItems currScope = (ScopeItems)this.scope.peek();
        ScopeItems.TryExceptInfo withinExceptNode = currScope.getTryExceptImportError();
        boolean reportUndefinedImports = withinExceptNode == null;
        boolean requireTokensToBeImports = false;
        ImportChecker.ImportInfo importInfo = null;
        if (generator != null) {
            if (!generator.isImport()) {
                throw new RuntimeException("Only imports should generate multiple tokens (it may be null for imports in the form import foo.bar, but then all its tokens must be imports).");
            }
            importInfo = this.importChecker.visitImportToken(generator, reportUndefinedImports, completionCache);
        } else {
            requireTokensToBeImports = true;
        }
        for (IterTokenEntry entry : list) {
            IToken o = entry.getToken();
            Found found = this.addToken(generator, currScope, o, o.getRepresentation());
            if (withinExceptNode != null) {
                withinExceptNode.addFoundImportToTryExcept(found);
            }
            if (requireTokensToBeImports) {
                if (!o.isImport()) {
                    throw new RuntimeException("Expecting import token");
                }
                importInfo = this.importChecker.visitImportToken(o, reportUndefinedImports, completionCache);
            }
            found.importInfo = importInfo;
            this.visitor.onImportInfoSetOnFound(found);
        }
    }

    public Found addToken(IToken generator, IToken o) {
        return this.addToken(generator, o, o.getRepresentation());
    }

    public Found addToken(IToken generator, IToken o, String rep) {
        ScopeItems m = (ScopeItems)this.scope.peek();
        return this.addToken(generator, m, o, rep);
    }

    public Found addTokenToGlobalScope(IToken generator) {
        ScopeItems globalScope = this.getGlobalScope();
        return this.addToken(generator, globalScope, generator, generator.getRepresentation());
    }

    public Found addToken(IToken generator, ScopeItems m, IToken o, String rep) {
        if (generator == null) {
            generator = o;
        }
        Found found = this.findFirst(rep, false, m.isInTypeChecking(), m.getScopeType());
        boolean isReimport = false;
        if (!this.isInMethodDefinition && found != null) {
            if (found.isImport() && generator.isImport()) {
                if (!found.getSingle().inTypeChecking) {
                    isReimport = true;
                }
            } else if (!found.isUsed() && !m.getIsInStatementSubScope()) {
                if (found.getSingle().scopeFound.getScopeId() == this.getCurrScopeId() && ((found.getSingle().scopeFound.getScopeType() & 0x12) != 0 || found.isImport())) {
                    this.visitor.onAddUnusedMessage(null, found);
                }
            } else if ((m.getScopeType() & 0x12) == 0 || found.getSingle().scopeFound.getScopeType() != 4) {
                found.addGeneratorToFound(generator, o, this.getCurrScopeId(), this.getCurrScopeItems());
                return found;
            }
        }
        Found newFound = new Found(o, generator, m.getScopeId(), m);
        if (m.isInTypeChecking()) {
            newFound.setUsed(true);
        }
        if (this.inAssignWithoutValue > 0) {
            newFound.setUsed(true);
            newFound.setEphemeral(true);
        }
        if (isReimport && m.getTryExceptImportError() == null) {
            this.visitor.onAddReimportMessage(newFound);
        }
        m.put(rep, newFound);
        return newFound;
    }

    public ScopeItems getCurrScopeItems() {
        return (ScopeItems)this.scope.peek();
    }

    public void startScope(int scopeType, SimpleNode node) {
        if (scopeType == 32) {
            ++this.visitingTypeAnnotation;
        } else if (scopeType == 64) {
            ++this.visitingStrTypeAnnotation;
        }
        int newId = this.getNewId();
        int globalClassOrMethodScopeType = 0;
        if ((scopeType & 0x17) != 0) {
            globalClassOrMethodScopeType = scopeType;
        } else {
            int i = this.scope.size() - 1;
            while (i >= 0) {
                ScopeItems parent = (ScopeItems)this.scope.get(i);
                int found = parent.getScopeType();
                if ((found & 0x17) != 0) {
                    globalClassOrMethodScopeType = found;
                    break;
                }
                --i;
            }
        }
        this.scope.push((Object)new ScopeItems(newId, scopeType, globalClassOrMethodScopeType, node));
        this.scopeId.push((Object)newId);
    }

    public int getCurrScopeId() {
        return (Integer)this.scopeId.peek();
    }

    public ScopeItems endScope() {
        this.scopeId.pop();
        ScopeItems scopeItems = (ScopeItems)this.scope.pop();
        if (scopeItems.getScopeType() == 32) {
            --this.visitingTypeAnnotation;
        } else if (scopeItems.getScopeType() == 64) {
            --this.visitingStrTypeAnnotation;
        }
        return scopeItems;
    }

    public int size() {
        return this.scope.size();
    }

    public boolean find(String name, boolean setUsed) {
        return this.findInScopes(name, setUsed).size() > 0;
    }

    public List<Found> findInScopes(String name, boolean setUsed) {
        ArrayList<Found> ret = new ArrayList<Found>();
        for (ScopeItems m : this.scope) {
            Found f = m.getLastAppearance(name);
            if (f == null) continue;
            if (setUsed) {
                f.setUsed(true);
            }
            ret.add(f);
        }
        return ret;
    }

    public Found findFirst(String name, boolean setUsed, boolean inTypeChecking, int currScopeType) {
        return this.findFirst(name, setUsed, 127, inTypeChecking, currScopeType);
    }

    public boolean typeCheckingDefinitionAndUsageOk(GenAndTok definition, boolean usageTypeChecking, int currScopeType) {
        if ((currScopeType & 0x40) != 0) {
            return true;
        }
        return !definition.inTypeChecking || usageTypeChecking;
    }

    public Found findFirst(String name, boolean setUsed, int acceptedScopes, boolean inTypeChecking, int currScopeType) {
        Iterator topDown = this.scope.topDownIterator();
        while (topDown.hasNext()) {
            Found f;
            ScopeItems m = (ScopeItems)topDown.next();
            if ((m.getScopeType() & acceptedScopes) == 0 || (f = m.getLastAppearance(name)) == null || !this.typeCheckingDefinitionAndUsageOk(f.getSingle(), inTypeChecking, currScopeType)) continue;
            if (setUsed) {
                f.setUsed(true);
            }
            return f;
        }
        return null;
    }

    public void addIfSubScope(If node) {
        ((ScopeItems)this.scope.peek()).addIfSubScope(node);
    }

    public void removeIfSubScope() {
        ((ScopeItems)this.scope.peek()).removeIfSubScope();
    }

    public void addStatementSubScope() {
        ((ScopeItems)this.scope.peek()).addStatementSubScope();
    }

    public void removeStatementSubScope() {
        ((ScopeItems)this.scope.peek()).removeStatementSubScope();
    }

    public void addTryExceptSubScope(TryExcept node) {
        ((ScopeItems)this.scope.peek()).addTryExceptSubScope(node);
    }

    public void removeTryExceptSubScope() {
        ((ScopeItems)this.scope.peek()).removeTryExceptSubScope();
    }

    public ScopeItems currentScope() {
        if (this.scope.size() == 0) {
            return null;
        }
        return (ScopeItems)this.scope.peek();
    }

    public String toString() {
        FastStringBuffer buffer = new FastStringBuffer();
        buffer.append("Scope: ");
        for (ScopeItems item : this.scope) {
            buffer.append("\n");
            buffer.appendObject((Object)item);
        }
        return buffer.toString();
    }

    public ScopeItems getGlobalScope() {
        return (ScopeItems)this.scope.getFirst();
    }

    @Override
    public Iterator<ScopeItems> iterator() {
        return this.scope.iterator();
    }

    public Tuple<IToken, Found> findInNamesToIgnore(String fullRep, Map<String, Tuple<IToken, Found>> lastInStack) {
        int i = fullRep.indexOf(46, 0);
        while (i >= 0) {
            String sub = fullRep.substring(0, i);
            i = fullRep.indexOf(46, i + 1);
            if (!lastInStack.containsKey(sub)) continue;
            return lastInStack.get(sub);
        }
        return lastInStack.get(fullRep);
    }

    public Tuple<IToken, Found> findInNamesToIgnore(String rep) {
        int currScopeType = this.getCurrScopeItems().getScopeType();
        for (ScopeItems s : this.scope) {
            Map<String, Tuple<IToken, Found>> m;
            Tuple<IToken, Found> found;
            if ((currScopeType & 0x12) != 0 && s.getScopeType() == 4 || (found = this.findInNamesToIgnore(rep, m = s.namesToIgnore)) == null) continue;
            return found;
        }
        return null;
    }

    public ScopeItems getPrevScopeItems() {
        if (this.scope.size() <= 1) {
            return null;
        }
        return (ScopeItems)this.scope.get(this.scope.size() - 2);
    }

    public void pushSubscript(Subscript node) {
        this.subscripts.push((Object)node);
    }

    public void popSubscript(Subscript node) {
        this.subscripts.pop();
    }

    public boolean isInGobalScope() {
        for (ScopeItems s : this.scope) {
            if ((s.getScopeType() & 0x12) == 0) continue;
            return false;
        }
        return true;
    }
}

