/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import java.util.EnumSet;

public final class ObjectParameterType {
    final int typeInfo;
    static final ObjectParameterType INVALID = new ObjectParameterType(0);
    public static final ObjectType ARRAY;
    public static final ObjectType BUFFER;
    public static final ComponentType BYTE;
    public static final ComponentType SHORT;
    public static final ComponentType INT;
    public static final ComponentType LONG;
    public static final ComponentType FLOAT;
    public static final ComponentType DOUBLE;
    public static final ComponentType BOOLEAN;
    public static final ComponentType CHAR;

    public static ObjectParameterType create(ObjectType objectType, ComponentType componentType) {
        if (objectType == ObjectType.ARRAY) {
            return TypeCache.arrayTypeCache[componentType.ordinal()];
        }
        if (objectType == ObjectType.BUFFER) {
            return TypeCache.bufferTypeCache[componentType.ordinal()];
        }
        return new ObjectParameterType(objectType.value | componentType.value);
    }

    private ObjectParameterType(int typeInfo) {
        this.typeInfo = typeInfo;
    }

    ObjectParameterType(ObjectType objectType, ComponentType componentType) {
        this.typeInfo = objectType.value | componentType.value;
    }

    public final boolean equals(Object o) {
        return this == o || o instanceof ObjectParameterType && this.typeInfo == ((ObjectParameterType)o).typeInfo;
    }

    public final int hashCode() {
        return this.typeInfo;
    }

    static {
        new ObjectParameterType(0);
        ARRAY = ObjectType.ARRAY;
        BUFFER = ObjectType.BUFFER;
        BYTE = ComponentType.BYTE;
        SHORT = ComponentType.SHORT;
        INT = ComponentType.INT;
        LONG = ComponentType.LONG;
        FLOAT = ComponentType.FLOAT;
        DOUBLE = ComponentType.DOUBLE;
        BOOLEAN = ComponentType.BOOLEAN;
        CHAR = ComponentType.CHAR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ComponentType
    extends Enum<ComponentType> {
        public static final /* enum */ ComponentType BYTE = new ComponentType(0x1000000);
        public static final /* enum */ ComponentType SHORT = new ComponentType(0x2000000);
        public static final /* enum */ ComponentType INT = new ComponentType(0x3000000);
        public static final /* enum */ ComponentType LONG = new ComponentType(0x4000000);
        public static final /* enum */ ComponentType FLOAT = new ComponentType(0x5000000);
        public static final /* enum */ ComponentType DOUBLE = new ComponentType(0x6000000);
        public static final /* enum */ ComponentType BOOLEAN = new ComponentType(0x7000000);
        public static final /* enum */ ComponentType CHAR = new ComponentType(0x8000000);
        final int value;
        private static final /* synthetic */ ComponentType[] $VALUES;

        public static ComponentType[] values() {
            return (ComponentType[])$VALUES.clone();
        }

        private ComponentType(int type) {
            this.value = type;
        }

        static {
            $VALUES = new ComponentType[]{BYTE, SHORT, INT, LONG, FLOAT, DOUBLE, BOOLEAN, CHAR};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ObjectType
    extends Enum<ObjectType> {
        public static final /* enum */ ObjectType ARRAY = new ObjectType(0x10000000);
        public static final /* enum */ ObjectType BUFFER = new ObjectType(0x20000000);
        final int value;

        private ObjectType(int type) {
            this.value = type;
        }

        static {
            ObjectType[] objectTypeArray = new ObjectType[]{ARRAY, BUFFER};
        }
    }

    static final class TypeCache {
        static final ObjectParameterType[] arrayTypeCache;
        static final ObjectParameterType[] bufferTypeCache;

        static {
            EnumSet<ComponentType> componentTypes = EnumSet.allOf(ComponentType.class);
            arrayTypeCache = new ObjectParameterType[componentTypes.size()];
            bufferTypeCache = new ObjectParameterType[componentTypes.size()];
            for (ComponentType componentType : componentTypes) {
                TypeCache.arrayTypeCache[componentType.ordinal()] = new ObjectParameterType(ARRAY, componentType);
                TypeCache.bufferTypeCache[componentType.ordinal()] = new ObjectParameterType(BUFFER, componentType);
            }
        }
    }
}

