/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.byref;

import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.byref.AbstractNumberReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FloatByReference
extends AbstractNumberReference<Float> {
    private static final Float DEFAULT = Float.valueOf(0.0f);

    public FloatByReference() {
        super(DEFAULT);
    }

    public FloatByReference(Float value) {
        super(FloatByReference.checkNull(value));
    }

    public FloatByReference(float value) {
        super(Float.valueOf(value));
    }

    @Override
    public final void marshal(Pointer buffer, long offset) {
        buffer.putFloat(offset, ((Float)this.value).floatValue());
    }

    @Override
    public final void unmarshal(Pointer buffer, long offset) {
        this.value = Float.valueOf(buffer.getFloat(offset));
    }

    @Override
    public final int nativeSize(Runtime runtime) {
        return 4;
    }
}

