/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.analysis.messages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.python.pydev.ast.analysis.messages.IMessage;
import org.python.pydev.ast.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.ast.codecompletion.revisited.visitors.AbstractVisitor;
import org.python.pydev.core.IAnalysisPreferences;
import org.python.pydev.core.IToken;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Import;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.aliasType;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.FullRepIterable;
import org.python.pydev.shared_core.string.StringUtils;

public abstract class AbstractMessage
implements IMessage {
    public static final Map<Integer, String> messages = new HashMap<Integer, String>();
    private final int type;
    private final int severity;
    private IToken generator;
    private List<String> additionalInfo;
    private int startLine = -1;
    int startCol = -1;
    int endLine = -1;
    int endCol = -1;
    String message = null;

    public AbstractMessage(int type, IToken generator, IAnalysisPreferences prefs) {
        this.severity = prefs.getSeverityForType(type);
        this.type = type;
        this.generator = generator;
        try {
            Assert.isNotNull((Object)generator);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AbstractMessage(int type, int startLine, int endLine, int startCol, int endCol, IAnalysisPreferences prefs) {
        this.severity = prefs.getSeverityForType(type);
        this.type = type;
        Assert.isTrue((startLine >= 0 ? 1 : 0) != 0);
        Assert.isTrue((startCol >= 0 ? 1 : 0) != 0);
        this.startLine = startLine;
        this.startCol = startCol;
        this.endLine = endLine;
        this.endCol = endCol;
    }

    private String getTypeStr() {
        if (messages.size() == 0) {
            messages.put(1, "Unused import: %s");
            messages.put(8, "Unused in wild import: %s");
            messages.put(2, "Unused variable: %s");
            messages.put(10, "Unused parameter: %s");
            messages.put(3, "Undefined variable: %s");
            messages.put(4, "Duplicated signature: %s");
            messages.put(5, "Import redefinition: %s");
            messages.put(6, "Unresolved import: %s");
            messages.put(7, "Method '%s' should have %s as first parameter");
            messages.put(9, "Undefined variable from import: %s");
            messages.put(11, "Statement apppears to have no effect");
            messages.put(12, "%s");
            messages.put(14, "Assignment to reserved built-in symbol: %s");
            messages.put(15, "%s");
            messages.put(16, "%s");
            messages.put(17, "SyntaxError: %s");
            messages.put(18, "Unsupported encoding: %s");
        }
        return messages.get(this.getType());
    }

    @Override
    public int getSeverity() {
        return this.severity;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public int getStartLine(IDocument doc) {
        if (this.startLine < 0) {
            this.startLine = AbstractMessage.getStartLine(this.generator, doc);
        }
        return this.startLine;
    }

    public static int getStartLine(IToken generator, IDocument doc) {
        return AbstractMessage.getStartLine(generator, doc, generator.getRepresentation());
    }

    public static int getStartLine(IToken generator, IDocument doc, String shortMessage) {
        return AbstractMessage.getStartLine(generator, doc, shortMessage, false);
    }

    public static int getStartLine(IToken generator, IDocument doc, String shortMessage, boolean returnAsName) {
        if (!generator.isImport()) {
            return generator.getLineDefinition();
        }
        SourceToken s = (SourceToken)generator;
        SimpleNode ast = s.getAst();
        if (ast instanceof ImportFrom) {
            ImportFrom i = (ImportFrom)ast;
            if (AbstractVisitor.isWildImport(i)) {
                return i.module.beginLine;
            }
            return AbstractMessage.getNameForRepresentation((SimpleNode)i, (String)shortMessage, (boolean)returnAsName).beginLine;
        }
        if (ast instanceof Import) {
            return AbstractMessage.getNameForRepresentation((SimpleNode)ast, (String)shortMessage, (boolean)returnAsName).beginLine;
        }
        throw new RuntimeException("It is not an import");
    }

    @Override
    public int getStartCol(IDocument doc) {
        if (this.startCol >= 0) {
            return this.startCol;
        }
        this.startCol = AbstractMessage.getStartCol(this.generator, doc, this.getShortMessageStr());
        return this.startCol;
    }

    private String getShortMessageStr() {
        Object msg = this.getShortMessage();
        if (msg instanceof Object[]) {
            Object[] msgs = (Object[])msg;
            FastStringBuffer buffer = new FastStringBuffer();
            Object[] objectArray = msgs;
            int n = msgs.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                buffer.append(o.toString());
                ++n2;
            }
            return buffer.toString();
        }
        return msg.toString();
    }

    public static int getStartCol(IToken generator, IDocument doc) {
        return AbstractMessage.getStartCol(generator, doc, generator.getRepresentation());
    }

    public static int getStartCol(IToken generator, IDocument doc, String shortMessage) {
        return AbstractMessage.getStartCol(generator, doc, shortMessage, false);
    }

    public static int getStartCol(IToken generator, IDocument doc, String shortMessage, boolean returnAsName) {
        if (!generator.isImport()) {
            return generator.getColDefinition();
        }
        SourceToken s = (SourceToken)generator;
        SimpleNode ast = s.getAst();
        if (ast instanceof ImportFrom) {
            ImportFrom i = (ImportFrom)ast;
            if (AbstractVisitor.isWildImport(i)) {
                return i.module.beginColumn;
            }
            return AbstractMessage.getNameForRepresentation((SimpleNode)i, (String)shortMessage, (boolean)returnAsName).beginColumn;
        }
        if (ast instanceof Import) {
            return AbstractMessage.getNameForRepresentation((SimpleNode)ast, (String)shortMessage, (boolean)returnAsName).beginColumn;
        }
        throw new RuntimeException("It is not an import");
    }

    private static NameTok getNameForRepresentation(SimpleNode imp, String rep, boolean returnAsName) {
        aliasType[] names;
        if (imp instanceof Import) {
            names = ((Import)imp).names;
        } else if (imp instanceof ImportFrom) {
            names = ((ImportFrom)imp).names;
        } else {
            throw new RuntimeException("import expected");
        }
        aliasType[] aliasTypeArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            aliasType alias = aliasTypeArray[n2];
            if (alias.asname != null) {
                if (((NameTok)alias.asname).id.equals(rep)) {
                    if (returnAsName) {
                        return (NameTok)alias.asname;
                    }
                    return (NameTok)alias.name;
                }
            } else {
                String fullRepNameId = ((NameTok)alias.name).id;
                for (String repId : new FullRepIterable(fullRepNameId)) {
                    if (!repId.equals(rep)) continue;
                    return (NameTok)alias.name;
                }
            }
            ++n2;
        }
        return null;
    }

    @Override
    public int getEndLine(IDocument doc) {
        return this.getEndLine(doc, true);
    }

    public int getEndLine(IDocument doc, boolean getOnlyToFirstDot) {
        if (this.endLine < 0) {
            this.endLine = AbstractMessage.getEndLine(this.generator, doc, getOnlyToFirstDot);
        }
        return this.endLine;
    }

    public static int getEndLine(IToken generator, IDocument doc, boolean getOnlyToFirstDot) {
        if (generator instanceof SourceToken) {
            if (!generator.isImport()) {
                return ((SourceToken)generator).getLineEnd(getOnlyToFirstDot);
            }
            return AbstractMessage.getStartLine(generator, doc);
        }
        return -1;
    }

    @Override
    public int getEndCol(IDocument doc) {
        return this.getEndCol(doc, true);
    }

    public int getEndCol(IDocument doc, boolean getOnlyToFirstDot) {
        if (this.endCol >= 0) {
            return this.endCol;
        }
        this.endCol = AbstractMessage.getEndCol(this.generator, doc, this.getShortMessageStr(), getOnlyToFirstDot);
        return this.endCol;
    }

    public static int getEndCol(IToken generator, IDocument doc, String shortMessage, boolean getOnlyToFirstDot) {
        int endCol = -1;
        if (generator.isImport()) {
            SourceToken s = (SourceToken)generator;
            SimpleNode ast = s.getAst();
            if (ast instanceof ImportFrom) {
                ImportFrom i = (ImportFrom)ast;
                NameTok it = AbstractMessage.getNameForRepresentation((SimpleNode)i, shortMessage, true);
                if (it != null) {
                    endCol = it.beginColumn + shortMessage.length();
                    return endCol;
                }
                try {
                    IRegion lineInformation = doc.getLineInformation(i.module.beginLine - 1);
                    int absolute = lineInformation.getOffset() + i.module.beginColumn - 1;
                    while (doc.getChar(absolute) != '*') {
                        ++absolute;
                    }
                    int absoluteCol = absolute + 1;
                    IRegion region = doc.getLineInformationOfOffset(absoluteCol);
                    endCol = absoluteCol - region.getOffset() + 1;
                    return endCol;
                }
                catch (BadLocationException e) {
                    throw new RuntimeException(e);
                }
            }
            if (ast instanceof Import) {
                NameTok it = AbstractMessage.getNameForRepresentation(ast, shortMessage, true);
                endCol = it.beginColumn + shortMessage.length();
                return endCol;
            }
            throw new RuntimeException("It is not an import");
        }
        if (generator instanceof SourceToken) {
            return ((SourceToken)generator).getColEnd(getOnlyToFirstDot);
        }
        return -1;
    }

    public String toString() {
        return this.getMessage();
    }

    @Override
    public List<String> getAdditionalInfo() {
        return this.additionalInfo;
    }

    @Override
    public void addAdditionalInfo(String info) {
        if (this.additionalInfo == null) {
            this.additionalInfo = new ArrayList<String>();
        }
        this.additionalInfo.add(info);
    }

    @Override
    public String getMessage() {
        if (this.message != null) {
            return this.message;
        }
        String typeStr = this.getTypeStr();
        if (typeStr == null) {
            throw new AssertionError((Object)("Unable to get message for type: " + this.getType()));
        }
        Object shortMessage = this.getShortMessage();
        if (shortMessage == null) {
            throw new AssertionError((Object)("Unable to get shortMessage (" + typeStr + ")"));
        }
        if (shortMessage instanceof Object[]) {
            Object[] o = (Object[])shortMessage;
            int countPercS = StringUtils.countPercS((String)typeStr);
            if (countPercS == o.length) {
                return StringUtils.format((String)typeStr, (Object[])o);
            }
            if (countPercS == 1) {
                FastStringBuffer buf = new FastStringBuffer();
                int i = 0;
                while (i < o.length) {
                    buf.append(o[i].toString());
                    if (i != o.length - 1) {
                        buf.append(" ");
                    }
                    ++i;
                }
                shortMessage = buf.toString();
            } else {
                throw new AssertionError((Object)"The number of %s is not the number of passed parameters nor 1");
            }
        }
        this.message = StringUtils.format((String)typeStr, (Object[])new Object[]{shortMessage});
        return this.message;
    }

    @Override
    public IToken getGenerator() {
        return this.generator;
    }
}

