/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.builder;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.ast.builder.PyDevBuilder;
import org.python.pydev.ast.builder.PyDevBuilderVisitor;
import org.python.pydev.ast.builder.PydevInternalResourceDeltaVisitor;
import org.python.pydev.ast.builder.VisitorMemo;
import org.python.pydev.core.FileUtilsFileBuffer;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.callbacks.ICallback0;
import org.python.pydev.shared_core.string.FastStringBuffer;

public class PydevGrouperVisitor
extends PydevInternalResourceDeltaVisitor {
    private final List<PyDevBuilderVisitor> visitors;
    private final int totalResources;
    private int currentResourcesVisited = 0;
    private final List<IResourceDelta> delayedVisits;
    private final int VISIT_ADD = 1;
    private final int VISIT_CHANGE = 2;
    private final int VISIT_REMOVE = 3;

    public PydevGrouperVisitor(List<PyDevBuilderVisitor> _visitors, IProgressMonitor monitor, int totalResources) {
        super(monitor);
        this.monitor = monitor;
        this.totalResources = totalResources;
        this.delayedVisits = new ArrayList<IResourceDelta>();
        this.visitors = new ArrayList<PyDevBuilderVisitor>(_visitors);
    }

    private void visitWith(int visitType, IResource resource, ICallback0<IDocument> document, IProgressMonitor monitor) {
        block18: {
            if (monitor.isCanceled()) {
                return;
            }
            PythonNature nature = PythonNature.getPythonNature(resource);
            if (nature == null) {
                return;
            }
            if (!nature.startRequests()) {
                return;
            }
            nature.updateMtime();
            try {
                if (!this.isResourceInPythonpathProjectSources(resource, nature, true)) {
                    return;
                }
            }
            catch (Exception e1) {
                Log.log((Throwable)e1);
                return;
            }
            {
                VisitorMemo copyMemo = new VisitorMemo(this.memo);
                FastStringBuffer bufferToCommunicateProgress = new FastStringBuffer();
                block13: for (PyDevBuilderVisitor visitor : this.visitors) {
                    if (visitor.maxResourcesToVisit() != -1 && visitor.maxResourcesToVisit() < this.totalResources) continue;
                    visitor.memo = copyMemo;
                    try {
                        PyDevBuilder.communicateProgress(monitor, this.totalResources, this.currentResourcesVisited, resource, visitor, bufferToCommunicateProgress);
                        switch (visitType) {
                            case 1: {
                                visitor.visitAddedResource(resource, document, monitor);
                                continue block13;
                            }
                            case 2: {
                                visitor.visitChangedResource(resource, document, monitor);
                                continue block13;
                            }
                            case 3: {
                                visitor.visitRemovedResource(resource, document, monitor);
                                continue block13;
                            }
                            default: {
                                throw new RuntimeException("Error: visit type not properly given!");
                            }
                        }
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                    }
                }
                break block18;
            }
            finally {
                nature.endRequests();
            }
        }
    }

    @Override
    protected void onVisitDelta(IResourceDelta delta) {
        switch (delta.getKind()) {
            case 1: 
            case 4: {
                this.delayedVisits.add(delta);
                break;
            }
            case 2: {
                IResource resource = delta.getResource();
                this.memo.put("DOCUMENT_TIME", System.currentTimeMillis());
                this.visitRemovedResource(resource, null, this.monitor);
            }
        }
    }

    @Override
    public void visitAddedResource(IResource resource, ICallback0<IDocument> document, IProgressMonitor monitor) {
        this.visitWith(1, resource, document, monitor);
    }

    @Override
    public void visitChangedResource(IResource resource, ICallback0<IDocument> document, IProgressMonitor monitor) {
        this.visitWith(2, resource, document, monitor);
    }

    @Override
    public void visitRemovedResource(IResource resource, ICallback0<IDocument> document, IProgressMonitor monitor) {
        this.visitWith(3, resource, document, monitor);
    }

    public void finishDelayedVisits() {
        for (IResourceDelta delta : this.delayedVisits) {
            try {
                IResource resource = delta.getResource();
                boolean isAddRemove = false;
                switch (delta.getKind()) {
                    case 1: {
                        this.memo.put("DOCUMENT_TIME", System.currentTimeMillis());
                        this.visitAddedResource(resource, (ICallback0<IDocument>)FileUtilsFileBuffer.getDocOnCallbackFromResource((IResource)resource), this.monitor);
                        isAddRemove = true;
                        break;
                    }
                    case 4: {
                        this.memo.put("DOCUMENT_TIME", System.currentTimeMillis());
                        this.visitChangedResource(resource, (ICallback0<IDocument>)FileUtilsFileBuffer.getDocOnCallbackFromResource((IResource)resource), this.monitor);
                        isAddRemove = true;
                    }
                }
                if (!isAddRemove) continue;
                ++this.currentResourcesVisited;
                FastStringBuffer bufferToCreateString = new FastStringBuffer();
                PyDevBuilder.communicateProgress(this.monitor, this.totalResources, this.currentResourcesVisited, resource, this, bufferToCreateString);
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
    }
}

