/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.codecompletion;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.python.pydev.core.preferences.PydevPrefs;
import org.python.pydev.shared_core.string.StringUtils;

public class PriorityLRU {
    private static LinkedHashSet<String> lru;
    private static Map<String, Integer> priorityMap;
    private static final String COMPLETIONS_PRIORITY_LRU = "COMPLETIONS_PRIORITY_LRU";
    private static final int MAX_SIZE = 100;

    public static Integer getPriority(String realImportRep) {
        if (priorityMap == null) {
            PriorityLRU.loadLRU();
            PriorityLRU.updatePriorityMapFromLRU();
        }
        if (priorityMap == null) {
            return null;
        }
        return priorityMap.get(realImportRep);
    }

    private static void loadLRU() {
        IEclipsePreferences eclipsePreferences = PydevPrefs.getEclipsePreferences();
        if (eclipsePreferences == null) {
            return;
        }
        String string = eclipsePreferences.get(COMPLETIONS_PRIORITY_LRU, "");
        List split = StringUtils.split((String)string, (char)'|');
        LinkedHashSet<String> temp = new LinkedHashSet<String>(100);
        temp.addAll(split);
        PriorityLRU.shrinkLRU(temp);
        lru = temp;
    }

    private static void updatePriorityMapFromLRU() {
        if (lru == null) {
            return;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>(lru.size());
        int i = -101;
        for (String s : lru) {
            map.put(s, --i);
        }
        priorityMap = map;
    }

    public static void appliedCompletion(String realImportRep) {
        IEclipsePreferences eclipsePreferences = PydevPrefs.getEclipsePreferences();
        if (eclipsePreferences == null) {
            return;
        }
        if (lru == null) {
            PriorityLRU.loadLRU();
        } else {
            lru.remove(realImportRep);
            lru.add(realImportRep);
            PriorityLRU.shrinkLRU(lru);
        }
        PriorityLRU.updatePriorityMapFromLRU();
        eclipsePreferences.put(COMPLETIONS_PRIORITY_LRU, StringUtils.join((String)"|", lru));
    }

    private static void shrinkLRU(LinkedHashSet<String> lru) {
        if (lru.size() > 100) {
            Iterator iterator = lru.iterator();
            while (lru.size() > 100) {
                iterator.next();
                iterator.remove();
            }
        }
    }
}

