/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.codecompletion;

import java.util.Comparator;
import org.eclipse.core.resources.IProject;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.shared_core.code_completion.ICompletionProposalHandle;
import org.python.pydev.shared_core.code_completion.IPyCompletionProposal;

public final class ProposalsComparator
implements Comparator<ICompletionProposalHandle> {
    private String qualifier;
    private String qualifierLower;
    private IPyCompletionProposal.ICompareContext compareContext;
    private boolean qualifierHasUpper;

    public ProposalsComparator(String qualifier, IPyCompletionProposal.ICompareContext compareContext) {
        this.compareContext = compareContext;
        this.setQualifier(qualifier);
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
        this.qualifierLower = qualifier.toLowerCase();
        this.qualifierHasUpper = this.qualifierLower.equals(this.qualifier);
    }

    public void setCompareContext(CompareContext compareContext) {
        this.compareContext = compareContext;
    }

    public int compare(String o1Str, String o2Str, int priority1, int priority2, IPyCompletionProposal.ICompareContext ctx1, IPyCompletionProposal.ICompareContext ctx2) {
        int ctx2Priority;
        int v;
        String o1StrOriginal = o1Str;
        String o2StrOriginal = o2Str;
        int o1Len = o1Str.length();
        int o2Len = o2Str.length();
        int iSplit1 = o1Str.indexOf(40, 0);
        int iSplit2 = o2Str.indexOf(40, 0);
        int iSpace1 = o1Str.indexOf(32, 0);
        int iSpace2 = o2Str.indexOf(32, 0);
        if (iSplit1 == -1 || iSpace1 >= 0 && iSpace1 < iSplit1) {
            iSplit1 = iSpace1;
        }
        if (iSplit2 == -1 || iSpace2 >= 0 && iSpace2 < iSplit2) {
            iSplit2 = iSpace2;
        }
        if (iSplit1 >= 0) {
            o1Str = o1Str.substring(0, iSplit1);
            o1Len = o1Str.length();
        }
        if (iSplit2 >= 0) {
            o2Str = o2Str.substring(0, iSplit2);
            o2Len = o2Str.length();
        }
        if ((v = this.onlyStringCompare(o1Str, o2Str)) != 0) {
            return v;
        }
        if (priority1 < priority2) {
            return -1;
        }
        if (priority1 > priority2) {
            return 1;
        }
        int ctx1Priority = ctx1 != null ? ctx1.getPriorityRelatedTo(this.compareContext) : 3;
        int n = ctx2Priority = ctx2 != null ? ctx2.getPriorityRelatedTo(this.compareContext) : 3;
        if (ctx1Priority != ctx2Priority) {
            if (ctx1Priority < ctx2Priority) {
                return -1;
            }
            return 1;
        }
        boolean o1StartsWithUnder = false;
        boolean o2StartsWithUnder = false;
        try {
            o1StartsWithUnder = o1Str.charAt(0) == '_';
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            o2StartsWithUnder = o2Str.charAt(0) == '_';
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (o1StartsWithUnder != o2StartsWithUnder) {
            if (o1StartsWithUnder) {
                return 1;
            }
            return -1;
        }
        if (o1StartsWithUnder) {
            o1StartsWithUnder = o1Len > 1 ? o1Str.charAt(1) == '_' : false;
            if (o1StartsWithUnder != (o2StartsWithUnder = o2Len > 1 ? o2Str.charAt(1) == '_' : false)) {
                if (o1StartsWithUnder) {
                    return 1;
                }
                return -1;
            }
            boolean o1EndsWithUnder = false;
            boolean o2EndsWithUnder = false;
            if (o1Len > 2) {
                boolean bl = o1EndsWithUnder = o1Str.charAt(o1Len - 1) == '_';
            }
            if (o2Len > 2) {
                boolean bl = o2EndsWithUnder = o2Str.charAt(o2Len - 1) == '_';
            }
            if (o1EndsWithUnder != o2EndsWithUnder) {
                if (o1EndsWithUnder) {
                    return 1;
                }
                return -1;
            }
        }
        return o1StrOriginal.compareToIgnoreCase(o2StrOriginal);
    }

    private int onlyStringCompare(String o1Str, String o2Str) {
        if (this.qualifierHasUpper) {
            if (o1Str.equals(this.qualifier) && !o2Str.equals(this.qualifier)) {
                return -1;
            }
            if (o2Str.equals(this.qualifier) && !o1Str.equals(this.qualifier)) {
                return 1;
            }
        }
        if (o1Str.equalsIgnoreCase(this.qualifier) && !o2Str.equalsIgnoreCase(this.qualifier)) {
            return -1;
        }
        if (o2Str.equalsIgnoreCase(this.qualifier) && !o1Str.equalsIgnoreCase(this.qualifier)) {
            return 1;
        }
        if (this.qualifierHasUpper) {
            if (o1Str.startsWith(this.qualifier) && !o2Str.startsWith(this.qualifier)) {
                return -1;
            }
            if (o2Str.startsWith(this.qualifier) && !o1Str.startsWith(this.qualifier)) {
                return 1;
            }
        }
        if (o1Str.toLowerCase().startsWith(this.qualifierLower) && !o2Str.toLowerCase().startsWith(this.qualifierLower)) {
            return -1;
        }
        if (o2Str.toLowerCase().startsWith(this.qualifierLower) && !o1Str.toLowerCase().startsWith(this.qualifierLower)) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compare(ICompletionProposalHandle o1, ICompletionProposalHandle o2) {
        IPyCompletionProposal.ICompareContext ctx2;
        int p2;
        IPyCompletionProposal.ICompareContext ctx1;
        int p1;
        IPyCompletionProposal iPyCompletionProposal;
        String o1Str = o1.getDisplayString();
        String o2Str = o2.getDisplayString();
        if (o1 instanceof IPyCompletionProposal) {
            iPyCompletionProposal = (IPyCompletionProposal)o1;
            p1 = iPyCompletionProposal.getPriority();
            ctx1 = iPyCompletionProposal.getCompareContext();
        } else {
            p1 = 10;
            ctx1 = null;
        }
        if (o2 instanceof IPyCompletionProposal) {
            iPyCompletionProposal = (IPyCompletionProposal)o2;
            p2 = iPyCompletionProposal.getPriority();
            ctx2 = iPyCompletionProposal.getCompareContext();
        } else {
            p2 = 10;
            ctx2 = null;
        }
        int ret = this.compare(o1Str, o2Str, p1, p2, ctx1, ctx2);
        return ret;
    }

    public static class CompareContext
    implements IPyCompletionProposal.ICompareContext {
        private IProject project;

        public CompareContext(IToken token) {
            this(token.getNature());
        }

        public CompareContext(IPythonNature nature) {
            this(nature != null ? nature.getProject() : null);
        }

        public CompareContext(IProject project) {
            this.project = project;
        }

        public CompareContext(IPyEdit edit) {
            this(edit == null ? null : edit.getProject());
        }

        public int getPriorityRelatedTo(IPyCompletionProposal.ICompareContext compareContext) {
            if (compareContext instanceof CompareContext) {
                CompareContext compareContext2 = (CompareContext)compareContext;
                if (compareContext2.project != null && this.project != null && compareContext2.project.equals((Object)this.project)) {
                    return 1;
                }
            }
            if (this.project != null) {
                return 2;
            }
            return 3;
        }

        public String toString() {
            return "CompareContext[" + (this.project != null ? this.project.getName() : "null") + "]";
        }
    }
}

