/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.codecompletion.revisited;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.python.pydev.ast.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.core.FileUtilsFileBuffer;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.IModule;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.log.Log;
import org.python.pydev.shared_core.cache.LRUMap;
import org.python.pydev.shared_core.string.FullRepIterable;

public class CachePyiModules {
    private final Object cachePyiModulesLock = new Object();
    private final Map<File, CacheValue> cache = new LRUMap(50);
    private static final IGrammarVersionProvider LATEST_PY3_GRAMMAR_VERSION_PROVIDER = new IGrammarVersionProvider(){

        public int getGrammarVersion() throws MisconfigurationException {
            return 107;
        }

        public IGrammarVersionProvider.AdditionalGrammarVersionsToCheck getAdditionalGrammarVersions() throws MisconfigurationException {
            return null;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.cachePyiModulesLock;
        synchronized (object) {
            this.cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceModule getPyiStubModule(IModule module) {
        File file = module.getFile();
        if (file != null) {
            CacheValue cacheValue;
            File parentFile = file.getParentFile();
            String definitionFileName = file.getName();
            File pyInterfaceFile = new File(parentFile, FullRepIterable.getWithoutLastPart((String)definitionFileName) + ".pyi");
            Object object = this.cachePyiModulesLock;
            synchronized (object) {
                cacheValue = this.cache.get(pyInterfaceFile);
            }
            if (cacheValue != null && cacheValue.isValid()) {
                return cacheValue.get();
            }
            if (pyInterfaceFile.exists()) {
                try {
                    long lastModified = pyInterfaceFile.lastModified();
                    SourceModule ret = SourceModule.createModuleFromDoc(module.getName(), pyInterfaceFile, FileUtilsFileBuffer.getDocFromFile((File)pyInterfaceFile), module.getNature(), false, LATEST_PY3_GRAMMAR_VERSION_PROVIDER);
                    Object object2 = this.cachePyiModulesLock;
                    synchronized (object2) {
                        this.cache.put(pyInterfaceFile, new CacheValue(pyInterfaceFile, lastModified, ret));
                    }
                    return ret;
                }
                catch (IOException | MisconfigurationException e) {
                    Log.log((Throwable)e);
                }
            }
        }
        return null;
    }

    private static class CacheValue {
        private File pyInterfaceFile;
        private long lastModified;
        private SourceModule sourceModule;

        public CacheValue(File pyInterfaceFile, long lastModified, SourceModule ret) {
            this.pyInterfaceFile = pyInterfaceFile;
            this.lastModified = lastModified;
            this.sourceModule = ret;
        }

        public SourceModule get() {
            return this.sourceModule;
        }

        public boolean isValid() {
            return this.pyInterfaceFile.lastModified() == this.lastModified;
        }
    }
}

