/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.codecompletion.revisited;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.python.pydev.ast.codecompletion.revisited.ModulesManager;
import org.python.pydev.ast.codecompletion.revisited.ModulesManagerWithBuild;
import org.python.pydev.ast.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.core.DeltaSaver;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.IDeltaProcessor;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModuleRequestState;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IProjectModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.core.ISystemModulesManager;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.structure.Tuple;

public final class ProjectModulesManager
extends ModulesManagerWithBuild
implements IProjectModulesManager {
    private static final boolean DEBUG_MODULES = false;
    private volatile IProject project;
    private volatile IPythonNature nature;
    public static ICallback<IModulesManager, IProject> createJavaProjectModulesManagerIfPossible;
    private volatile long checkedPythonpathConsistency = 0L;

    public void setProject(IProject project, IPythonNature nature, boolean restoreDeltas) {
        this.project = project;
        this.nature = nature;
        File completionsCacheDir = this.nature.getCompletionsCacheDir();
        if (completionsCacheDir == null) {
            return;
        }
        DeltaSaver d = this.deltaSaver = new DeltaSaver(completionsCacheDir, "v1_astdelta", readFromFileMethod, toFileMethod);
        if (!restoreDeltas) {
            d.clearAll();
        } else {
            d.processDeltas((IDeltaProcessor)this);
        }
    }

    public void endProcessing() {
        this.nature.saveAstManager();
    }

    public void setPythonNature(IPythonNature nature) {
        this.nature = nature;
    }

    public IPythonNature getNature() {
        return this.nature;
    }

    public ISystemModulesManager getSystemModulesManager() {
        if (this.nature == null) {
            Log.log((String)"Nature still not set");
            return null;
        }
        try {
            return this.nature.getProjectInterpreter().getModulesManager();
        }
        catch (Exception e1) {
            return null;
        }
    }

    @Override
    public Set<String> getAllModuleNames(boolean addDependencies, String partStartingWithLowerCase) {
        if (addDependencies) {
            HashSet<String> s = new HashSet<String>();
            IModulesManager[] managersInvolved = this.getManagersInvolved(true);
            int i = 0;
            while (i < managersInvolved.length) {
                s.addAll(managersInvolved[i].getAllModuleNames(false, partStartingWithLowerCase));
                ++i;
            }
            return s;
        }
        return super.getAllModuleNames(addDependencies, partStartingWithLowerCase);
    }

    @Override
    public SortedMap<ModulesKey, ModulesKey> getAllModulesStartingWith(String strStartingWith) {
        TreeMap<ModulesKey, ModulesKey> ret = new TreeMap<ModulesKey, ModulesKey>();
        IModulesManager[] managersInvolved = this.getManagersInvolved(true);
        int i = 0;
        while (i < managersInvolved.length) {
            ret.putAll(managersInvolved[i].getAllDirectModulesStartingWith(strStartingWith));
            ++i;
        }
        return ret;
    }

    @Override
    public IModule getModule(String name, IPythonNature nature, boolean dontSearchInit, IModuleRequestState moduleRequest) {
        return this.getModule(name, nature, true, dontSearchInit, moduleRequest);
    }

    public IModule getRelativeModule(String name, IPythonNature nature, IModuleRequestState moduleRequest) {
        return super.getModule(false, name, nature, true, moduleRequest);
    }

    public IModule getModule(String name, IPythonNature nature, boolean checkSystemManager, boolean dontSearchInit, IModuleRequestState moduleRequest) {
        Tuple<IModule, IModulesManager> ret = this.getModuleAndRelatedModulesManager(name, nature, checkSystemManager, dontSearchInit, moduleRequest);
        if (ret != null) {
            return (IModule)ret.o1;
        }
        return null;
    }

    public Tuple<IModule, IModulesManager> getModuleAndRelatedModulesManager(String name, IPythonNature nature, boolean checkSystemManager, boolean dontSearchInit, IModuleRequestState moduleRequest) {
        IModulesManager m;
        IModulesManager[] managersInvolved;
        IModule module = null;
        IModulesManager[] iModulesManagerArray = managersInvolved = this.getManagersInvolved(true);
        int n = managersInvolved.length;
        int n2 = 0;
        while (n2 < n) {
            m = iModulesManagerArray[n2];
            if (m instanceof ISystemModulesManager && (module = ((ISystemModulesManager)m).getBuiltinModule(name, dontSearchInit, moduleRequest)) != null) {
                return new Tuple((Object)module, (Object)m);
            }
            ++n2;
        }
        iModulesManagerArray = managersInvolved;
        n = managersInvolved.length;
        n2 = 0;
        while (n2 < n) {
            m = iModulesManagerArray[n2];
            if (m instanceof IProjectModulesManager) {
                IProjectModulesManager pM = (IProjectModulesManager)m;
                module = pM.getModuleInDirectManager(name, nature, dontSearchInit, moduleRequest);
            } else if (m instanceof ISystemModulesManager) {
                ISystemModulesManager systemModulesManager = (ISystemModulesManager)m;
                module = systemModulesManager.getModuleWithoutBuiltins(name, nature, dontSearchInit, moduleRequest);
            } else {
                throw new RuntimeException("Unexpected: " + String.valueOf(m));
            }
            if (module != null) {
                return new Tuple((Object)module, (Object)m);
            }
            ++n2;
        }
        return null;
    }

    public IModule getModuleInDirectManager(String name, IPythonNature nature, boolean dontSearchInit, IModuleRequestState moduleRequest) {
        return super.getModule(name, nature, dontSearchInit, moduleRequest);
    }

    @Override
    protected String getResolveModuleErr(IResource member) {
        return "Unable to find the path " + String.valueOf(member) + " in the project were it\nis added as a source folder for pydev (project: " + this.project.getName() + ")";
    }

    public String resolveModuleOnlyInProjectSources(String fileAbsolutePath, boolean addExternal) throws CoreException {
        List pathItems = this.nature.getPythonPathNature().getOnlyProjectPythonPathStr(addExternal, true);
        List<String> filteredPathItems = this.filterDuplicatesPreservingOrder(pathItems);
        return this.pythonPathHelper.resolveModule(fileAbsolutePath, false, filteredPathItems, this.project);
    }

    private List<String> filterDuplicatesPreservingOrder(List<String> pathItems) {
        return new ArrayList<String>(new LinkedHashSet<String>(pathItems));
    }

    @Override
    public String resolveModule(String full) {
        return this.resolveModule(full, true);
    }

    public String resolveModule(String full, boolean checkSystemManager) {
        IModulesManager[] managersInvolved;
        IModulesManager[] iModulesManagerArray = managersInvolved = this.getManagersInvolved(checkSystemManager);
        int n = managersInvolved.length;
        int n2 = 0;
        while (n2 < n) {
            String mod;
            IModulesManager m = iModulesManagerArray[n2];
            if (m instanceof IProjectModulesManager) {
                IProjectModulesManager pM = (IProjectModulesManager)m;
                mod = pM.resolveModuleInDirectManager(full);
            } else {
                mod = m.resolveModule(full);
            }
            if (mod != null) {
                return mod;
            }
            ++n2;
        }
        return null;
    }

    public String resolveModuleInDirectManager(String full) {
        if (this.nature != null) {
            return this.pythonPathHelper.resolveModule(full, false, this.nature.getProject());
        }
        return super.resolveModule(full);
    }

    public String resolveModuleInDirectManager(IFile member) {
        File inOs = member.getLocation().toFile();
        return this.resolveModuleInDirectManager(FileUtils.getFileAbsolutePath((File)inOs));
    }

    @Override
    public int getSize(boolean addDependenciesSize) {
        if (addDependenciesSize) {
            int size = 0;
            IModulesManager[] managersInvolved = this.getManagersInvolved(true);
            int i = 0;
            while (i < managersInvolved.length) {
                size += managersInvolved[i].getSize(false);
                ++i;
            }
            return size;
        }
        return super.getSize(addDependenciesSize);
    }

    public String[] getBuiltins() {
        String[] builtins = null;
        ISystemModulesManager systemModulesManager = this.getSystemModulesManager();
        if (systemModulesManager != null) {
            builtins = systemModulesManager.getBuiltins();
        }
        return builtins;
    }

    private synchronized IModulesManager[] getManagers(boolean checkSystemManager, boolean referenced) {
        IModulesManager javaModulesManagerForProject;
        IModulesManager[] ret;
        ModulesManager.CompletionCache localCompletionCache = this.completionCache;
        if (localCompletionCache != null && (ret = localCompletionCache.getManagers(referenced, checkSystemManager)) != null) {
            return ret;
        }
        ArrayList<IModulesManager> list = new ArrayList<IModulesManager>();
        ISystemModulesManager systemModulesManager = this.getSystemModulesManager();
        list.add(this);
        if (this.project != null && createJavaProjectModulesManagerIfPossible != null && (javaModulesManagerForProject = (IModulesManager)createJavaProjectModulesManagerIfPossible.call((Object)this.project)) != null) {
            list.add(javaModulesManagerForProject);
        }
        Set<IProject> projs = referenced ? ProjectModulesManager.getReferencedProjects(this.project) : ProjectModulesManager.getReferencingProjects(this.project);
        this.addModuleManagers(list, projs);
        if (checkSystemManager && systemModulesManager != null) {
            list.add((IModulesManager)systemModulesManager);
        }
        IModulesManager[] ret2 = list.toArray(new IModulesManager[list.size()]);
        if (localCompletionCache != null) {
            localCompletionCache.setManagers(ret2, referenced, checkSystemManager);
        }
        return ret2;
    }

    public static Set<IProject> getReferencingProjects(IProject project) {
        HashSet<IProject> memo = new HashSet<IProject>();
        ProjectModulesManager.getProjectsRecursively(project, false, memo);
        memo.remove(project);
        return memo;
    }

    public static Set<IProject> getReferencedProjects(IProject project) {
        HashSet<IProject> memo = new HashSet<IProject>();
        ProjectModulesManager.getProjectsRecursively(project, true, memo);
        memo.remove(project);
        return memo;
    }

    private static void getProjectsRecursively(IProject project, boolean referenced, HashSet<IProject> memo) {
        IProject[] projects = null;
        try {
            if (project == null || !project.isOpen() || !project.exists()) {
                return;
            }
            projects = referenced ? project.getReferencedProjects() : project.getReferencingProjects();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (projects != null) {
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject p = iProjectArray[n2];
                if (!memo.contains(p)) {
                    memo.add(p);
                    ProjectModulesManager.getProjectsRecursively(p, referenced, memo);
                }
                ++n2;
            }
        }
    }

    private void addModuleManagers(ArrayList<IModulesManager> list, Collection<IProject> projects) {
        for (IProject project : projects) {
            IModulesManager javaModulesManagerForProject;
            IModulesManager projectModulesManager;
            ICodeCompletionASTManager otherProjectAstManager;
            PythonNature nature = PythonNature.getPythonNature(project);
            if (nature != null && (otherProjectAstManager = nature.getAstManager()) != null && (projectModulesManager = otherProjectAstManager.getModulesManager()) != null) {
                list.add(projectModulesManager);
            }
            if (createJavaProjectModulesManagerIfPossible == null || (javaModulesManagerForProject = (IModulesManager)createJavaProjectModulesManagerIfPossible.call((Object)project)) == null) continue;
            list.add(javaModulesManagerForProject);
        }
    }

    public IModulesManager[] getManagersInvolved(boolean checkSystemManager) {
        return this.getManagers(checkSystemManager, true);
    }

    public IModulesManager[] getRefencingManagersInvolved(boolean checkSystemManager) {
        return this.getManagers(checkSystemManager, false);
    }

    public List<String> getCompletePythonPath(IInterpreterInfo interpreter, IInterpreterManager manager) {
        IModulesManager[] managersInvolved;
        ArrayList<String> l = new ArrayList<String>();
        IModulesManager[] iModulesManagerArray = managersInvolved = this.getManagersInvolved(true);
        int n = managersInvolved.length;
        int n2 = 0;
        while (n2 < n) {
            IModulesManager m = iModulesManagerArray[n2];
            if (m instanceof ISystemModulesManager) {
                ISystemModulesManager systemModulesManager = (ISystemModulesManager)m;
                l.addAll(systemModulesManager.getCompletePythonPath(interpreter, manager));
            } else {
                PythonPathHelper h = (PythonPathHelper)m.getPythonPathHelper();
                if (h != null) {
                    List<String> pythonpath = h.getPythonpath();
                    boolean forceCheck = false;
                    ProjectModulesManager m2 = null;
                    IPythonPathNature pythonPathNature = null;
                    if (m instanceof ProjectModulesManager) {
                        long currentTimeMillis = System.currentTimeMillis();
                        m2 = (ProjectModulesManager)m;
                        if (pythonpath.size() == 0 || currentTimeMillis - m2.checkedPythonpathConsistency > 20000L) {
                            try {
                                IPythonNature n3 = m.getNature();
                                if (n3 != null && (pythonPathNature = n3.getPythonPathNature()) != null) {
                                    m2.checkedPythonpathConsistency = currentTimeMillis;
                                    forceCheck = true;
                                }
                            }
                            catch (Exception e) {
                                Log.log((Throwable)e);
                            }
                        }
                    }
                    if (forceCheck) {
                        try {
                            List parsed = pythonPathNature.getOnlyProjectPythonPathStr(true, true);
                            if (m2.nature != null && !new HashSet(parsed).equals(new HashSet<String>(pythonpath))) {
                                h.setPythonPath(parsed);
                                m2.nature.rebuildPath();
                            }
                            l.addAll(parsed);
                        }
                        catch (Exception e) {
                            Log.log((Throwable)e);
                        }
                    } else {
                        l.addAll(pythonpath);
                    }
                }
            }
            ++n2;
        }
        return l;
    }
}

