/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.codecompletion.revisited;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.ast.builder.PyDevBuilderVisitor;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.callbacks.ICallback0;

public class PyCodeCompletionVisitor
extends PyDevBuilderVisitor {
    public static final int PRIORITY_CODE_COMPLETION = 5;
    private AutoCloseable noGenerateDeltas;

    @Override
    protected int getPriority() {
        return 5;
    }

    @Override
    public void visitingWillStart(IProgressMonitor monitor, boolean isFullBuild, IPythonNature nature) {
        ICodeCompletionASTManager astManager;
        if (isFullBuild && (astManager = nature.getAstManager()) != null) {
            IModulesManager modulesManager = astManager.getModulesManager();
            this.noGenerateDeltas = modulesManager.withNoGenerateDeltas();
        }
    }

    @Override
    public void visitingEnded(IProgressMonitor monitor) {
        if (this.noGenerateDeltas != null) {
            try {
                this.noGenerateDeltas.close();
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
    }

    @Override
    public void visitChangedResource(IResource resource, ICallback0<IDocument> document, IProgressMonitor monitor) {
        ICodeCompletionASTManager astManager;
        PythonNature pythonNature = this.getPythonNature(resource);
        if (pythonNature != null && (astManager = pythonNature.getAstManager()) != null) {
            IPath location = resource.getLocation();
            astManager.rebuildModule(new File(location.toOSString()), document, resource.getProject(), (IProgressMonitor)new NullProgressMonitor(), (IPythonNature)pythonNature);
        }
    }

    @Override
    public void visitAddedResource(IResource resource, ICallback0<IDocument> document, IProgressMonitor monitor) {
        this.visitChangedResource(resource, document, monitor);
    }

    @Override
    public void visitRemovedResource(IResource resource, ICallback0<IDocument> document, IProgressMonitor monitor) {
        ICodeCompletionASTManager astManager;
        PythonNature pythonNature = this.getPythonNature(resource);
        if (pythonNature != null && (astManager = pythonNature.getAstManager()) != null) {
            IPath location = resource.getLocation();
            astManager.removeModule(new File(location.toOSString()), resource.getProject(), (IProgressMonitor)new NullProgressMonitor());
        }
    }
}

