/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.codecompletion.revisited;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public final class PyPublicTreeMap<K, V>
extends AbstractMap<K, V>
implements SortedMap<K, V>,
Cloneable,
Serializable {
    private Comparator<? super K> comparator = null;
    private transient Entry<K, V> root = null;
    private transient int size = 0;
    private transient int modCount = 0;
    private volatile transient Set<Map.Entry<K, V>> entrySet = null;
    private static final boolean RED = false;
    private static final boolean BLACK = true;
    private static final long serialVersionUID = 919286545866124006L;

    private void incrementSize() {
        ++this.modCount;
        ++this.size;
    }

    private void decrementSize() {
        ++this.modCount;
        --this.size;
    }

    public PyPublicTreeMap() {
    }

    public PyPublicTreeMap(Comparator<? super K> c) {
        this.comparator = c;
    }

    public PyPublicTreeMap(Map<? extends K, ? extends V> m) {
        this.putAll(m);
    }

    public PyPublicTreeMap(SortedMap<K, ? extends V> m) {
        this.comparator = m.comparator();
        try {
            this.buildFromSorted(m.size(), m.entrySet().iterator(), null, null);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.root == null ? false : (value == null ? this.valueSearchNull(this.root) : this.valueSearchNonNull(this.root, value));
    }

    private boolean valueSearchNull(Entry<K, V> n) {
        if (n.value == null) {
            return true;
        }
        return n.left != null && this.valueSearchNull(n.left) || n.right != null && this.valueSearchNull(n.right);
    }

    private boolean valueSearchNonNull(Entry<K, V> n, Object value) {
        if (value.equals(n.value)) {
            return true;
        }
        return n.left != null && this.valueSearchNonNull(n.left, value) || n.right != null && this.valueSearchNonNull(n.right, value);
    }

    @Override
    public V get(Object key) {
        Entry<K, V> p = this.getEntry(key);
        return p == null ? null : (V)p.value;
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.comparator;
    }

    @Override
    public K firstKey() {
        return PyPublicTreeMap.key(this.firstEntry());
    }

    @Override
    public K lastKey() {
        return PyPublicTreeMap.key(this.lastEntry());
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Comparator c;
        int mapSize = map.size();
        if (this.size == 0 && mapSize != 0 && map instanceof SortedMap && ((c = ((SortedMap)map).comparator()) == this.comparator || c != null && c.equals(this.comparator))) {
            ++this.modCount;
            try {
                this.buildFromSorted(mapSize, map.entrySet().iterator(), null, null);
            }
            catch (IOException iOException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return;
        }
        super.putAll(map);
    }

    public Entry<K, V> getEntry(Object key) {
        Entry<K, V> p = this.root;
        Object k = key;
        while (p != null) {
            int cmp = this.compare(k, p.key);
            if (cmp == 0) {
                return p;
            }
            p = cmp < 0 ? p.left : p.right;
        }
        return null;
    }

    private Entry<K, V> getCeilEntry(K key) {
        Entry<K, V> p = this.root;
        if (p == null) {
            return null;
        }
        while (true) {
            int cmp;
            if ((cmp = this.compare(key, p.key)) == 0) {
                return p;
            }
            if (cmp < 0) {
                if (p.left != null) {
                    p = p.left;
                    continue;
                }
                return p;
            }
            if (p.right == null) break;
            p = p.right;
        }
        Entry parent = p.parent;
        Entry<K, V> ch = p;
        while (parent != null && ch == parent.right) {
            ch = parent;
            parent = parent.parent;
        }
        return parent;
    }

    private Entry<K, V> getPrecedingEntry(K key) {
        Entry<K, V> p = this.root;
        if (p == null) {
            return null;
        }
        while (true) {
            int cmp;
            if ((cmp = this.compare(key, p.key)) > 0) {
                if (p.right != null) {
                    p = p.right;
                    continue;
                }
                return p;
            }
            if (p.left == null) break;
            p = p.left;
        }
        Entry parent = p.parent;
        Entry<K, V> ch = p;
        while (parent != null && ch == parent.left) {
            ch = parent;
            parent = parent.parent;
        }
        return parent;
    }

    private static <K> K key(Entry<K, ?> e) {
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e.key;
    }

    @Override
    public V put(K key, V value) {
        Entry<K, V> t = this.root;
        if (t == null) {
            this.incrementSize();
            this.root = new Entry<K, V>(key, value, null);
            return null;
        }
        while (true) {
            int cmp;
            if ((cmp = this.compare(key, t.key)) == 0) {
                return t.setValue(value);
            }
            if (cmp < 0) {
                if (t.left != null) {
                    t = t.left;
                    continue;
                }
                this.incrementSize();
                t.left = new Entry<K, V>(key, value, t);
                this.fixAfterInsertion(t.left);
                return null;
            }
            if (t.right == null) break;
            t = t.right;
        }
        this.incrementSize();
        t.right = new Entry<K, V>(key, value, t);
        this.fixAfterInsertion(t.right);
        return null;
    }

    @Override
    public V remove(Object key) {
        Entry<K, V> p = this.getEntry(key);
        if (p == null) {
            return null;
        }
        Object oldValue = p.value;
        this.deleteEntry(p);
        return oldValue;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
        this.root = null;
    }

    @Override
    public Object clone() {
        PyPublicTreeMap clone = null;
        try {
            clone = (PyPublicTreeMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone.root = null;
        clone.size = 0;
        clone.modCount = 0;
        clone.entrySet = null;
        try {
            clone.buildFromSorted(this.size, this.entrySet().iterator(), null, null);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clone;
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return new KeyIterator();
            }

            @Override
            public int size() {
                return PyPublicTreeMap.this.size();
            }

            @Override
            public boolean contains(Object o) {
                return PyPublicTreeMap.this.containsKey(o);
            }

            @Override
            public boolean remove(Object o) {
                int oldSize = PyPublicTreeMap.this.size;
                PyPublicTreeMap.this.remove(o);
                return PyPublicTreeMap.this.size != oldSize;
            }

            @Override
            public void clear() {
                PyPublicTreeMap.this.clear();
            }
        };
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new ValueIterator();
            }

            @Override
            public int size() {
                return PyPublicTreeMap.this.size();
            }

            @Override
            public boolean contains(Object o) {
                Entry e = PyPublicTreeMap.this.firstEntry();
                while (e != null) {
                    if (PyPublicTreeMap.valEquals(e.getValue(), o)) {
                        return true;
                    }
                    e = PyPublicTreeMap.this.successor(e);
                }
                return false;
            }

            @Override
            public boolean remove(Object o) {
                Entry e = PyPublicTreeMap.this.firstEntry();
                while (e != null) {
                    if (PyPublicTreeMap.valEquals(e.getValue(), o)) {
                        PyPublicTreeMap.this.deleteEntry(e);
                        return true;
                    }
                    e = PyPublicTreeMap.this.successor(e);
                }
                return false;
            }

            @Override
            public void clear() {
                PyPublicTreeMap.this.clear();
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new EntryIterator();
                }

                @Override
                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object value = entry.getValue();
                    Entry p = PyPublicTreeMap.this.getEntry(entry.getKey());
                    return p != null && PyPublicTreeMap.valEquals(p.getValue(), value);
                }

                @Override
                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object value = entry.getValue();
                    Entry p = PyPublicTreeMap.this.getEntry(entry.getKey());
                    if (p != null && PyPublicTreeMap.valEquals(p.getValue(), value)) {
                        PyPublicTreeMap.this.deleteEntry(p);
                        return true;
                    }
                    return false;
                }

                @Override
                public int size() {
                    return PyPublicTreeMap.this.size();
                }

                @Override
                public void clear() {
                    PyPublicTreeMap.this.clear();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        return new SubMap(fromKey, toKey);
    }

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        return new SubMap(toKey, true);
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        return new SubMap(fromKey, false);
    }

    private int compare(K k1, K k2) {
        return this.comparator == null ? ((Comparable)k1).compareTo(k2) : this.comparator.compare(k1, k2);
    }

    private static boolean valEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    @Override
    private Entry<K, V> firstEntry() {
        Entry<K, V> p = this.root;
        if (p != null) {
            while (p.left != null) {
                p = p.left;
            }
        }
        return p;
    }

    @Override
    private Entry<K, V> lastEntry() {
        Entry<K, V> p = this.root;
        if (p != null) {
            while (p.right != null) {
                p = p.right;
            }
        }
        return p;
    }

    private Entry<K, V> successor(Entry<K, V> t) {
        if (t == null) {
            return null;
        }
        if (t.right != null) {
            Entry p = t.right;
            while (p.left != null) {
                p = p.left;
            }
            return p;
        }
        Entry p = t.parent;
        Entry<K, V> ch = t;
        while (p != null && ch == p.right) {
            ch = p;
            p = p.parent;
        }
        return p;
    }

    private static <K, V> boolean colorOf(Entry<K, V> p) {
        return p == null ? true : p.color;
    }

    private static <K, V> Entry<K, V> parentOf(Entry<K, V> p) {
        return p == null ? null : p.parent;
    }

    private static <K, V> void setColor(Entry<K, V> p, boolean c) {
        if (p != null) {
            p.color = c;
        }
    }

    private static <K, V> Entry<K, V> leftOf(Entry<K, V> p) {
        return p == null ? null : p.left;
    }

    private static <K, V> Entry<K, V> rightOf(Entry<K, V> p) {
        return p == null ? null : p.right;
    }

    private void rotateLeft(Entry<K, V> p) {
        Entry r = p.right;
        p.right = r.left;
        if (r.left != null) {
            r.left.parent = p;
        }
        r.parent = p.parent;
        if (p.parent == null) {
            this.root = r;
        } else if (p.parent.left == p) {
            p.parent.left = r;
        } else {
            p.parent.right = r;
        }
        r.left = p;
        p.parent = r;
    }

    private void rotateRight(Entry<K, V> p) {
        Entry l = p.left;
        p.left = l.right;
        if (l.right != null) {
            l.right.parent = p;
        }
        l.parent = p.parent;
        if (p.parent == null) {
            this.root = l;
        } else if (p.parent.right == p) {
            p.parent.right = l;
        } else {
            p.parent.left = l;
        }
        l.right = p;
        p.parent = l;
    }

    private void fixAfterInsertion(Entry<K, V> x) {
        x.color = false;
        while (x != null && x != this.root && !x.parent.color) {
            Entry<K, V> y;
            if (PyPublicTreeMap.parentOf(x) == PyPublicTreeMap.leftOf(PyPublicTreeMap.parentOf(PyPublicTreeMap.parentOf(x)))) {
                y = PyPublicTreeMap.rightOf(PyPublicTreeMap.parentOf(PyPublicTreeMap.parentOf(x)));
                if (!PyPublicTreeMap.colorOf(y)) {
                    PyPublicTreeMap.setColor(PyPublicTreeMap.parentOf(x), true);
                    PyPublicTreeMap.setColor(y, true);
                    PyPublicTreeMap.setColor(PyPublicTreeMap.parentOf(PyPublicTreeMap.parentOf(x)), false);
                    x = PyPublicTreeMap.parentOf(PyPublicTreeMap.parentOf(x));
                    continue;
                }
                if (x == PyPublicTreeMap.rightOf(PyPublicTreeMap.parentOf(x))) {
                    x = PyPublicTreeMap.parentOf(x);
                    this.rotateLeft(x);
                }
                PyPublicTreeMap.setColor(PyPublicTreeMap.parentOf(x), true);
                PyPublicTreeMap.setColor(PyPublicTreeMap.parentOf(PyPublicTreeMap.parentOf(x)), false);
                if (PyPublicTreeMap.parentOf(PyPublicTreeMap.parentOf(x)) == null) continue;
                this.rotateRight(PyPublicTreeMap.parentOf(PyPublicTreeMap.parentOf(x)));
                continue;
            }
            y = PyPublicTreeMap.leftOf(PyPublicTreeMap.parentOf(PyPublicTreeMap.parentOf(x)));
            if (!PyPublicTreeMap.colorOf(y)) {
                PyPublicTreeMap.setColor(PyPublicTreeMap.parentOf(x), true);
                PyPublicTreeMap.setColor(y, true);
                PyPublicTreeMap.setColor(PyPublicTreeMap.parentOf(PyPublicTreeMap.parentOf(x)), false);
                x = PyPublicTreeMap.parentOf(PyPublicTreeMap.parentOf(x));
                continue;
            }
            if (x == PyPublicTreeMap.leftOf(PyPublicTreeMap.parentOf(x))) {
                x = PyPublicTreeMap.parentOf(x);
                this.rotateRight(x);
            }
            PyPublicTreeMap.setColor(PyPublicTreeMap.parentOf(x), true);
            PyPublicTreeMap.setColor(PyPublicTreeMap.parentOf(PyPublicTreeMap.parentOf(x)), false);
            if (PyPublicTreeMap.parentOf(PyPublicTreeMap.parentOf(x)) == null) continue;
            this.rotateLeft(PyPublicTreeMap.parentOf(PyPublicTreeMap.parentOf(x)));
        }
        this.root.color = true;
    }

    private void deleteEntry(Entry<K, V> p) {
        Entry replacement;
        this.decrementSize();
        if (p.left != null && p.right != null) {
            Entry<K, V> s = this.successor(p);
            p.key = s.key;
            p.value = s.value;
            p = s;
        }
        Entry entry = replacement = p.left != null ? p.left : p.right;
        if (replacement != null) {
            replacement.parent = p.parent;
            if (p.parent == null) {
                this.root = replacement;
            } else if (p == p.parent.left) {
                p.parent.left = replacement;
            } else {
                p.parent.right = replacement;
            }
            p.parent = null;
            p.right = null;
            p.left = null;
            if (p.color) {
                this.fixAfterDeletion(replacement);
            }
        } else if (p.parent == null) {
            this.root = null;
        } else {
            if (p.color) {
                this.fixAfterDeletion(p);
            }
            if (p.parent != null) {
                if (p == p.parent.left) {
                    p.parent.left = null;
                } else if (p == p.parent.right) {
                    p.parent.right = null;
                }
                p.parent = null;
            }
        }
    }

    private void fixAfterDeletion(Entry<K, V> x) {
        while (x != this.root && PyPublicTreeMap.colorOf(x)) {
            Entry<K, V> sib;
            if (x == PyPublicTreeMap.leftOf(PyPublicTreeMap.parentOf(x))) {
                sib = PyPublicTreeMap.rightOf(PyPublicTreeMap.parentOf(x));
                if (!PyPublicTreeMap.colorOf(sib)) {
                    PyPublicTreeMap.setColor(sib, true);
                    PyPublicTreeMap.setColor(PyPublicTreeMap.parentOf(x), false);
                    this.rotateLeft(PyPublicTreeMap.parentOf(x));
                    sib = PyPublicTreeMap.rightOf(PyPublicTreeMap.parentOf(x));
                }
                if (PyPublicTreeMap.colorOf(PyPublicTreeMap.leftOf(sib)) && PyPublicTreeMap.colorOf(PyPublicTreeMap.rightOf(sib))) {
                    PyPublicTreeMap.setColor(sib, false);
                    x = PyPublicTreeMap.parentOf(x);
                    continue;
                }
                if (PyPublicTreeMap.colorOf(PyPublicTreeMap.rightOf(sib))) {
                    PyPublicTreeMap.setColor(PyPublicTreeMap.leftOf(sib), true);
                    PyPublicTreeMap.setColor(sib, false);
                    this.rotateRight(sib);
                    sib = PyPublicTreeMap.rightOf(PyPublicTreeMap.parentOf(x));
                }
                PyPublicTreeMap.setColor(sib, PyPublicTreeMap.colorOf(PyPublicTreeMap.parentOf(x)));
                PyPublicTreeMap.setColor(PyPublicTreeMap.parentOf(x), true);
                PyPublicTreeMap.setColor(PyPublicTreeMap.rightOf(sib), true);
                this.rotateLeft(PyPublicTreeMap.parentOf(x));
                x = this.root;
                continue;
            }
            sib = PyPublicTreeMap.leftOf(PyPublicTreeMap.parentOf(x));
            if (!PyPublicTreeMap.colorOf(sib)) {
                PyPublicTreeMap.setColor(sib, true);
                PyPublicTreeMap.setColor(PyPublicTreeMap.parentOf(x), false);
                this.rotateRight(PyPublicTreeMap.parentOf(x));
                sib = PyPublicTreeMap.leftOf(PyPublicTreeMap.parentOf(x));
            }
            if (PyPublicTreeMap.colorOf(PyPublicTreeMap.rightOf(sib)) && PyPublicTreeMap.colorOf(PyPublicTreeMap.leftOf(sib))) {
                PyPublicTreeMap.setColor(sib, false);
                x = PyPublicTreeMap.parentOf(x);
                continue;
            }
            if (PyPublicTreeMap.colorOf(PyPublicTreeMap.leftOf(sib))) {
                PyPublicTreeMap.setColor(PyPublicTreeMap.rightOf(sib), true);
                PyPublicTreeMap.setColor(sib, false);
                this.rotateLeft(sib);
                sib = PyPublicTreeMap.leftOf(PyPublicTreeMap.parentOf(x));
            }
            PyPublicTreeMap.setColor(sib, PyPublicTreeMap.colorOf(PyPublicTreeMap.parentOf(x)));
            PyPublicTreeMap.setColor(PyPublicTreeMap.parentOf(x), true);
            PyPublicTreeMap.setColor(PyPublicTreeMap.leftOf(sib), true);
            this.rotateRight(PyPublicTreeMap.parentOf(x));
            x = this.root;
        }
        PyPublicTreeMap.setColor(x, true);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size);
        for (Map.Entry<K, V> e : this.entrySet()) {
            s.writeObject(e.getKey());
            s.writeObject(e.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.buildFromSorted(size, null, s, null);
    }

    void readTreeSet(int size, ObjectInputStream s, V defaultVal) throws IOException, ClassNotFoundException {
        this.buildFromSorted(size, null, s, defaultVal);
    }

    void addAllForTreeSet(SortedSet<Map.Entry<K, V>> set, V defaultVal) {
        try {
            this.buildFromSorted(set.size(), set.iterator(), null, defaultVal);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void buildFromSorted(int size, Iterator it, ObjectInputStream str, V defaultVal) throws IOException, ClassNotFoundException {
        this.size = size;
        this.root = this.buildFromSorted(0, 0, size - 1, PyPublicTreeMap.computeRedLevel(size), it, str, defaultVal);
    }

    private final Entry<K, V> buildFromSorted(int level, int lo, int hi, int redLevel, Iterator it, ObjectInputStream str, V defaultVal) throws IOException, ClassNotFoundException {
        V value;
        Object key;
        if (hi < lo) {
            return null;
        }
        int mid = (lo + hi) / 2;
        Entry<K, V> left = null;
        if (lo < mid) {
            left = this.buildFromSorted(level + 1, lo, mid - 1, redLevel, it, str, defaultVal);
        }
        if (it != null) {
            if (defaultVal == null) {
                Map.Entry entry = (Map.Entry)it.next();
                key = entry.getKey();
                value = entry.getValue();
            } else {
                key = it.next();
                value = defaultVal;
            }
        } else {
            key = str.readObject();
            value = defaultVal != null ? defaultVal : str.readObject();
        }
        Entry<Object, V> middle = new Entry<Object, V>(key, value, null);
        if (level == redLevel) {
            middle.color = false;
        }
        if (left != null) {
            middle.left = left;
            left.parent = middle;
        }
        if (mid < hi) {
            Entry<K, V> right = this.buildFromSorted(level + 1, mid + 1, hi, redLevel, it, str, defaultVal);
            middle.right = right;
            right.parent = middle;
        }
        return middle;
    }

    private static int computeRedLevel(int sz) {
        int level = 0;
        int m = sz - 1;
        while (m >= 0) {
            ++level;
            m = m / 2 - 1;
        }
        return level;
    }

    static class Entry<K, V>
    implements Map.Entry<K, V> {
        K key;
        V value;
        Entry<K, V> left = null;
        Entry<K, V> right = null;
        Entry<K, V> parent;
        boolean color = true;

        Entry(K key, V value, Entry<K, V> parent) {
            this.key = key;
            this.value = value;
            this.parent = parent;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return PyPublicTreeMap.valEquals(this.key, e.getKey()) && PyPublicTreeMap.valEquals(this.value, e.getValue());
        }

        @Override
        public int hashCode() {
            int keyHash = this.key == null ? 0 : this.key.hashCode();
            int valueHash = this.value == null ? 0 : this.value.hashCode();
            return keyHash ^ valueHash;
        }

        public String toString() {
            return String.valueOf(this.key) + "=" + String.valueOf(this.value);
        }
    }

    private class EntryIterator
    extends PrivateEntryIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    private class KeyIterator
    extends PrivateEntryIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().key;
        }
    }

    private abstract class PrivateEntryIterator<T>
    implements Iterator<T> {
        private int expectedModCount;
        private Entry<K, V> lastReturned;
        Entry<K, V> next;

        PrivateEntryIterator() {
            this.expectedModCount = PyPublicTreeMap.this.modCount;
            this.lastReturned = null;
            this.next = PyPublicTreeMap.this.firstEntry();
        }

        PrivateEntryIterator(Entry<K, V> first) {
            this.expectedModCount = PyPublicTreeMap.this.modCount;
            this.lastReturned = null;
            this.next = first;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        final Entry<K, V> nextEntry() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            if (PyPublicTreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.lastReturned = this.next;
            this.next = PyPublicTreeMap.this.successor(this.next);
            return this.lastReturned;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (PyPublicTreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastReturned.left != null && this.lastReturned.right != null) {
                this.next = this.lastReturned;
            }
            PyPublicTreeMap.this.deleteEntry(this.lastReturned);
            ++this.expectedModCount;
            this.lastReturned = null;
        }
    }

    private class SubMap
    extends AbstractMap<K, V>
    implements SortedMap<K, V>,
    Serializable {
        private static final long serialVersionUID = -6520786458950516097L;
        private boolean fromStart = false;
        private boolean toEnd = false;
        private K fromKey;
        private K toKey;
        private transient Set<Map.Entry<K, V>> entrySet = new EntrySetView();

        SubMap(K fromKey, K toKey) {
            if (PyPublicTreeMap.this.compare(fromKey, toKey) > 0) {
                throw new IllegalArgumentException("fromKey > toKey");
            }
            this.fromKey = fromKey;
            this.toKey = toKey;
        }

        SubMap(K key, boolean headMap) {
            PyPublicTreeMap.this.compare(key, key);
            if (headMap) {
                this.fromStart = true;
                this.toKey = key;
            } else {
                this.toEnd = true;
                this.fromKey = key;
            }
        }

        SubMap(boolean fromStart, K fromKey, boolean toEnd, K toKey) {
            this.fromStart = fromStart;
            this.fromKey = fromKey;
            this.toEnd = toEnd;
            this.toKey = toKey;
        }

        @Override
        public boolean isEmpty() {
            return this.entrySet.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.inRange(key) && PyPublicTreeMap.this.containsKey(key);
        }

        @Override
        public V get(Object key) {
            if (!this.inRange(key)) {
                return null;
            }
            return PyPublicTreeMap.this.get(key);
        }

        @Override
        public V put(K key, V value) {
            if (!this.inRange(key)) {
                throw new IllegalArgumentException("key out of range");
            }
            return PyPublicTreeMap.this.put(key, value);
        }

        @Override
        public Comparator<? super K> comparator() {
            return PyPublicTreeMap.this.comparator;
        }

        @Override
        public K firstKey() {
            Entry e = this.fromStart ? PyPublicTreeMap.this.firstEntry() : PyPublicTreeMap.this.getCeilEntry(this.fromKey);
            Object first = PyPublicTreeMap.key(e);
            if (!this.toEnd && PyPublicTreeMap.this.compare(first, this.toKey) >= 0) {
                throw new NoSuchElementException();
            }
            return first;
        }

        @Override
        public K lastKey() {
            Entry e = this.toEnd ? PyPublicTreeMap.this.lastEntry() : PyPublicTreeMap.this.getPrecedingEntry(this.toKey);
            Object last = PyPublicTreeMap.key(e);
            if (!this.fromStart && PyPublicTreeMap.this.compare(last, this.fromKey) < 0) {
                throw new NoSuchElementException();
            }
            return last;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.entrySet;
        }

        @Override
        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            if (!this.inRange2(fromKey)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            if (!this.inRange2(toKey)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new SubMap(fromKey, toKey);
        }

        @Override
        public SortedMap<K, V> headMap(K toKey) {
            if (!this.inRange2(toKey)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new SubMap(this.fromStart, this.fromKey, false, toKey);
        }

        @Override
        public SortedMap<K, V> tailMap(K fromKey) {
            if (!this.inRange2(fromKey)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            return new SubMap(false, fromKey, this.toEnd, this.toKey);
        }

        private boolean inRange(K key) {
            return !(!this.fromStart && PyPublicTreeMap.this.compare(key, this.fromKey) < 0 || !this.toEnd && PyPublicTreeMap.this.compare(key, this.toKey) >= 0);
        }

        private boolean inRange2(K key) {
            return !(!this.fromStart && PyPublicTreeMap.this.compare(key, this.fromKey) < 0 || !this.toEnd && PyPublicTreeMap.this.compare(key, this.toKey) > 0);
        }

        private class EntrySetView
        extends AbstractSet<Map.Entry<K, V>> {
            private transient int size = -1;
            private transient int sizeModCount;

            private EntrySetView() {
            }

            @Override
            public int size() {
                if (this.size == -1 || this.sizeModCount != ((SubMap)SubMap.this).PyPublicTreeMap.this.modCount) {
                    this.size = 0;
                    this.sizeModCount = ((SubMap)SubMap.this).PyPublicTreeMap.this.modCount;
                    Iterator i = this.iterator();
                    while (i.hasNext()) {
                        ++this.size;
                        i.next();
                    }
                }
                return this.size;
            }

            @Override
            public boolean isEmpty() {
                return !this.iterator().hasNext();
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                Object key = entry.getKey();
                if (!SubMap.this.inRange(key)) {
                    return false;
                }
                Entry node = PyPublicTreeMap.this.getEntry(key);
                return node != null && PyPublicTreeMap.valEquals(node.getValue(), entry.getValue());
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                Object key = entry.getKey();
                if (!SubMap.this.inRange(key)) {
                    return false;
                }
                Entry node = PyPublicTreeMap.this.getEntry(key);
                if (node != null && PyPublicTreeMap.valEquals(node.getValue(), entry.getValue())) {
                    PyPublicTreeMap.this.deleteEntry(node);
                    return true;
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new SubMapEntryIterator(SubMap.this.fromStart ? PyPublicTreeMap.this.firstEntry() : PyPublicTreeMap.this.getCeilEntry(SubMap.this.fromKey), SubMap.this.toEnd ? null : PyPublicTreeMap.this.getCeilEntry(SubMap.this.toKey));
            }
        }
    }

    private class SubMapEntryIterator
    extends PrivateEntryIterator<Map.Entry<K, V>> {
        private final K firstExcludedKey;

        SubMapEntryIterator(Entry<K, V> first, Entry<K, V> firstExcluded) {
            super(first);
            this.firstExcludedKey = firstExcluded == null ? null : firstExcluded.key;
        }

        @Override
        public boolean hasNext() {
            return this.next != null && this.next.key != this.firstExcludedKey;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.next == null || this.next.key == this.firstExcludedKey) {
                throw new NoSuchElementException();
            }
            return this.nextEntry();
        }
    }

    private class ValueIterator
    extends PrivateEntryIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }
}

