/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.codecompletion.revisited;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.python.pydev.ast.codecompletion.IPythonModuleResolver;
import org.python.pydev.ast.codecompletion.revisited.ModulesFoundStructure;
import org.python.pydev.ast.listing_utils.PyFileListing;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.ModulesKeyForFolder;
import org.python.pydev.core.ModulesKeyForZip;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.preferences.FileTypesPreferences;
import org.python.pydev.plugin.PyStructureConfigHelpers;
import org.python.pydev.plugin.nature.IPythonPathHelper;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.FullRepIterable;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.OrderedMap;

public final class PythonPathHelper
implements IPythonPathHelper {
    private volatile List<String> pythonpath = Collections.unmodifiableList(new ArrayList());
    private List<IPath> searchPaths = Collections.unmodifiableList(new ArrayList());
    private transient IPythonModuleResolver[] pythonModuleResolvers;
    private final Object pythonModuleResolversLock = new Object();
    public static final int OPERATION_MOVE = 1;
    public static final int OPERATION_COPY = 2;
    public static final int OPERATION_DELETE = 3;

    public static String getDefaultPathStr(String str) {
        return StringUtils.replaceAllSlashes((String)str.trim());
    }

    public static PyFileListing getModulesBelow(File root, IProgressMonitor monitor, List<String> allPythonpathEntries) {
        if (!root.exists()) {
            return null;
        }
        if (root.isDirectory()) {
            final HashSet<File> otherRoots = new HashSet<File>();
            for (String p : allPythonpathEntries) {
                otherRoots.add(new File(p));
            }
            otherRoots.remove(root);
            PyFileListing.PyFileListingFilter filter = new PyFileListing.PyFileListingFilter(){

                @Override
                public boolean accept(java.nio.file.Path path, File file, boolean isDirectory) {
                    if (!isDirectory) {
                        return PythonPathHelper.isValidFileMod(file.toString());
                    }
                    if (otherRoots.contains(file)) {
                        return false;
                    }
                    return PythonPathHelper.isValidModuleLastPart(file.getName());
                }
            };
            return PyFileListing.getPyFilesBelow(root, filter, monitor);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static ModulesFoundStructure.ZipContents getFromZip(File root, IProgressMonitor monitor) {
        String fileName = root.getName();
        if (!root.isFile()) return null;
        if (!FileTypesPreferences.isValidZipFile((String)fileName)) return null;
        ModulesFoundStructure.ZipContents zipContents = new ModulesFoundStructure.ZipContents(root);
        zipContents.zipContentsType = ModulesFoundStructure.ZipContents.ZIP_CONTENTS_TYPE_PY_ZIP;
        try {
            String zipFileName = root.getName();
            try (ZipFile zipFile = new ZipFile(root);){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                int i = 0;
                FastStringBuffer buffer = new FastStringBuffer();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!entry.isDirectory()) {
                        if (PythonPathHelper.isValidFileMod(name) || name.endsWith(".class")) {
                            if (name.endsWith(".class")) {
                                zipContents.zipContentsType = ModulesFoundStructure.ZipContents.ZIP_CONTENTS_TYPE_JAR;
                            }
                            if (i % 15 == 0) {
                                if (monitor.isCanceled()) {
                                    return null;
                                }
                                buffer.clear();
                                monitor.setTaskName(buffer.append("Found in ").append(zipFileName).append(" module ").append(name).toString());
                                monitor.worked(1);
                            }
                            zipContents.pyFilesLowerToRegular.put(name.toLowerCase(), name);
                        }
                    } else {
                        zipContents.pyfoldersLower.add(name.toLowerCase());
                    }
                    ++i;
                }
            }
            zipContents.consolidatePythonpathInfo(monitor);
            return zipContents;
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return null;
    }

    public static boolean isValidSourceFile(String path) {
        return PythonPathHelper.isValidSourceFile(path, FileTypesPreferences.getDottedValidSourceFiles());
    }

    public static boolean isValidSourceFile(String path, String[] dottedValidSourceFiles) {
        int len = dottedValidSourceFiles.length;
        int i = 0;
        while (i < len) {
            if (path.endsWith(dottedValidSourceFiles[i])) {
                return true;
            }
            ++i;
        }
        if (path.endsWith(".pypredef")) {
            return true;
        }
        return path.endsWith(".pyi");
    }

    public static boolean isValidSourceFile(IFile file) {
        String ext = file.getFileExtension();
        if (ext == null) {
            return false;
        }
        ext = ext.toLowerCase();
        String[] validSourceFiles = FileTypesPreferences.getValidSourceFiles();
        int len = validSourceFiles.length;
        int i = 0;
        while (i < len) {
            String end = validSourceFiles[i];
            if (ext.equals(end)) {
                return true;
            }
            ++i;
        }
        if (ext.equals(".pypredef")) {
            return true;
        }
        return ext.equals(".pyi");
    }

    public static boolean isValidFileMod(String path) {
        boolean ret = false;
        if (PythonPathHelper.isValidSourceFile(path)) {
            ret = true;
        } else if (FileTypesPreferences.isValidDll((String)path)) {
            ret = true;
        }
        return ret;
    }

    public static String getValidName(String fileName) {
        return FullRepIterable.getFirstPart((String)fileName);
    }

    @Override
    public String resolveModule(String absoluteModuleLocation, IProject project) {
        return this.resolveModule(absoluteModuleLocation, false, this.getPythonpath(), project);
    }

    public String resolveModule(String absoluteModuleLocation, boolean requireFileToExist, IProject project) {
        return this.resolveModule(absoluteModuleLocation, requireFileToExist, this.getPythonpath(), project);
    }

    public String resolveModule(String absoluteModuleLocation, boolean requireFileToExist, List<String> baseLocations, IProject project) {
        File file = new File(absoluteModuleLocation);
        boolean fileExists = file.exists();
        if (requireFileToExist && !fileExists) {
            return null;
        }
        IPath modulePath = Path.fromOSString((String)FileUtils.getFileAbsolutePath((File)file));
        IPythonModuleResolver[] pythonModuleResolvers = this.getPythonModuleResolvers();
        if (pythonModuleResolvers.length > 0) {
            ArrayList<IPath> convertedBasePaths = new ArrayList<IPath>();
            for (String searchPath : baseLocations) {
                convertedBasePaths.add(Path.fromOSString((String)searchPath));
            }
            IPythonModuleResolver[] iPythonModuleResolverArray = pythonModuleResolvers;
            int n = pythonModuleResolvers.length;
            int n2 = 0;
            while (n2 < n) {
                IPythonModuleResolver resolver = iPythonModuleResolverArray[n2];
                String resolved = resolver.resolveModule(project, modulePath, convertedBasePaths);
                if (resolved != null) {
                    if (resolved.isEmpty()) {
                        return null;
                    }
                    return resolved;
                }
                ++n2;
            }
        }
        ArrayList<String> alternatives = new ArrayList<String>();
        block2: for (String pathEntry : baseLocations) {
            String name;
            IPath relative;
            IPath element = Path.fromOSString((String)FileUtils.getFileAbsolutePath((String)pathEntry));
            if (!FileUtils.isPrefixOf((IPath)element, (IPath)modulePath) || (relative = modulePath.removeFirstSegments(element.segmentCount())).segmentCount() == 0 || !PythonPathHelper.isValidModuleLastPart(name = PythonPathHelper.getValidName(relative.lastSegment()))) continue;
            if (relative.segmentCount() > 1) {
                IPath folderPath = relative.removeLastSegments(1);
                int segmentCount = folderPath.segmentCount();
                int i = 0;
                while (i < segmentCount) {
                    if (!PythonPathHelper.isValidModuleLastPart(folderPath.segment(i))) continue block2;
                    ++i;
                }
                String[] segments = relative.segments();
                segments[segments.length - 1] = name;
                alternatives.add(StringUtils.join((String)".", (String[])segments));
                continue;
            }
            alternatives.add(name);
        }
        int size = alternatives.size();
        if (size == 1) {
            return (String)alternatives.get(0);
        }
        if (size == 0) {
            return null;
        }
        String ret = null;
        for (String string : alternatives) {
            if (ret == null) {
                ret = string;
                continue;
            }
            if (string.length() >= ret.length()) continue;
            ret = string;
        }
        return ret;
    }

    public static String stripExtension(String s) {
        if (s != null) {
            return StringUtils.stripExtension((String)s);
        }
        return null;
    }

    public static File getFolderInit(File root) {
        String[] validInitFiles = FileTypesPreferences.getValidInitFiles();
        int len = validInitFiles.length;
        int i = 0;
        while (i < len) {
            String init = validInitFiles[i];
            File f = new File(root, init);
            if (f.exists()) {
                return f;
            }
            ++i;
        }
        return null;
    }

    public static IFile getFolderInit(IContainer root) {
        String[] validInitFiles = FileTypesPreferences.getValidInitFiles();
        int len = validInitFiles.length;
        int i = 0;
        while (i < len) {
            String init = validInitFiles[i];
            IFile f = root.getFile((IPath)new Path(init));
            if (f.exists()) {
                return f;
            }
            ++i;
        }
        return null;
    }

    public static boolean isValidInitFile(String path) {
        String[] validInitFiles = FileTypesPreferences.getValidInitFiles();
        int len = validInitFiles.length;
        int i = 0;
        while (i < len) {
            String init = validInitFiles[i];
            if (path.endsWith(init)) {
                char c;
                int index = path.length() - init.length() - 1;
                return index < 0 || (c = path.charAt(index)) == '/' || c == '\\';
            }
            ++i;
        }
        return false;
    }

    public static boolean isValidModuleLastPart(String s) {
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c == '-' || c == ' ' || c == '.' || c == '+') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setPythonPath(List<String> newPythonpath) {
        this.pythonpath = Collections.unmodifiableList(new ArrayList<String>(newPythonpath));
        this.fixSearchPaths();
    }

    private void fixSearchPaths() {
        List<String> pathStrings = this.getPythonpath();
        ArrayList<IPath> searchPaths = new ArrayList<IPath>(pathStrings.size());
        for (String searchPath : pathStrings) {
            searchPaths.add(Path.fromOSString((String)searchPath));
        }
        this.searchPaths = Collections.unmodifiableList(searchPaths);
    }

    @Override
    public void setPythonPath(String string) {
        this.setPythonPath(PythonPathHelper.parsePythonPathFromStr(string, new ArrayList<String>()));
    }

    public static List<String> parsePythonPathFromStr(String string, List<String> lPath) {
        if (lPath == null) {
            lPath = new ArrayList<String>();
        }
        String[] strings = string.split("\\|");
        int i = 0;
        while (i < strings.length) {
            String defaultPathStr = PythonPathHelper.getDefaultPathStr(strings[i]);
            if (defaultPathStr != null && defaultPathStr.trim().length() > 0) {
                File file = new File(defaultPathStr);
                if (file.exists()) {
                    String path = FileUtils.getFileAbsolutePath((File)file);
                    lPath.add(path);
                } else {
                    lPath.add(defaultPathStr);
                }
            }
            ++i;
        }
        return lPath;
    }

    @Override
    public List<String> getPythonpath() {
        return this.pythonpath;
    }

    @Override
    public ModulesFoundStructure getModulesFoundStructure(IProgressMonitor monitor) {
        return this.getModulesFoundStructure(null, monitor);
    }

    public ModulesFoundStructure getModulesFoundStructure(IProject project, IProgressMonitor monitor) {
        IPythonModuleResolver[] pythonModuleResolvers;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((pythonModuleResolvers = this.getPythonModuleResolvers()).length > 0) {
            List<IPath> searchPaths = this.searchPaths;
            IPythonModuleResolver[] iPythonModuleResolverArray = pythonModuleResolvers;
            int n = pythonModuleResolvers.length;
            int n2 = 0;
            while (n2 < n) {
                IPythonModuleResolver finder = iPythonModuleResolverArray[n2];
                Collection<IPath> modulesAndZips = finder.findAllModules(project, monitor);
                if (modulesAndZips != null) {
                    ModulesFoundStructure modulesFoundStructure = new ModulesFoundStructure();
                    for (IPath moduleOrZip : modulesAndZips) {
                        File moduleOrZipFile = moduleOrZip.toFile();
                        if (FileTypesPreferences.isValidZipFile((String)moduleOrZip.toOSString())) {
                            ModulesFoundStructure.ZipContents zipContents = PythonPathHelper.getFromZip(moduleOrZipFile, monitor);
                            if (zipContents == null) continue;
                            modulesFoundStructure.zipContents.add(zipContents);
                            continue;
                        }
                        String qualifiedName = finder.resolveModule(project, moduleOrZip, searchPaths);
                        if (qualifiedName == null || qualifiedName.isEmpty()) continue;
                        modulesFoundStructure.regularModules.put(moduleOrZipFile, qualifiedName);
                    }
                    return modulesFoundStructure;
                }
                ++n2;
            }
        }
        ModulesFoundStructure ret = new ModulesFoundStructure();
        List<String> pythonpathList = this.getPythonpath();
        FastStringBuffer tempBuf = new FastStringBuffer();
        for (String element : pythonpathList) {
            if (monitor.isCanceled()) break;
            File root = new File(element);
            PyFileListing below = PythonPathHelper.getModulesBelow(root, monitor, pythonpathList);
            if (below != null) {
                for (PyFileListing.PyFileInfo pyFileInfo : below.getFoundPyFileInfos()) {
                    File file = pyFileInfo.getFile();
                    String modName = pyFileInfo.getModuleName(tempBuf);
                    if (!PythonPathHelper.isValidModuleLastPart(FullRepIterable.getLastPart((String)modName))) continue;
                    String existing = ret.regularModules.get(file);
                    if (existing != null) {
                        if (existing.length() >= modName.length()) continue;
                        ret.regularModules.put(file, modName);
                        continue;
                    }
                    ret.regularModules.put(file, modName);
                }
                continue;
            }
            ModulesFoundStructure.ZipContents zipContents = PythonPathHelper.getFromZip(root, monitor);
            if (zipContents == null) continue;
            ret.zipContents.add(zipContents);
        }
        return ret;
    }

    public void loadFromFile(File pythonpatHelperFile) throws IOException {
        String fileContents = FileUtils.getFileContents((File)pythonpatHelperFile);
        if (fileContents == null || fileContents.trim().length() == 0) {
            throw new IOException("No loaded contents from: " + String.valueOf(pythonpatHelperFile));
        }
        this.setPythonPath(StringUtils.split((String)fileContents, (char)'\n'));
    }

    public void saveToFile(File pythonpatHelperFile) {
        FileUtils.writeStrToFile((String)StringUtils.join((String)"\n", this.pythonpath), (File)pythonpatHelperFile);
    }

    public static boolean canAddAstInfoForSourceModule(ModulesKey key) {
        if (key.file != null && key.file.exists()) {
            if (key instanceof ModulesKeyForFolder) {
                return true;
            }
            if (PythonPathHelper.isValidSourceFile(key.file.getName())) {
                return true;
            }
            boolean isZipModule = key instanceof ModulesKeyForZip;
            if (isZipModule) {
                ModulesKeyForZip modulesKeyForZip = (ModulesKeyForZip)key;
                if (PythonPathHelper.isValidSourceFile(modulesKeyForZip.zipModulePath)) {
                    return true;
                }
            }
        }
        return false;
    }

    private static OrderedMap<String, String> getResourcePythonPathMap(Map<IProject, OrderedMap<String, String>> projectSourcePathMapsCache, IResource resource) {
        IProject project = resource.getProject();
        OrderedMap sourceMap = projectSourcePathMapsCache.get(project);
        if (sourceMap == null) {
            IPythonPathNature pythonPathNature = PythonNature.getPythonPathNature(project);
            if (pythonPathNature == null) {
                sourceMap = new OrderedMap();
            } else {
                try {
                    sourceMap = pythonPathNature.getProjectSourcePathResolvedToUnresolvedMap();
                }
                catch (CoreException e) {
                    sourceMap = new OrderedMap();
                    Log.log((Throwable)e);
                }
            }
            projectSourcePathMapsCache.put(project, (OrderedMap<String, String>)sourceMap);
        }
        return sourceMap;
    }

    public static void updatePyPath(IResource[] copiedResources, IContainer destination, int operation) {
        try {
            HashMap<IProject, OrderedMap<String, String>> projectSourcePathMapsCache = new HashMap<IProject, OrderedMap<String, String>>();
            ArrayList<String> addToDestProjects = new ArrayList<String>();
            HashSet<IProject> changed = new HashSet<IProject>();
            IResource[] iResourceArray = copiedResources;
            int n = copiedResources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IFolder) {
                    OrderedMap<String, String> sourceMap = PythonPathHelper.getResourcePythonPathMap(projectSourcePathMapsCache, resource);
                    Set keySet = sourceMap.keySet();
                    Iterator it = keySet.iterator();
                    while (it.hasNext()) {
                        String next = (String)it.next();
                        IPath existingInPath = Path.fromPortableString((String)next);
                        if (!FileUtils.isPrefixOf((IPath)resource.getFullPath(), (IPath)existingInPath)) continue;
                        if (operation == 1 || operation == 3) {
                            it.remove();
                            changed.add(resource.getProject());
                        }
                        if (operation != 2 && operation != 1) continue;
                        String addToNewProjectPath = destination.getFullPath().append(existingInPath.removeFirstSegments(resource.getFullPath().segmentCount() - 1)).toPortableString();
                        addToDestProjects.add(addToNewProjectPath);
                    }
                }
                ++n2;
            }
            if (operation != 3) {
                OrderedMap<String, String> destSourceMap = PythonPathHelper.getResourcePythonPathMap(projectSourcePathMapsCache, (IResource)destination);
                IProject destProject = destination.getProject();
                for (String addToNewProjectPath : addToDestProjects) {
                    String destActualPath = PyStructureConfigHelpers.convertToProjectRelativePath(destProject.getFullPath().toPortableString(), addToNewProjectPath);
                    destSourceMap.put((Object)addToNewProjectPath, (Object)destActualPath);
                    changed.add(destProject);
                }
            }
            for (IProject project : changed) {
                OrderedMap<String, String> sourceMap = PythonPathHelper.getResourcePythonPathMap(projectSourcePathMapsCache, (IResource)project);
                PythonNature nature = PythonNature.getPythonNature(project);
                if (nature == null) continue;
                nature.getPythonPathNature().setProjectSourcePath(StringUtils.join((String)"|", (Collection)sourceMap.values()));
                nature.rebuildPath();
            }
        }
        catch (Exception e) {
            Log.log((int)4, (String)"Unexpected error setting project properties", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPythonModuleResolver[] getPythonModuleResolvers() {
        if (this.pythonModuleResolvers != null) {
            return this.pythonModuleResolvers;
        }
        Object object = this.pythonModuleResolversLock;
        synchronized (object) {
            if (this.pythonModuleResolvers != null) {
                return this.pythonModuleResolvers;
            }
            ArrayList<IPythonModuleResolver> tempPythonModuleResolvers = new ArrayList<IPythonModuleResolver>();
            List resolvers = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_python_module_resolver");
            for (Object resolver : resolvers) {
                if (!(resolver instanceof IPythonModuleResolver)) continue;
                tempPythonModuleResolvers.add((IPythonModuleResolver)resolver);
            }
            this.pythonModuleResolvers = tempPythonModuleResolvers.toArray(new IPythonModuleResolver[0]);
            return this.pythonModuleResolvers;
        }
    }
}

