/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.codecompletion.revisited;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;
import org.python.pydev.ast.codecompletion.revisited.ManagerInfoToUpdate;
import org.python.pydev.ast.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.ast.codecompletion.revisited.SyncSystemModulesManager;
import org.python.pydev.ast.interpreter_managers.InterpreterManagersAPI;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IInterpreterManagerListener;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.preferences.InterpreterGeneralPreferences;
import org.python.pydev.core.preferences.PydevPrefs;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.path_watch.IFilesystemChangesListener;
import org.python.pydev.shared_core.path_watch.IPathWatch;
import org.python.pydev.shared_core.path_watch.PathWatch;
import org.python.pydev.shared_core.structure.DataAndImageTreeNode;
import org.python.pydev.shared_core.structure.TreeNode;
import org.python.pydev.shared_core.utils.ThreadPriorityHelper;

public class SyncSystemModulesManagerScheduler
implements IInterpreterManagerListener {
    private final IPathWatch pathWatch = new PathWatch();
    private final SynchJob job = new SynchJob("Sync System PYTHONPATH");
    private static final FileFilter filter = new PyFilesFilter();
    private static final FileFilter dirFilter = new PyDirFilter();
    private final Map<IInterpreterManager, List<InfoTracker>> managerToPathsTracker = new HashMap<IInterpreterManager, List<InfoTracker>>();
    private final IInfoTrackerListener fListener = new IInfoTrackerListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChangedIInterpreterInfo(InfoTracker infoTracker, File file) {
            SyncSystemModulesManagerScheduler.this.job.addToTrack(infoTracker.manager, infoTracker.info);
            if (file.exists() && file.isDirectory()) {
                long lastModified;
                SyncSystemModulesManagerScheduler.this.job.scheduleLater(1000L);
                long lastFound = 0L;
                while (lastFound != (lastModified = FileUtils.getLastModifiedTimeFromDir((File)file, (FileFilter)filter, (FileFilter)dirFilter, (int)2))) {
                    lastFound = lastModified;
                    1 var7_5 = this;
                    synchronized (var7_5) {
                        try {
                            this.wait(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (lastFound == 0L) {
                        return;
                    }
                    SyncSystemModulesManagerScheduler.this.job.scheduleLater(1000L);
                }
            } else {
                SyncSystemModulesManagerScheduler.this.job.scheduleLater(5000L);
            }
        }
    };
    private final Object lockSetInfos = new Object();

    public SyncSystemModulesManagerScheduler() {
        this.pathWatch.setDirectoryFileFilter(filter, dirFilter);
    }

    private void registerInterpreterManager(IInterpreterManager iInterpreterManager, IInterpreterInfo[] interpreterInfos) {
        this.afterSetInfos(iInterpreterManager, interpreterInfos);
        iInterpreterManager.addListener((IInterpreterManagerListener)this);
    }

    public void start() {
        IInterpreterManager[] managers;
        boolean scheduleInitially = false;
        boolean reCheckOnFilesystemChanges = InterpreterGeneralPreferences.getReCheckOnFilesystemChanges();
        IInterpreterManager[] iInterpreterManagerArray = managers = InterpreterManagersAPI.getAllInterpreterManagers();
        int n = managers.length;
        int n2 = 0;
        while (n2 < n) {
            IInterpreterManager iInterpreterManager = iInterpreterManagerArray[n2];
            if (iInterpreterManager != null) {
                IInterpreterInfo[] interpreterInfos = iInterpreterManager.getInterpreterInfos();
                if (reCheckOnFilesystemChanges) {
                    this.registerInterpreterManager(iInterpreterManager, interpreterInfos);
                }
                scheduleInitially = scheduleInitially || interpreterInfos != null && interpreterInfos.length > 0;
            }
            ++n2;
        }
        int timeout = 30000;
        IEclipsePreferences preferences = PydevPrefs.getEclipsePreferences();
        boolean alreadyChecked = preferences.getBoolean("INTERPRETERS_CHECKED_ONCE", false);
        boolean force = false;
        if (!alreadyChecked) {
            preferences.putBoolean("INTERPRETERS_CHECKED_ONCE", true);
            force = true;
            timeout = 7000;
        }
        if ((force || InterpreterGeneralPreferences.getCheckConsistentOnStartup()) && scheduleInitially) {
            this.job.addAllToTrack();
            this.job.scheduleLater(timeout);
        }
    }

    public void addToCheck(IInterpreterManager manager, IInterpreterInfo[] infos) {
        IInterpreterInfo[] iInterpreterInfoArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            IInterpreterInfo info = iInterpreterInfoArray[n2];
            this.job.addToTrack(manager, info);
            ++n2;
        }
        this.job.scheduleLater(4000L);
    }

    public void checkAllNow() {
        Map<IInterpreterManager, Map<String, IInterpreterInfo>> addedToTrack = this.job.addAllToTrack();
        Set<Map.Entry<IInterpreterManager, Map<String, IInterpreterInfo>>> entrySet = addedToTrack.entrySet();
        IEclipsePreferences preferences = PydevPrefs.getEclipsePreferences();
        for (Map.Entry<IInterpreterManager, Map<String, IInterpreterInfo>> entry : entrySet) {
            Set<Map.Entry<String, IInterpreterInfo>> entrySet2 = entry.getValue().entrySet();
            for (Map.Entry<String, IInterpreterInfo> entry2 : entrySet2) {
                String key = SyncSystemModulesManager.createKeyForInfo(entry2.getValue());
                preferences.put(key, "");
            }
        }
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            Log.log((Throwable)e);
        }
        this.job.scheduleLater(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.job.cancel();
        IInterpreterManager[] managers = InterpreterManagersAPI.getAllInterpreterManagers();
        Object object = this.lockSetInfos;
        synchronized (object) {
            IInterpreterManager[] iInterpreterManagerArray = managers;
            int n = managers.length;
            int n2 = 0;
            while (n2 < n) {
                IInterpreterManager iInterpreterManager = iInterpreterManagerArray[n2];
                if (iInterpreterManager != null) {
                    this.stopTrack(iInterpreterManager, this.pathWatch);
                }
                ++n2;
            }
        }
        this.pathWatch.dispose();
    }

    public void afterSetInfos(IInterpreterManager manager, IInterpreterInfo[] interpreterInfos) {
        this.afterSetInfos(manager, interpreterInfos, this.fListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterSetInfos(IInterpreterManager manager, IInterpreterInfo[] interpreterInfos, IInfoTrackerListener listener) {
        Object object = this.lockSetInfos;
        synchronized (object) {
            this.stopTrack(manager, this.pathWatch);
            ArrayList<InfoTracker> currTrackers = new ArrayList<InfoTracker>();
            this.managerToPathsTracker.put(manager, currTrackers);
            IInterpreterInfo[] iInterpreterInfoArray = interpreterInfos;
            int n = interpreterInfos.length;
            int n2 = 0;
            while (n2 < n) {
                IInterpreterInfo info = iInterpreterInfoArray[n2];
                List pythonPath = info.getPythonPath();
                InfoTracker tracker = new InfoTracker(manager, info, listener);
                for (String string : pythonPath) {
                    File f = new File(string);
                    tracker.registerTracking(f);
                    this.pathWatch.track(f, (IFilesystemChangesListener)tracker);
                    currTrackers.add(tracker);
                }
                ++n2;
            }
        }
    }

    private void stopTrack(IInterpreterManager manager, IPathWatch pathWatch) {
        List<InfoTracker> currTrackers = this.managerToPathsTracker.remove(manager);
        if (currTrackers != null) {
            for (InfoTracker infoTracker : currTrackers) {
                for (File f : infoTracker.filepathsTracked) {
                    pathWatch.stopTrack(f, (IFilesystemChangesListener)infoTracker);
                }
            }
        }
    }

    public static interface IInfoTrackerListener {
        public void onChangedIInterpreterInfo(InfoTracker var1, File var2);
    }

    public static final class InfoTracker
    implements IFilesystemChangesListener {
        public final IInterpreterInfo info;
        public final IInterpreterManager manager;
        public final List<File> filepathsTracked = new ArrayList<File>();
        private final IInfoTrackerListener listener;

        public InfoTracker(IInterpreterManager manager, IInterpreterInfo info, IInfoTrackerListener listener) {
            this.manager = manager;
            this.info = info;
            this.listener = listener;
        }

        public void added(File file) {
            this.listener.onChangedIInterpreterInfo(this, file);
        }

        public void removed(File file) {
            this.listener.onChangedIInterpreterInfo(this, file);
        }

        public void registerTracking(File f) {
            this.filepathsTracked.add(f);
        }
    }

    private static final class PyDirFilter
    implements FileFilter {
        private PyDirFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    }

    private static final class PyFilesFilter
    implements FileFilter {
        private PyFilesFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            String name = pathname.getName();
            return PythonPathHelper.isValidFileMod(name) || name.endsWith(".pth");
        }
    }

    private static final class SynchJob
    extends Job {
        private final SyncSystemModulesManager fSynchManager = new SyncSystemModulesManager();
        private Object fManagerToNameToInfoLock = new Object();
        private Map<IInterpreterManager, Map<String, IInterpreterInfo>> fManagerToNameToInfo = null;
        private Thread scheduleThread;
        private volatile long runAt;
        private final Object scheduleThreadLock = new Object();

        private SynchJob(String name) {
            super(name);
            this.setPriority(40);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            ManagerInfoToUpdate managerToNameToInfo;
            boolean selectingElementsInDialog = this.fSynchManager.getSelectingElementsInDialog();
            if (selectingElementsInDialog) {
                this.scheduleLater(20000L);
                return Status.OK_STATUS;
            }
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            Object object = this.fManagerToNameToInfoLock;
            synchronized (object) {
                if (this.fManagerToNameToInfo == null || this.fManagerToNameToInfo.size() == 0) {
                    return Status.OK_STATUS;
                }
                managerToNameToInfo = new ManagerInfoToUpdate(this.fManagerToNameToInfo);
                this.fManagerToNameToInfo = null;
            }
            long initialTime = System.currentTimeMillis();
            ThreadPriorityHelper priorityHelper = new ThreadPriorityHelper(this.getThread());
            priorityHelper.setMinPriority();
            try {
                DataAndImageTreeNode root = new DataAndImageTreeNode(null, null, null);
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                this.fSynchManager.updateStructures(monitor, root, managerToNameToInfo, new SyncSystemModulesManager.CreateInterpreterInfoCallback());
                long delta = System.currentTimeMillis() - initialTime;
                ArrayList<TreeNode> initialSelection = new ArrayList(0);
                if (root.hasChildren()) {
                    initialSelection = this.fSynchManager.createInitialSelectionForDialogConsideringPreviouslyIgnored(root, PydevPrefs.getEclipsePreferences());
                }
                if (root.hasChildren() && initialSelection.size() > 0) {
                    this.fSynchManager.asyncSelectAndScheduleElementsToChangePythonpath(root, managerToNameToInfo, initialSelection);
                } else {
                    this.fSynchManager.synchronizeManagerToNameToInfoPythonpath(monitor, managerToNameToInfo, null);
                }
            }
            finally {
                priorityHelper.restoreInitialPriority();
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<IInterpreterManager, Map<String, IInterpreterInfo>> addAllToTrack() {
            Object object = this.fManagerToNameToInfoLock;
            synchronized (object) {
                this.fManagerToNameToInfo = InterpreterManagersAPI.getInterpreterManagerToInterpreterNameToInfo();
                HashMap<IInterpreterManager, Map<String, IInterpreterInfo>> copy = new HashMap<IInterpreterManager, Map<String, IInterpreterInfo>>();
                Set<Map.Entry<IInterpreterManager, Map<String, IInterpreterInfo>>> entrySet = this.fManagerToNameToInfo.entrySet();
                for (Map.Entry<IInterpreterManager, Map<String, IInterpreterInfo>> entry : entrySet) {
                    HashMap<String, IInterpreterInfo> value = new HashMap<String, IInterpreterInfo>(entry.getValue());
                    copy.put(entry.getKey(), value);
                }
                return copy;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addToTrack(IInterpreterManager manager, IInterpreterInfo info) {
            Object object = this.fManagerToNameToInfoLock;
            synchronized (object) {
                Map<String, IInterpreterInfo> map;
                if (this.fManagerToNameToInfo == null) {
                    this.fManagerToNameToInfo = new HashMap<IInterpreterManager, Map<String, IInterpreterInfo>>();
                }
                if ((map = this.fManagerToNameToInfo.get(manager)) == null) {
                    map = new HashMap<String, IInterpreterInfo>();
                    this.fManagerToNameToInfo.put(manager, map);
                }
                map.put(info.getName(), info);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleLater(long millis) {
            this.runAt = System.currentTimeMillis() + millis;
            Object object = this.scheduleThreadLock;
            synchronized (object) {
                if (this.scheduleThread == null) {
                    this.scheduleThread = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                long currentTimeMillis = System.currentTimeMillis();
                                long delta = currentTimeMillis - runAt;
                                while (delta < 0L) {
                                    try {
                                        1.sleep(250L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    currentTimeMillis = System.currentTimeMillis();
                                    delta = currentTimeMillis - runAt;
                                }
                                Object object = scheduleThreadLock;
                                synchronized (object) {
                                    this.schedule();
                                    scheduleThread = null;
                                }
                            }
                            catch (Exception e) {
                                Log.log((Throwable)e);
                            }
                        }
                    };
                    this.scheduleThread.start();
                }
            }
        }
    }
}

