/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.codecompletion.revisited;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.python.pydev.ast.codecompletion.revisited.ModulesManager;
import org.python.pydev.ast.codecompletion.revisited.ModulesManagerWithBuild;
import org.python.pydev.ast.codecompletion.revisited.PyPublicTreeMap;
import org.python.pydev.ast.codecompletion.revisited.modules.AbstractModule;
import org.python.pydev.ast.codecompletion.revisited.modules.CompiledModule;
import org.python.pydev.ast.codecompletion.revisited.modules.EmptyModule;
import org.python.pydev.ast.codecompletion.revisited.modules.PredefinedSourceModule;
import org.python.pydev.ast.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.ast.interpreter_managers.InterpreterInfo;
import org.python.pydev.ast.interpreter_managers.InterpreterManagersAPI;
import org.python.pydev.ast.interpreter_managers.TypeshedLoader;
import org.python.pydev.core.DeltaSaver;
import org.python.pydev.core.FileUtilsFileBuffer;
import org.python.pydev.core.IDeltaProcessor;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModuleRequestState;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.ISystemModulesManager;
import org.python.pydev.core.IToken;
import org.python.pydev.core.IterTokenEntry;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.TokensList;
import org.python.pydev.core.log.Log;
import org.python.pydev.parser.PyParser;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.plugin.nature.SystemPythonNature;
import org.python.pydev.shared_core.cache.LRUCache;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.FullRepIterable;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;

public final class SystemModulesManager
extends ModulesManagerWithBuild
implements ISystemModulesManager {
    private static final String DIR_NAME_FOR_COMPILED_CACHE = "shell";
    private transient IPythonNature nature;
    private InterpreterInfo info;
    private final LRUCache<String, String> builtinsNotConsidered = new LRUCache(500);
    private transient Map<File, Long> predefinedFilesNotParsedToTimestamp;

    public SystemModulesManager(InterpreterInfo info) {
        this.info = info;
    }

    public void setInfo(InterpreterInfo info) {
        this.info = info;
    }

    public InterpreterInfo getInfo() {
        return this.info;
    }

    public void endProcessing() {
        this.save();
    }

    public IModulesManager[] getManagersInvolved(boolean checkSystemManager) {
        return new IModulesManager[]{this};
    }

    public String[] getBuiltins() {
        return this.info.getBuiltins();
    }

    public Set<String> getBuiltinsAsSet() {
        return this.info.getBuiltinsAsSet();
    }

    public void setPythonNature(IPythonNature nature) {
        Assert.isTrue((boolean)(nature instanceof SystemPythonNature));
        Assert.isTrue((((SystemPythonNature)nature).info == this.info ? 1 : 0) != 0);
        this.nature = nature;
    }

    public IPythonNature getNature() {
        if (this.nature == null) {
            IInterpreterManager manager = this.getInterpreterManager();
            this.nature = new SystemPythonNature(manager, this.info);
        }
        return this.nature;
    }

    public IInterpreterManager getInterpreterManager() {
        int interpreterType = this.info.getInterpreterType();
        switch (interpreterType) {
            case 1: {
                return InterpreterManagersAPI.getJythonInterpreterManager();
            }
            case 0: {
                return InterpreterManagersAPI.getPythonInterpreterManager();
            }
            case 2: {
                return InterpreterManagersAPI.getIronpythonInterpreterManager();
            }
        }
        throw new RuntimeException("Don't know how to handle: " + interpreterType);
    }

    public ISystemModulesManager getSystemModulesManager() {
        return this;
    }

    public IModule getModule(String name, IPythonNature nature, boolean checkSystemManager, boolean dontSearchInit, IModuleRequestState moduleRequest) {
        return this.getModule(name, nature, dontSearchInit, moduleRequest);
    }

    public String resolveModule(String full, boolean checkSystemManager) {
        return super.resolveModule(full);
    }

    public List<String> getCompletePythonPath(IInterpreterInfo interpreter, IInterpreterManager manager) {
        if (interpreter == null) {
            throw new RuntimeException("The interpreter must be specified (received null)");
        }
        return interpreter.getPythonPath();
    }

    public IModule getRelativeModule(String name, IPythonNature nature, IModuleRequestState moduleRequest) {
        return super.getModule(name, nature, true, moduleRequest);
    }

    @Override
    protected void onChangePythonpath(SortedMap<ModulesKey, ModulesKey> keys) {
        String[] builtins = this.getBuiltins();
        if (builtins != null) {
            int i = 0;
            while (i < builtins.length) {
                String name = builtins[i];
                ModulesKey k = new ModulesKey(name, null);
                keys.put(k, k);
                ++i;
            }
        }
        super.onChangePythonpath(keys);
    }

    private boolean contains(TokensList tokens, String rep) {
        for (IterTokenEntry entry : tokens) {
            IToken token = entry.getToken();
            if (!token.getRepresentation().equals(rep)) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public AbstractModule getBuiltinModule(String name, boolean dontSearchInit, IModuleRequestState moduleRequest) {
        n = null;
        builtins = this.getBuiltins();
        if (builtins == null || this.info == null) {
            return null;
        }
        keyForCacheAccess = new ModulesKey(null, null);
        predefinedModule = this.info.getPredefinedModuleFile(name, moduleRequest);
        v0 = found = predefinedModule != null && predefinedModule.exists() != false;
        if (!found && !name.endsWith(".__init__")) {
            nameWithInit = new FastStringBuffer(name, 10).append(".__init__").toString();
            predefinedModule = this.info.getPredefinedModuleFile(nameWithInit, moduleRequest);
            v1 = found = predefinedModule != null && predefinedModule.exists() != false;
            if (found) {
                name = nameWithInit;
            }
        }
        finalName = name;
        if (found) {
            keyForCacheAccess.name = finalName;
            keyForCacheAccess.file = predefinedModule;
            n = SystemModulesManager.cachePredefined.getObj(keyForCacheAccess, this);
            if (n instanceof PredefinedSourceModule && (predefinedSourceModule = (PredefinedSourceModule)n).isSynched()) {
                return n;
            }
            tryToParse = true;
            lastModified = null;
            if (this.predefinedFilesNotParsedToTimestamp == null) {
                this.predefinedFilesNotParsedToTimestamp = new HashMap<File, Long>();
            } else {
                lastTimeChanged = this.predefinedFilesNotParsedToTimestamp.get(predefinedModule);
                if (lastTimeChanged != null) {
                    lastModified = FileUtils.lastModified((File)predefinedModule);
                    if (lastTimeChanged.equals(lastModified)) {
                        tryToParse = false;
                    } else {
                        this.predefinedFilesNotParsedToTimestamp.remove(predefinedModule);
                    }
                }
            }
            if (tryToParse) {
                try {
                    doc = FileUtilsFileBuffer.getDocFromFile((File)predefinedModule);
                    provider = new IGrammarVersionProvider(){

                        public int getGrammarVersion() throws MisconfigurationException {
                            return 107;
                        }

                        public IGrammarVersionProvider.AdditionalGrammarVersionsToCheck getAdditionalGrammarVersions() throws MisconfigurationException {
                            return null;
                        }
                    };
                    obj = PyParser.parseFull((PyParser.ParserInfo)new PyParser.ParserInfo(doc, provider, finalName, predefinedModule));
                    if (obj.error != null) {
                        if (lastModified == null) {
                            lastModified = FileUtils.lastModified((File)predefinedModule);
                        }
                        this.predefinedFilesNotParsedToTimestamp.put(predefinedModule, lastModified);
                        Log.log((String)("Unable to parse: " + String.valueOf(predefinedModule)), (Throwable)obj.error);
                    } else if (obj.ast != null) {
                        ast = (SimpleNode)obj.ast;
                        if ("builtins".equals(finalName)) {
                            TypeshedLoader.fixBuiltinsAST(ast, this, this.info);
                        } else if ("typing".equals(finalName)) {
                            TypeshedLoader.fixTypingAST(ast, this, this.info);
                        } else {
                            TypeshedLoader.fixAST(ast, this, this.info);
                        }
                        n = new PredefinedSourceModule(finalName, predefinedModule, ast, obj.error, this.nature);
                        SystemModulesManager.cachePredefined.add(keyForCacheAccess, n, this);
                        return n;
                    }
                }
                catch (Throwable e) {
                    Log.log((Throwable)e);
                }
            }
        }
        builtinsAsSet = this.getBuiltinsAsSet();
        it = new FullRepIterable(finalName, true).iterator();
        if (it.hasNext()) {
            check = (String)it.next();
            if (builtinsAsSet.contains(check)) {
                keyForCacheAccess.name = check;
                n = SystemModulesManager.cache.getObj(keyForCacheAccess, this);
                if (n == null && !dontSearchInit) {
                    keyForCacheAccess.name = new FastStringBuffer(check, 10).append(".__init__").toString();
                    n = SystemModulesManager.cache.getObj(keyForCacheAccess, this);
                }
                if (n == null || n instanceof EmptyModule || n instanceof SourceModule) {
                    n = new CompiledModule(check, this, this.getNature());
                    this.doAddSingleModule(new ModulesKey(n.getName(), null), n);
                    return n;
                }
            }
            if (n instanceof CompiledModule) {
                return n;
            }
        }
        if (this.builtinsNotConsidered.getObj((Object)finalName) == null) ** GOTO lbl90
        return null;
lbl-1000:
        // 1 sources

        {
            check = (String)it.next();
            if (!builtinsAsSet.contains(check)) continue;
            n = new CompiledModule(finalName, this, this.getNature());
            globalTokens = n.getGlobalTokens();
            if (globalTokens.size() > 0 && this.contains(globalTokens, "__file__")) {
                this.doAddSingleModule(new ModulesKey(finalName, null), n);
                return n;
            }
            this.builtinsNotConsidered.add((Object)finalName, (Object)finalName);
            return null;
lbl90:
            // 2 sources

            ** while (it.hasNext())
        }
lbl91:
        // 1 sources

        return null;
    }

    @Override
    public IModule getModule(String name, IPythonNature nature, boolean dontSearchInit, IModuleRequestState moduleRequest) {
        AbstractModule n = this.getBuiltinModule(name, dontSearchInit, moduleRequest);
        if (n != null) {
            return n;
        }
        return super.getModule(name, nature, dontSearchInit, moduleRequest);
    }

    public IModule getModuleWithoutBuiltins(String name, IPythonNature nature, boolean dontSearchInit, IModuleRequestState moduleRequest) {
        return super.getModule(name, nature, dontSearchInit, moduleRequest);
    }

    public Tuple<IModule, IModulesManager> getModuleAndRelatedModulesManager(String name, IPythonNature nature, boolean checkSystemManager, boolean dontSearchInit, IModuleRequestState moduleRequest) {
        IModule module = this.getModule(name, nature, checkSystemManager, dontSearchInit, moduleRequest);
        if (module != null) {
            return new Tuple((Object)module, (Object)this);
        }
        return null;
    }

    public void load() throws IOException {
        File workspaceMetadataFile = this.getIoDirectory();
        ModulesManager.loadFromFile(this, workspaceMetadataFile);
        DeltaSaver d = this.deltaSaver = new DeltaSaver(this.getIoDirectory(), "v1_sys_astdelta", readFromFileMethod, toFileMethod);
        d.processDeltas((IDeltaProcessor)this);
    }

    public void save() {
        File workspaceMetadataFile = this.getIoDirectory();
        DeltaSaver d = this.deltaSaver;
        if (d != null) {
            d.clearAll();
        }
        this.saveToFile(workspaceMetadataFile);
    }

    public File getIoDirectory() {
        return this.info.getIoDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateKeysAndSave(PyPublicTreeMap<ModulesKey, ModulesKey> keysFound) {
        Object object = this.modulesKeysLock;
        synchronized (object) {
            this.modulesKeys.clear();
            this.modulesKeys.putAll(keysFound);
        }
        this.save();
    }

    @Override
    public void changePythonPath(String pythonpath, IProject project, IProgressMonitor monitor) {
        block6: {
            try {
                File[] files;
                File d;
                File ioDirectory = this.getIoDirectory();
                if (ioDirectory == null || !(d = new File(ioDirectory, DIR_NAME_FOR_COMPILED_CACHE)).exists() || (files = d.listFiles()) == null) break block6;
                int i = 0;
                while (i < files.length) {
                    File f = files[i];
                    if (f.isFile()) {
                        try {
                            FileUtils.deleteFile((File)f);
                        }
                        catch (IOException e) {
                            Log.log((Throwable)e);
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        super.changePythonPath(pythonpath, project, monitor);
    }

    public File getCompiledModuleCacheFile(String name) {
        File ioDirectory = this.getIoDirectory();
        if (ioDirectory != null) {
            File d = new File(ioDirectory, DIR_NAME_FOR_COMPILED_CACHE);
            if (!d.exists()) {
                d.mkdirs();
            }
            int len = name.length();
            String pre = "";
            if (len >= 3) {
                pre = name.substring(0, 3);
            } else if (len >= 2) {
                pre = name.substring(0, 2);
            } else if (len >= 1) {
                pre = name.substring(0, 1);
            }
            String post = name.contains(".") ? ".top" : ".inn";
            return new File(d, StringUtils.join((String)"", (Object[])new Object[]{pre, "_", StringUtils.md5((String)name), post}));
        }
        return null;
    }
}

